/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.SimpleGateway;
import com.aem.shelp.util.SimpleGatewayInstallerV3;
import com.aem.shelp.util.SimpleGatewayVisibilityDialog;
import com.aem.shelp.util.service.SimpleServiceOutputParser;
import com.aem.utils.CronTabUtil;
import com.simplehelp.macos.MacOSServiceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import jwrapper.logging.ProcessOutputUtil;
import utils.message.Message;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;
import utils.swing.images.ImageLoader;
import utils.vm.VMFork;

public class SimpleGatewayUninstallerV3
extends Thread {
    public static Message getUninstallMessage(String logFileLocation, byte[] translations) {
        Message message = new Message();
        message.append(logFileLocation);
        message.append(translations);
        return message;
    }

    private static ProcessOutputUtil initLog(File logFile) throws FileNotFoundException {
        ProcessOutputUtil output = new ProcessOutputUtil("SimpleGatewayUninstaller", logFile);
        output.logMessage("Created log file: " + logFile.getAbsolutePath());
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSGInstallation(Message message) throws FileNotFoundException {
        ProcessOutputUtil outputUtil = null;
        outputUtil = SimpleGatewayUninstallerV3.initLog(new File((String)message.get(0)));
        try {
            byte[] translations = (byte[])message.get(1);
            Language.DEFLANG_SRC = translations;
            Language.DEFLANG = new SafeResourceBundle(new ByteArrayInputStream(Language.DEFLANG_SRC));
            File installDir = SimpleGateway.getV3InstallLocation();
            if (!SimpleGateway.canWriteToDir(SimpleGateway.getV3InstallLocation())) {
                throw new IOException("SimpleGateway Uninstall: Access Denied.");
            }
            outputUtil.logMessage("[SimpleGatewayUninstaller] Showing visibility dialog");
            SimpleGatewayInstallerV3.CancelListener cl = new SimpleGatewayInstallerV3.CancelListener();
            try {
                SimpleGatewayVisibilityDialog vv;
                cl.vv = vv = new SimpleGatewayVisibilityDialog(Language.get("PERSISTENT_CONNECTION_REMOVED_TITLE"), Language.get("CANCEL"), ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,48"), Language.get("PERSISTENT_CONNECTION_REMOVED_MESSAGE"), ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"));
                vv.addActionListener(cl);
                vv.setVisible(true);
                try {
                    Object object = cl.NOTIFY;
                    synchronized (object) {
                        cl.NOTIFY.wait(5000L);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                vv.setVisible(false);
            }
            catch (Throwable t) {
                outputUtil.logMessage("Error showing visibility dialog: " + t.getMessage());
                t.printStackTrace();
            }
            if (!cl.cancelled) {
                SimpleGatewayUninstallerV3.removeNow(installDir.getAbsolutePath(), outputUtil);
                outputUtil.writeResult(1);
            }
        }
        catch (Throwable t) {
            if (outputUtil != null) {
                outputUtil.writeResult(2);
                outputUtil.logMessage(t.getMessage());
                outputUtil.logError(t.getMessage());
                outputUtil.logStackTrace(t);
            }
        }
        finally {
            if (outputUtil != null) {
                outputUtil.close();
            }
        }
    }

    private static void removeNow(String dir, ProcessOutputUtil outputUtil) throws Exception {
        if (!new File(dir + "\\gatewaystart.bat").exists() && !new File(dir + "/gatewaystart.sh").exists()) {
            if ((new File("./gatewaystart.sh").exists() || new File(".\\gatewaystart.bat").exists()) && (dir = new File(".").getCanonicalPath()).endsWith(File.separator)) {
                dir = dir.substring(dir.length() - 1);
            }
            if ((new File("../../gatewaystart.sh").exists() || new File("..\\..\\gatewaystart.bat").exists()) && (dir = new File(".." + File.separator + ".." + File.separator).getCanonicalPath()).endsWith(File.separator)) {
                dir = dir.substring(dir.length() - 1);
            }
        }
        String javaExe = VMFork.getJavaExe();
        if (OS.isWindows()) {
            outputUtil.logMessage("[SimpleGatewayUninstaller] Removing gatewaystart.bat");
            new File(dir + File.separator + "gatewaystart.bat").delete();
            File simpleServiceFile = new File(dir, "SimpleService.exe");
            if (!simpleServiceFile.exists()) {
                simpleServiceFile = new File(dir + File.separator + "lib", "SimpleService.exe");
            }
            if (!simpleServiceFile.exists()) {
                simpleServiceFile = new File(dir + File.separator + "service", "SimpleService.exe");
            }
            outputUtil.logMessage("[SimpleGatewayUninstaller] Removing Windows service");
            Process p = Runtime.getRuntime().exec(new String[]{simpleServiceFile.getAbsolutePath(), "-uninstall", "sgateway.service"}, null, new File(dir));
            new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.out);
            SimpleServiceOutputParser out = new SimpleServiceOutputParser(p);
            p.waitFor();
            try {
                out.parse();
            }
            catch (IOException t) {
                Throwable tt = t.getCause();
                if (tt == null) {
                    throw t;
                }
                String message = SimpleGatewayUninstallerV3.getStacktrace(tt);
                if (message.indexOf("1060:") != -1) {
                    outputUtil.logMessage("[SimpleGatewayUninstaller] No existing service found");
                }
                throw t;
            }
        } else if (OS.isMacOS()) {
            File cronFile = new File(dir + "/cron/cronStart.sh");
            if (cronFile.exists()) {
                outputUtil.logMessage("[SimpleGatewayUninstaller] Removing cron entry");
                CronTabUtil.removeRebootCronJob((String)("sh " + dir + "/cron/cronStart.sh"));
            }
            outputUtil.startLogMessage();
            MacOSServiceManager.removeAgent((String)"SimpleHelpService", (PrintStream)outputUtil.getPrintStream());
            outputUtil.endLogMessage();
            outputUtil.logMessage("[SimpleGatewayUninstaller] Stopping service");
            Process p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib" + File.separator + "customer.jar", "com.aem.sgateway.SimpleGatewayServiceStop"}, null, new File(dir));
            new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.out);
            outputUtil.logMessage("[SimpleGatewayUninstaller] Removing gatewaystart.sh");
            new File(dir + File.separator + "gatewaystart.sh").delete();
        } else {
            outputUtil.logMessage("[SimpleGatewayUninstaller] Stopping service");
            Process p = Runtime.getRuntime().exec(new String[]{javaExe, "-cp", "lib" + File.separator + "customer.jar", "com.aem.sgateway.SimpleGatewayServiceStop"}, null, new File(dir));
            new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.out);
            outputUtil.logMessage("[SimpleGatewayUninstaller] Removing gatewaystart.sh");
            new File(dir + File.separator + "gatewaystart.sh").delete();
            outputUtil.logMessage("[SimpleGatewayUninstaller] Removing cron entry");
            CronTabUtil.removeRebootCronJob((String)("sh " + dir + "/cron/cronStart.sh"));
        }
    }

    private static String getStacktrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }
}

