/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import bcutil.BCUtil;
import com.aem.BuildDateUtil;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.shelp.util.GenericSync;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.switches.LocalSwitches;
import utils.udp.Acculog;

public class SHelpNodelinkPatcher
implements Runnable {
    String host;
    int port;
    Thread th;
    NodeLink nonudp;
    Exception x;

    private SHelpNodelinkPatcher(String host, int port) {
        this.host = host;
        this.port = port;
        this.th = new Thread(this);
        this.th.start();
    }

    public static SHelpNodelinkPatcher establishConnection(String host, int port) {
        return new SHelpNodelinkPatcher(host, port);
    }

    @Override
    public void run() {
        try {
            this.nonudp = SHelpNodelinkConnector.getSpecificConnection(-1, this.host, this.port, null);
            OutputStream out = this.nonudp.getOutputStream();
            StreamUtils.writeLong(out, BuildDateUtil.getPatchMagicBuildDate());
            out.flush();
            InputStream in = this.nonudp.getInputStream();
            try {
                if (BuildDateUtil.getPatchMagicBuildDate() != StreamUtils.readLong(in)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
            }
        }
        catch (Exception x) {
            try {
                this.nonudp.stop("initial shell NL closed by patcher due to some failure " + x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.x = x;
        }
    }

    public static void issuePatchRequestAndWait(NodeLink nonudp, long patchID, int fwdID, NodeLink directSocket, Node associate, boolean isBasePatch) throws Exception {
        OutputStream serverOut = nonudp.getOutputStream();
        NodeLinkConversation notifyC = new NodeLinkConversation(fwdID);
        nonudp.getMyNode().setConversationOpen(notifyC, System.currentTimeMillis() + 50000L);
        StreamUtils.writeLong(serverOut, patchID);
        StreamUtils.writeInt(serverOut, fwdID);
        if (directSocket != null) {
            StreamUtils.writeInt(serverOut, directSocket.getConversation());
        } else {
            StreamUtils.writeInt(serverOut, NodeLink.peekNextSessionKey());
        }
        StreamUtils.writeStringUTF8(serverOut, associate.getUID());
        StreamUtils.writeBoolean(serverOut, isBasePatch);
        serverOut.flush();
        System.out.println("[NL Patch] Waiting for patch setup notification from server (" + fwdID + ")");
        byte[] dat = nonudp.getMyNode().nextPacketFromSpecific(notifyC, 40000L);
        System.out.println("[NL Patch] Patch " + fwdID + " is ready (" + dat.length + " = 123?)");
    }

    public NodeLink finishPatch(boolean server, int patchID, NodeLink directSocket, InputStream syncIn, OutputStream syncOut, Node associate, boolean isBasePatch) throws Exception {
        return this.finishPatch(server, patchID, directSocket, null, syncIn, syncOut, associate, isBasePatch);
    }

    public NodeLink finishPatch(boolean server, int patchID, NodeLink directSocket, GenericSync gsync, Node associate, boolean isBasePatch) throws Exception {
        return this.finishPatch(server, patchID, directSocket, gsync, null, null, associate, isBasePatch);
    }

    private NodeLink finishPatch(boolean server, int patchID, NodeLink directSocket, GenericSync gsync, InputStream syncIn, OutputStream syncOut, Node associate, boolean isBasePatch) throws Exception {
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[NL] Patch requested, waiting for NL connection to work with");
        }
        this.th.join();
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[NL] Got NL connection for patching");
        }
        if (this.x != null) {
            throw this.x;
        }
        int fwdID = BCUtil.getSecureRandom().nextInt();
        SHelpNodelinkPatcher.issuePatchRequestAndWait(this.nonudp, patchID, fwdID, directSocket, associate, isBasePatch);
        if (directSocket == null) {
            System.out.println("[NL Patch] Establishing a direct socket from new");
            Node myhome = this.nonudp.getMyNode();
            Node mytarget = this.nonudp.getTargetNode();
            System.out.println("[NL Patch] Killing new socket");
            try {
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[NL] Clearing and stopping Node");
                }
                this.nonudp.clearNodeAndStop("direct shell NL closed after patch");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[NL Patch] Using fwd ID " + fwdID);
            myhome.useForwardingID(fwdID);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[NL] Syncing with remote");
            }
            if (gsync != null) {
                gsync.syncWithRemoteNow();
            } else {
                StreamUtils.writeBoolean(syncOut, true);
                syncOut.flush();
                StreamUtils.readBoolean(syncIn);
            }
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[NL] Establishing new line to remote using fwd ID (ProxyServer will forward NL packets rather than 2x NL)");
            }
            System.out.println("[NL Patch] Trying to establish new socket from " + myhome + " to " + mytarget + " using fwd ID");
            directSocket = server ? new NodeLink(myhome, 40000, (long)NodeLink.DEFAULT_RECONNECT_TIMEOUT, false, false) : new NodeLink(myhome, mytarget, 40000, (long)NodeLink.DEFAULT_RECONNECT_TIMEOUT, false, false, true);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[NL] Patch finished");
            }
            directSocket.getStats().type = this.nonudp.getStats().type;
        }
        return directSocket;
    }
}

