/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.SimpleRegex;
import java.util.regex.Pattern;

public class PatternWrapper {
    private Pattern pattern;
    private String originalRegex;

    public PatternWrapper(String regex, boolean caseSensitive) {
        this.pattern = SimpleRegex.simpleToPattern(regex, caseSensitive);
        this.originalRegex = regex;
    }

    public String getRegularExpression() {
        return this.originalRegex;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.originalRegex;
    }

    public boolean equals(Object o) {
        if (o instanceof PatternWrapper) {
            PatternWrapper wrapper = (PatternWrapper)o;
            return wrapper.pattern.pattern().equals(this.pattern.pattern()) && wrapper.originalRegex.equals(this.originalRegex);
        }
        return false;
    }

    public static PatternWrapper[] join(PatternWrapper[] wrapper1, PatternWrapper[] wrapper2) {
        if (wrapper1 == null && wrapper2 == null) {
            return new PatternWrapper[0];
        }
        if (wrapper1 == null) {
            return wrapper2;
        }
        if (wrapper2 == null) {
            return wrapper1;
        }
        PatternWrapper[] wrappers = new PatternWrapper[wrapper1.length + wrapper2.length];
        System.arraycopy(wrapper1, 0, wrappers, 0, wrapper1.length);
        System.arraycopy(wrapper2, 0, wrappers, wrapper1.length, wrapper2.length);
        return wrappers;
    }
}

