/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkConversation;
import com.aem.nodelink.utils.BlockingByteInputStreamHashMap;
import com.aem.shelp.util.SHelpUdpNlNatHPFwdInterface;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageUtils;

public class ObsoleteShServerNodeTransactor
implements SHelpUdpNlNatHPFwdInterface {
    Node assocNode;
    Node node;
    Node target;
    BlockingByteInputStreamHashMap map = new BlockingByteInputStreamHashMap();

    public ObsoleteShServerNodeTransactor(Node assocNode, NodeLink nl) {
        this.assocNode = assocNode;
        this.node = nl.getMyNode();
        this.target = nl.getTargetNode();
    }

    public ObsoleteShServerNodeTransactor(Node assocNode, Node node, Node target) {
        this.assocNode = assocNode;
        this.node = node;
        this.target = target;
    }

    @Override
    public void cancelForwardingRule(int FID) throws Exception {
        System.out.println("[SH Node Transact] Cancelling forward rule");
        NodeLinkConversation conv = new NodeLinkConversation(55430010);
        Message msg = new Message(55430012);
        msg.append(FID);
        this.node.setConversationOpen(conv, System.currentTimeMillis() + 20000L);
        this.node.sendToSpecific(MessageUtils.messageToBytes((Message)msg), this.target, conv, 15000L, true);
    }

    @Override
    public int createForwardingRule() throws Exception {
        System.out.println("[SH Node Transact] Requesting new rule");
        NodeLinkConversation conv = new NodeLinkConversation(55430010);
        Message msg = new Message(55430011);
        msg.append(this.node.getUID());
        msg.append(this.assocNode.getUID());
        this.node.setConversationOpen(conv, System.currentTimeMillis() + 20000L);
        this.node.sendToSpecific(MessageUtils.messageToBytes((Message)msg), this.target, conv, 15000L, true);
        byte[] packet = this.node.nextPacketFromSpecific(conv, 7000L);
        try {
            if (packet == null) {
                throw new Exception("no response from server");
            }
            msg = MessageUtils.bytesToMessage((byte[])packet);
            int FID = msg.getNextInt();
            System.out.println("[SH Node Transact] Got rule " + FID);
            return FID;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new IOException("Unable to set up UDP forwarding on server " + x);
        }
    }
}

