/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class EasyDateTimeFormatter {
    private static final SimpleDateFormat DATE_SDF = new SimpleDateFormat("dd MMM yyyy");
    private static final DateFormat TIME_SDF = DateFormat.getTimeInstance(3);
    private Calendar nowCalendar = GregorianCalendar.getInstance();
    private Calendar dateCalendar = GregorianCalendar.getInstance();

    public String formatDateTime(long timeMS) {
        return this.formatDate(timeMS) + " " + this.formatTime(timeMS);
    }

    public String formatDate(long timeMS) {
        long currentTime = System.currentTimeMillis();
        this.nowCalendar.setTimeInMillis(currentTime);
        this.dateCalendar.setTimeInMillis(timeMS);
        if (Math.abs(currentTime - timeMS) < 172800000L) {
            if (EasyDateTimeFormatter.isYesterday(this.nowCalendar, this.dateCalendar)) {
                return Language.get("YESTERDAY");
            }
            if (EasyDateTimeFormatter.isToday(this.nowCalendar, this.dateCalendar)) {
                return Language.get("TODAY");
            }
            if (EasyDateTimeFormatter.isTomorrow(this.nowCalendar, this.dateCalendar)) {
                return Language.get("TOMORROW");
            }
        }
        return DATE_SDF.format(new Date(timeMS));
    }

    public String formatTime(long timeMS) {
        return TIME_SDF.format(new Date(timeMS));
    }

    public static boolean isYesterday(Calendar today, Calendar other) {
        other = (Calendar)other.clone();
        other.add(5, 1);
        return EasyDateTimeFormatter.isToday(today, other);
    }

    public static boolean isTomorrow(Calendar today, Calendar other) {
        other = (Calendar)other.clone();
        other.add(5, -1);
        return EasyDateTimeFormatter.isToday(today, other);
    }

    public static boolean isToday(Calendar today, Calendar other) {
        return today.get(1) == other.get(1) && today.get(6) == other.get(6);
    }

    public static void main(String[] args) throws IOException {
        SafeResourceBundle.loadTestBundle();
        EasyDateTimeFormatter formatter = new EasyDateTimeFormatter();
        System.out.println(formatter.formatDateTime(System.currentTimeMillis()));
        for (int i = -10; i < 10; ++i) {
            System.out.println(formatter.formatDateTime(System.currentTimeMillis() + (long)(i * 5 * 60 * 60 * 1000)));
        }
    }
}

