/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

public class RecordingTimer {
    private long totalRecordedTime = 0L;
    private long startTime = -1L;

    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void lap() {
        if (this.startTime == -1L) {
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        this.startTime = now;
        this.totalRecordedTime += diff;
    }

    public synchronized void end() {
        long diff = System.currentTimeMillis() - this.startTime;
        this.totalRecordedTime += diff;
        this.startTime = -1L;
    }

    public synchronized long getTotalRecordedTime() {
        this.lap();
        return this.totalRecordedTime;
    }
}

