/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters.simplemachinemodel;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNode;
import com.aem.shelp.tech.utils.filters.simplemachinemodel.SimpleMachineNodeListener;
import utils.message.Message;

public class MachineNode
extends SimpleMachineNode {
    public transient String machineName;
    public String machineID;

    public MachineNode(SimpleMachineNodeListener listener, String name, String id) {
        super(listener);
        this.machineName = name;
        this.machineID = id;
    }

    public void groundWith(MachineTreeModel model) {
        Machine m = (Machine)model.getElementWithID(this.machineID);
        if (m != null) {
            this.machineName = m.getMachineName().getName();
        }
    }

    public MachineNode(SimpleMachineNodeListener listener, Message m) {
        super(listener);
        this.machineID = m.getNextString();
        super.fromMessage(m);
        if (m.hasNext()) {
            this.machineName = m.getNextString();
        }
    }

    @Override
    public Message toMessage() {
        Message m = new Message(0);
        m.append(this.machineID);
        super.toMessage(m);
        m.append(this.machineName);
        return m;
    }

    public String toString() {
        if (this.machineName != null) {
            return this.machineName;
        }
        return this.machineID;
    }

    @Override
    public SimpleMachineNode replicate() {
        MachineNode node = new MachineNode(null, this.machineName, this.machineID);
        node.setState(this.getState());
        return node;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MachineNode) {
            return ((MachineNode)o).machineID.equals(this.machineID);
        }
        return false;
    }

    @Override
    public void setState(Boolean state) {
        super.setState(state);
        if (state == null) {
            this.parent.removeChild(this);
        }
    }
}

