/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.utils.SummaryBlobLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.images.ImageLoader;
import utils.swing.layout.WrapLayout;

public class MachinesSummaryLabel {
    private int maxElements = -1;
    private JPanel rootComponent = new JPanel();
    private Machine[] machines;
    private MachineGroup[] machineGroups;
    private boolean oneLine;
    private Color tagColor = SHStyle.PANEL_BACKGROUND_BLUE;
    private Border labelBorder = SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)5);

    public MachinesSummaryLabel(boolean oneLine, int maxElements) {
        this.oneLine = oneLine;
        this.maxElements = maxElements;
    }

    public void setPickedMachinesAndGroups(Machine[] machines, MachineGroup[] machineGroups) {
        this.machineGroups = machineGroups;
        this.machines = machines;
        if (this.oneLine) {
            this.rootComponent.setLayout((LayoutManager)new ScaledFlowLayout(0, 0, 0));
        } else {
            this.rootComponent.setLayout(new WrapLayout(0, 0, 0));
        }
        this.initUI();
    }

    public void setTagColor(Color color) {
        this.tagColor = color;
    }

    public void initUI() {
        int count = 0;
        if (this.machines != null) {
            count += this.machines.length;
        }
        if (this.machineGroups != null) {
            count += this.machineGroups.length;
        }
        this.rootComponent.removeAll();
        if (this.maxElements == -1 || count < this.maxElements) {
            SummaryBlobLabel label;
            if (this.machines != null && this.machines.length > 0) {
                for (Machine machine : this.machines) {
                    label = new SummaryBlobLabel(machine.getMachineName().getName(), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"), this.tagColor);
                    label.setBackground(this.rootComponent.getBackground());
                    label.setBorder(this.labelBorder);
                    this.rootComponent.add(label);
                    if (this.maxElements != -1 && ++count > this.maxElements) break;
                }
            }
            if ((this.maxElements == -1 || count < this.maxElements) && this.machineGroups != null && this.machineGroups.length > 0) {
                for (MachineGroup group : this.machineGroups) {
                    label = new SummaryBlobLabel(group.groupName, ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"), this.tagColor);
                    label.setBackground(this.rootComponent.getBackground());
                    label.setBorder(this.labelBorder);
                    this.rootComponent.add(label);
                    if (this.maxElements == -1 || ++count <= this.maxElements) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            SummaryBlobLabel label;
            if (this.machines != null && this.machines.length > 0) {
                label = this.machines.length > 1 ? new SummaryBlobLabel(this.machines.length + " " + Language.get("MACHINES_SHORT"), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"), this.tagColor) : new SummaryBlobLabel(this.machines.length + " " + Language.get("MACHINE_SHORT"), ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"), this.tagColor);
                label.setBackground(this.rootComponent.getBackground());
                label.setBorder(this.labelBorder);
                this.rootComponent.add(label);
            }
            if (this.machineGroups != null && this.machineGroups.length > 0) {
                label = this.machineGroups.length > 1 ? new SummaryBlobLabel(this.machineGroups.length + " " + Language.get("MACHINE_GROUPS_SHORT"), ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"), this.tagColor) : new SummaryBlobLabel(this.machineGroups.length + " " + Language.get("MACHINE_GROUP_SHORT"), ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"), this.tagColor);
                label.setBackground(this.rootComponent.getBackground());
                label.setBorder(this.labelBorder);
                this.rootComponent.add(label);
            }
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
    }

    public void setVisible(boolean b) {
        this.rootComponent.setVisible(b);
    }

    public void setBackground(Color innerBorderColor) {
        this.rootComponent.setBackground(innerBorderColor);
    }
}

