/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.RootPaneContainer;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.FailoverMonitor;
import jwrapper.updater.JWLaunchProperties;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class FailoverDialog
extends OKCancelDialogPanel {
    private final long maxTimeoutEndTime;
    private final long autoSwitchTimeMS;
    private final RootPaneContainer rootPane;
    private AbstractGlassDialog dialog;
    private JButton waitButton;
    private JButton waitLongerButton;
    private long delay = 0L;
    private AutoAcceptThread autoAcceptThread = null;
    private final Object AUTO_ACCEPT_LOCK = new Object();

    public FailoverDialog(RootPaneContainer rootPane, long maxTimeoutEndTime, long autoSwitchTimeMS) {
        super(Language.get("HAF_SWITCH_NOW"));
        this.rootPane = rootPane;
        this.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,48"));
        FixedWidthLabel label = new FixedWidthLabel("<html>" + Language.get("HAF_MESSAGE"));
        this.setContent((FixedWidthComponent)label);
        this.maxTimeoutEndTime = maxTimeoutEndTime;
        this.autoSwitchTimeMS = autoSwitchTimeMS;
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JButton) {
                    FailoverDialog.this.buttonPressed((JButton)e.getSource());
                }
            }
        };
        if (this.canWait(60000L)) {
            this.waitButton = super.addLeftButton(Language.get("HAF_WAIT_SHORT"), false, buttonListener);
        }
        if (this.canWait(300000L)) {
            this.waitLongerButton = super.addLeftButton(Language.get("HAF_WAIT_LONGER"), false, buttonListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialog() {
        this.dialog = new AbstractGlassDialog(this.rootPane, 500, (AbstractDialogPanel)this);
        this.dialog.setTitle(Language.get("HAF_TITLE"));
        if (this.autoSwitchTimeMS != -1L) {
            Object object = this.AUTO_ACCEPT_LOCK;
            synchronized (object) {
                if (this.autoAcceptThread != null) {
                    this.autoAcceptThread.die();
                }
                this.autoAcceptThread = new AutoAcceptThread(this.autoSwitchTimeMS);
            }
        }
        this.dialog.setVisible(true);
    }

    public long getSelectedDelay() {
        return this.delay;
    }

    protected void buttonPressed(JButton button) {
        this.delay = button == null ? 0L : (button == this.waitButton ? 60000L : (button == this.waitLongerButton ? 300000L : 0L));
        this.dialog.okPressed();
    }

    private boolean canWait(long duration) {
        if (this.maxTimeoutEndTime == -1L) {
            return true;
        }
        long targetTime = System.currentTimeMillis() + duration;
        return targetTime < this.maxTimeoutEndTime;
    }

    public static void main(String[] args) throws IOException {
        JWLaunchProperties.setUpTestProperties();
        JWLaunchProperties.overrideDynamicProperty((String)"update_url", (String)"http://simplehelp2.com/");
        final SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        Language.loadTranslations();
        FailoverMonitor.doCheckNow((URL)new URL("http://localhost/shtarget.txt"), (FailoverListener)new FailoverListener(){

            public long mustFailoverTo(String newURL, long maxTimeoutEndTime, long autoSwitchTimeMS) {
                FailoverDialog dialog = new FailoverDialog((RootPaneContainer)frame, maxTimeoutEndTime, autoSwitchTimeMS);
                dialog.showDialog();
                return dialog.getSelectedDelay();
            }

            public void prepareForRelaunch(String newURL) {
            }
        });
    }

    class AutoAcceptThread
    extends Thread {
        private long autoSwitchMS;
        private boolean die = false;

        AutoAcceptThread(long autoSwitchMS) {
            this.autoSwitchMS = autoSwitchMS;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void die() {
            Object object = FailoverDialog.this.AUTO_ACCEPT_LOCK;
            synchronized (object) {
                this.die = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.out.println("[FailoverDialog] Auto switch timeout is " + this.autoSwitchMS + ". Now sleeping...");
                Thread.sleep(this.autoSwitchMS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object object = FailoverDialog.this.AUTO_ACCEPT_LOCK;
            synchronized (object) {
                if (this.die) {
                    return;
                }
                System.out.println("[FailoverDialog] Automatically switching now since timeout exceeded");
                FailoverDialog.this.buttonPressed(null);
            }
        }
    }
}

