/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResource;
import com.aem.shelp.common.toolbox.ToolBoxUIInterface;
import com.aem.shelp.mdupload.fs.FSMirror;
import com.aem.shelp.proxy.common.ToolBoxConstants;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.toolbox.ToolBoxResultWrapper;
import com.aem.shelp.tech.toolbox.ToolBoxUI;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class ToolBoxPropertiesPanel
implements ActionListener {
    private JPanel rootComponent = new JPanel();
    private ToolBoxUI toolBoxUI;
    private TechClient techClient;
    private final Object SAVE_AND_SYNC_LOCK = new Object();

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public ToolBoxPropertiesPanel() {
        this.initUI();
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
        this.toolBoxUI.setServerAddress(techClient.getHost(), techClient.getPort());
    }

    public void setToolBox(ToolBox toolBox) {
        try {
            this.toolBoxUI.load(toolBox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initUI() {
        GbPanel panel = new GbPanel();
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        SHStrippedContentPanel contentsPanel = new SHStrippedContentPanel(panel);
        GbPanelWrapper mainWrapper = new GbPanelWrapper((Container)this.rootComponent);
        mainWrapper.add((Component)panel, 0, 0, 1, 1, 1, 1, 11, 1);
        ColorPropagatingPanel mainPanel = new ColorPropagatingPanel();
        GbPanelWrapper availabilityWrapper = new GbPanelWrapper((Container)mainPanel, (Insets)new ScaledInsets(3, 3, 3, 3));
        JWrapLabel description = new JWrapLabel("<html>" + Language.get("TOOLBOX_DESCRIPTION") + "</html>");
        this.toolBoxUI = new ToolBoxUI(true, null){

            @Override
            public void performSave() {
                this.savingLabel.saving();
                ToolBoxPropertiesPanel.this.saveBoxToServer(this.getToolBox());
                this.savingLabel.saved();
            }

            @Override
            public ToolBoxResultWrapper runItem(ToolBoxItem item) {
                return null;
            }

            @Override
            public void synchroniseResources(ToolBoxUI ui, ToolBoxItem item, SyncCancelledListener syncCancelledListener) {
                SynchroniseToolboxThread stt = new SynchroniseToolboxThread(ui, item);
                stt.setCancelListener(syncCancelledListener);
                stt.start();
            }

            @Override
            public void synchroniseResourcesAndBlock(ToolBox toolbox, ToolBoxItem item, SyncCancelledListener syncCancelledListener) {
                SynchroniseToolboxThread stt = new SynchroniseToolboxThread(toolbox, item);
                stt.setCancelListener(syncCancelledListener);
                stt.run();
            }

            @Override
            public ToolBoxGroup[] getSharedToolboxGroups() throws Exception {
                return ToolBoxPropertiesPanel.this.techClient.getSharedToolBoxes();
            }
        };
        this.toolBoxUI.load(new ToolBox());
        this.toolBoxUI.getRootComponent().setBorder(SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR));
        availabilityWrapper.add((Component)description, 0, 0, 1, 1, 0, 0, 17, 2);
        availabilityWrapper.add((Component)this.toolBoxUI.getRootComponent(), 0, 1, 1, 1, 1, 1, 17, 1);
        contentsPanel.addContentGrabVertical((JComponent)mainPanel, Language.get("TOOLBOX_DETAILS"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBoxToServer(ToolBox box) {
        Object object = this.SAVE_AND_SYNC_LOCK;
        synchronized (object) {
            System.out.println("[ToolBoxProperties] Requesting save of toolbox to server");
            if (this.techClient != null) {
                for (ToolBoxItem item : box.getAllItems()) {
                    ArrayList<ToolBoxResource> clonedList;
                    ArrayList<ToolBoxResource> recentlyRemovedResources = item.getRecentlyRemovedResources();
                    ArrayList<ToolBoxResource> arrayList = recentlyRemovedResources;
                    synchronized (arrayList) {
                        clonedList = new ArrayList<ToolBoxResource>(recentlyRemovedResources);
                        recentlyRemovedResources.clear();
                    }
                    for (ToolBoxResource resource : clonedList) {
                        try {
                            System.out.println("[ToolBoxProperties] Clearing resource " + resource.getID() + " as it is no longer required.");
                            this.techClient.clearResource(item, resource);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    this.techClient.saveToolBox(box);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error(e);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public boolean checkIfValid() {
        return true;
    }

    class SynchroniseToolboxThread
    extends Thread
    implements FSMirror.ProgressListener {
        private ToolBoxUI toolBoxUI;
        private ToolBoxItem item;
        private long totalFileSizeForAllResources = 0L;
        private long totalDataSentSoFar = 0L;
        private ToolBox toolBox;
        private boolean cancelled;
        private SyncCancelledListener cancelListener;

        public SynchroniseToolboxThread(ToolBoxUI ui, ToolBoxItem item) {
            this.toolBoxUI = ui;
            this.item = item;
        }

        public SynchroniseToolboxThread(ToolBox toolBox, ToolBoxItem item) {
            this.toolBox = toolBox;
            this.item = item;
        }

        public void setCancelListener(SyncCancelledListener listener) {
            this.cancelListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ToolBoxPropertiesPanel.this.SAVE_AND_SYNC_LOCK;
            synchronized (object) {
                if (this.toolBoxUI != null) {
                    ToolBoxPropertiesPanel.this.saveBoxToServer(this.toolBoxUI.getToolBox());
                }
                System.out.println("[ToolBoxProperties] Requesting sync of toolbox item to server");
                if (ToolBoxPropertiesPanel.this.techClient != null) {
                    ToolBoxConstants.syncResources(ToolBoxPropertiesPanel.this.techClient, (ToolBoxUIInterface)this.toolBoxUI, this.item, (FSMirror.ProgressListener)this);
                }
            }
        }

        @Override
        public void transferred(long bytes) {
            this.totalDataSentSoFar += bytes;
            double percentageDone = this.totalDataSentSoFar;
            System.out.println("[UploadProgress] " + this.totalDataSentSoFar + " / " + this.totalFileSizeForAllResources + "    = " + (percentageDone /= (double)this.totalFileSizeForAllResources));
            if (this.toolBoxUI != null) {
                this.toolBoxUI.synchronisationProgress(this.item, percentageDone);
            }
        }

        @Override
        public void totalSize(long size) {
            if (this.totalFileSizeForAllResources == 0L) {
                this.totalFileSizeForAllResources = size;
            }
        }

        @Override
        public boolean cancelled() {
            return this.cancelListener != null && this.cancelListener.isCancelled();
        }
    }

    public static interface SyncCancelledListener {
        public boolean isCancelled();
    }
}

