/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.notifiers;

import com.aem.shelp.tech.notifiers.AbstractNotification;
import com.aem.utils.Debugger;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.TreeSet;
import utils.ostools.OS;
import utils.swing.images.ImageLoader;
import utils.swing.systemtray.TrayNotifier;

public class TrayNotification
extends AbstractNotification
implements ActionListener {
    private Image blueLogo;
    private TrayNotifier trayNotifier;

    public TrayNotification(ResourceBundle lang) {
        super(lang);
    }

    @Override
    public void enable() {
        try {
            this.initTray();
        }
        catch (Exception ex) {
            Debugger.warning("Unable to use Tray Notification ", ex);
        }
    }

    @Override
    public void disable() {
        if (this.trayNotifier != null) {
            this.trayNotifier.removeTrayIcon();
            this.trayNotifier = null;
        }
    }

    @Override
    public void sendNotification(int customerCount, TreeSet joined, TreeSet left) {
        if (this.trayNotifier == null) {
            return;
        }
        this.setTooltip(customerCount);
        StringBuffer message = new StringBuffer();
        if (this.join && joined.size() > 0) {
            if (joined.size() == 1) {
                message.append("1 " + this.lang.getString("TRAY_MESSAGE_SINGLE"));
            } else {
                message.append(joined.size() + " " + this.lang.getString("TRAY_MESSAGE_MULTIPLE"));
            }
        }
        if (this.leave && left.size() > 0) {
            if (this.join) {
                message.append("\n");
            }
            if (left.size() == 1) {
                message.append("1 " + this.lang.getString("TRAY_MESSAGE_LEFT_SINGLE"));
            } else {
                message.append(left.size() + " " + this.lang.getString("TRAY_MESSAGE_LEFT_MULTIPLE"));
            }
        }
        this.trayNotifier.setImage(this.blueLogo);
        if (!this.join && left.size() == 0) {
            return;
        }
        if (!this.leave && joined.size() == 0) {
            return;
        }
        this.trayNotifier.displayMessage(this.lang.getString("TRAY_TITLE"), message.toString());
    }

    private void setTooltip(int customerCount) {
        if (customerCount == 0) {
            this.trayNotifier.setToolTip(this.lang.getString("TRAY_TOOLTIP_EMPTY"));
        } else if (customerCount == 1) {
            this.trayNotifier.setToolTip(this.lang.getString("TRAY_TOOLTIP_ONE"));
        } else {
            this.trayNotifier.setToolTip(customerCount + " " + this.lang.getString("TRAY_TOOLTIP_MANY"));
        }
    }

    public static void main(String[] args) {
        ImageLoader.getAsImage((String)"images/svg/logos/simplehelp-black.svg,16");
    }

    private void initTray() throws TrayNotifier.TrayIconNotSupportedException {
        if (this.trayNotifier == null) {
            Dimension size = TrayNotifier.getTrayIconSize();
            this.blueLogo = OS.isMacOS() ? ImageLoader.getAsImage((String)("images/svg/logos/simplehelp-black.svg," + (size.height - 2))) : ImageLoader.getAsImage((String)("images/svg/logos/simplehelp-blue.svg," + size.height));
            this.trayNotifier = new TrayNotifier(this.blueLogo);
            this.trayNotifier.setImageAutoSize(true);
            PopupMenu menu = new PopupMenu();
            MenuItem exit = new MenuItem();
            exit.setLabel(this.lang.getString("EXIT"));
            menu.addActionListener(this);
            exit.addActionListener(this);
            menu.add(exit);
            this.trayNotifier.setPopupMenu(menu);
            this.setTooltip(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.trayNotifier.removeTrayIcon();
        this.trayNotifier = null;
    }

    public void setSettings(boolean enable, boolean join, boolean leave) {
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
        this.join = join;
        this.leave = leave;
    }
}

