/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.summarypanels;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Customer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;

public class CustomerSummaryPanel
implements ColorPropagatingPanel.Colourable {
    private ColorPropagatingGBPanel additionalInfoPanel;
    private JLabel fullOSLabel = new DetailLabel(true);
    private JLabel fullOSValue = new DetailLabel(false);
    private JLabel usernameLabel = new DetailLabel(true);
    private JLabel usernameValue = new DetailLabel(false);
    private JLabel countryLabel = new DetailLabel(true);
    private JLabel countryValue = new DetailLabel(false);
    private JLabel requestDomainLabel = new DetailLabel(true);
    private JLabel requestDomainValue = new DetailLabel(false);
    private ArrayList<JLabel> cachedLabels = new ArrayList();
    private ArrayList<JLabel> cachedValues = new ArrayList();
    private JPanel fetchedInfoLabels;
    private JPanel fetchedInfoValues;
    private JPanel detailsLabels;
    private JPanel detailsValues;

    public JComponent getRootComponent() {
        return this.additionalInfoPanel;
    }

    public CustomerSummaryPanel() {
        this.initUI();
    }

    private JLabel getJLabel(boolean isLabel, int number) {
        ArrayList<JLabel> list = isLabel ? this.cachedLabels : this.cachedValues;
        if (list.size() > number) {
            return list.get(number);
        }
        DetailLabel label = new DetailLabel(isLabel);
        list.add(label);
        return label;
    }

    public void setBackground(Color c) {
        this.additionalInfoPanel.setBackground(c);
        this.fetchedInfoLabels.setBackground(c);
        this.fetchedInfoValues.setBackground(c);
        this.detailsLabels.setBackground(c);
        this.detailsValues.setBackground(c);
    }

    private void initUI() {
        this.additionalInfoPanel = new ColorPropagatingGBPanel(new ScaledInsets(2, 2, 2, 2));
        this.additionalInfoPanel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)10, (int)0));
        this.fetchedInfoLabels = new JPanel(new GridLayout(4, 1));
        this.fetchedInfoLabels.add(this.fullOSLabel);
        this.fetchedInfoLabels.add(this.usernameLabel);
        this.fetchedInfoLabels.add(this.countryLabel);
        this.fetchedInfoLabels.add(this.requestDomainLabel);
        this.fetchedInfoValues = new JPanel();
        this.fetchedInfoValues.setLayout(new GridLayout(4, 1));
        this.fetchedInfoValues.add(this.fullOSValue);
        this.fetchedInfoValues.add(this.usernameValue);
        this.fetchedInfoValues.add(this.countryValue);
        this.fetchedInfoValues.add(this.requestDomainValue);
        this.detailsLabels = new JPanel();
        this.detailsValues = new JPanel();
        int Y = 0;
        int X = 0;
        this.additionalInfoPanel.add(this.detailsLabels, X++, 0, 1, Y, 0, 1, 12, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.additionalInfoPanel.add(this.detailsValues, X++, 0, 1, Y, 1, 1, 18, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.additionalInfoPanel.add(this.fetchedInfoLabels, X++, 0, 1, Y, 1, 1, 12, 2, (Insets)new ScaledInsets(0, 20, 0, 0));
        this.additionalInfoPanel.add(this.fetchedInfoValues, X++, 0, 1, Y, 1, 1, 18, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.fullOSLabel.setText(Language.get("OPERATING_SYSTEM") + ": ");
        this.usernameLabel.setText(Language.get("USERNAME") + ": ");
        this.countryLabel.setText(Language.get("COUNTRY") + ": ");
        this.requestDomainLabel.setText(Language.get("CONNECT_DOMAIN") + ": ");
    }

    public void initWith(Customer customer) {
        this.fullOSValue.setText(customer.getOsSummary());
        this.usernameValue.setText(customer.getRemoteUsername());
        this.countryValue.setText(customer.getCountry());
        this.requestDomainValue.setText(customer.getRequestDomain());
        String[] keys = customer.getDetailsKeys();
        this.detailsLabels.removeAll();
        this.detailsValues.removeAll();
        this.detailsLabels.setLayout(new GridLayout(keys.length, 1));
        this.detailsValues.setLayout(new GridLayout(keys.length, 1));
        for (int i = 0; i < keys.length; ++i) {
            JLabel label = this.getJLabel(true, i);
            JLabel value = this.getJLabel(false, i);
            label.setText(keys[i] + ": ");
            value.setText(customer.getValue(keys[i], true));
            this.detailsLabels.add(label);
            this.detailsValues.add(value);
        }
        this.additionalInfoPanel.revalidate();
    }

    public void removeFromParent() {
        Container p = this.additionalInfoPanel.getParent();
        if (p != null) {
            p.remove((Component)((Object)this.additionalInfoPanel));
        }
    }

    class DetailLabel
    extends JLabel {
        public DetailLabel(boolean isLabel) {
            if (isLabel) {
                this.setForeground(Color.GRAY);
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        }
    }
}

