/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.DemoSession;
import com.aem.shelp.proxy.types.GenericSessionType;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.history.HistoryPanel;
import com.aem.shelp.tech.history.LoadingCellRenderer;
import com.aem.shelp.tech.utils.MachineGroupLabel;
import com.aem.shelp.util.EasyDateTimeFormatter;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.simplelist.SimpleList;

public class HistoryPanelCellRenderer
extends DefaultTableCellRenderer {
    private SimpleList list;
    private EasyDateTimeFormatter dateFormatter = new EasyDateTimeFormatter();
    private ElapsedTimeFormatter elapsedTimeFormatter = new ElapsedTimeFormatter();
    private SHProgressAnimatedIcon arrowIcon = new SHProgressAnimatedIcon();
    private HistoryPanel historyPanel;
    private MachineGroupLabel groupLabel = new MachineGroupLabel();

    public HistoryPanelCellRenderer(SimpleList list, HistoryPanel historyPanel) {
        this.list = list;
        this.historyPanel = historyPanel;
        this.groupLabel.setHeight(HistoryPanel.HISTORY_PANEL_ROW_HEIGHT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof LoadingCellRenderer.Loading) {
            if (column == 0) {
                component.setIcon(this.arrowIcon);
                component.setText(Language.get("LOADING") + "...");
                component.setFont(SHStyle.smallerFont);
                component.setHorizontalAlignment(2);
                component.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            } else {
                component.setIcon(null);
                component.setText("");
            }
            if (!((LoadingCellRenderer.Loading)value).haveRequestedMoreData) {
                this.historyPanel.moreData();
            }
            ((LoadingCellRenderer.Loading)value).haveRequestedMoreData = true;
            return component;
        }
        component.setIcon(null);
        if (column == 0 || column == 5) {
            component.setFont(SHStyle.smallerFont);
        } else {
            component.setFont(UIManager.getFont("Label.font"));
        }
        if (!isSelected) {
            if (column == 0 || column == 5) {
                component.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            } else {
                component.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
        switch (column) {
            case 0: {
                component.setHorizontalAlignment(2);
                long time = (Long)value;
                component.setText(this.dateFormatter.formatDate(time));
                break;
            }
            case 1: {
                GenericSessionType session = (GenericSessionType)this.list.get(row);
                Icon icon = null;
                if (session.hasSessionRecording()) {
                    icon = ImageLoader.getImageIcon((String)"images/svg/av/record.svg,12");
                }
                component.setText("");
                component.setIcon(icon);
                break;
            }
            case 2: {
                component.setHorizontalAlignment(2);
                GenericSessionType session = (GenericSessionType)this.list.get(row);
                Icon icon = null;
                if (session instanceof SupportSession) {
                    icon = ImageLoader.getImageIcon((String)"images/svg/general/help.svg,16");
                } else if (session instanceof AccessSession) {
                    icon = ((AccessSession)session).isAppTunnelSession() ? ImageLoader.getImageIcon((String)"images/svg/computing/app-connection.svg,16") : ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16");
                } else if (session instanceof DemoSession) {
                    icon = ImageLoader.getImageIcon((String)"images/svg/general/bullhorn.svg,16");
                }
                component.setIcon(icon);
                break;
            }
            case 3: {
                if (value != null) {
                    this.groupLabel.setGroups(((String)value).split("/"));
                    this.groupLabel.setBackground(component.getBackground());
                    this.groupLabel.setForeground(component.getForeground());
                    return this.groupLabel;
                }
            }
            case 4: {
                component.setHorizontalAlignment(2);
                break;
            }
            case 5: {
                component.setHorizontalAlignment(4);
                long time = (Long)value;
                component.setText(this.elapsedTimeFormatter.getFormattedTime(time));
            }
        }
        return component;
    }

    public void setupWidths(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        block8: for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            switch (i) {
                case 0: {
                    col.setMaxWidth(SimpleHelpLookAndFeel.scale((int)100));
                    col.setMinWidth(SimpleHelpLookAndFeel.scale((int)100));
                    continue block8;
                }
                case 1: {
                    col.setMaxWidth(SimpleHelpLookAndFeel.scale((int)20));
                    col.setMinWidth(SimpleHelpLookAndFeel.scale((int)20));
                    continue block8;
                }
                case 2: {
                    col.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)100));
                    continue block8;
                }
                case 3: {
                    col.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)100));
                    continue block8;
                }
                case 4: {
                    col.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)75));
                    col.setMinWidth(SimpleHelpLookAndFeel.scale((int)75));
                    continue block8;
                }
                case 5: {
                    col.setMaxWidth(SimpleHelpLookAndFeel.scale((int)75));
                    col.setMinWidth(SimpleHelpLookAndFeel.scale((int)75));
                }
            }
        }
    }

    public static class HeaderAlignmentWrapper
    implements TableCellRenderer {
        private DefaultTableCellRenderer renderer;

        public HeaderAlignmentWrapper(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            switch (col) {
                case 0: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 3: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 4: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 5: {
                    label.setHorizontalAlignment(4);
                }
            }
            return label;
        }
    }
}

