/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientSource;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.GenericSessionType;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.history.HistoryListener;
import com.aem.shelp.tech.history.HistoryPanelCellRenderer;
import com.aem.shelp.tech.history.HistorySearchPanel;
import com.aem.shelp.tech.history.LoadingCellRenderer;
import com.aem.shelp.tech.history.SessionPanel;
import com.aem.shelp.tech.history.SessionUploader;
import com.aem.shelp.tech.history.TimelineModel;
import com.aem.shelp.tech.history.TimelineSlider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHSplitPane;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHTableHeaderUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.switches.Switches;

public class HistoryPanel
implements ActionListener,
TimelineModel.TimelineSelectionListener,
MessageFieldHandler.FilterListener,
ListSelectionListener,
HistoryListener,
HistorySearchPanel.HistoryFilterChangeListener,
TechClientSource {
    public static final int HISTORY_PANEL_ROW_HEIGHT = SimpleHelpLookAndFeel.scale((int)26);
    private final int MAX_RESULTS = 100;
    private static final String FILTER_ID = "FILTER_PANEL";
    private static final String TIME_ID = "TIME_PANEL";
    public JPanel rootComponent = new JPanel(new BorderLayout());
    private SimpleList<Object> simpleList;
    private NoContentsInfoPanel infoPanel;
    private SessionPanel sessionPanel;
    private HistoryPanelCellRenderer cellRenderer;
    private JTable table;
    private JPanel cardsPanel;
    private CardLayout cardLayout;
    private GbPanel filterPanel;
    private JSearchTextField messageTextField;
    private JToggleButton filterButton;
    private JToggleButton timeButton;
    private GbPanel timePanel;
    private TechClient tc;
    private TimelineSlider slider;
    private String previousFilter;
    private String technicianUsernameFilter;
    private int[] technicianGroupFilters;
    private boolean clearOnNextResults;
    private boolean showNoResults = false;
    private JScrollPane sp;
    private JSplitPane splitPane;
    private HistorySearchPanel historySearchPanel;
    private NewSearchThread metricsThread = null;
    private NewSearchThread newSearchThread = null;
    private MoreDataThread moreDataThread = null;
    SearchConfig previousQuery;
    boolean resultsFeedForReport = false;
    ArrayList<AbstractSession> nextBatchForReport;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public HistoryPanel(MachineTreeModel machineTreeModel) {
        this.initUI(machineTreeModel);
    }

    @Override
    public TechClient getTechClient() {
        return this.tc;
    }

    public void setTechClient(SessionUploader sessionUploader, TechClient techClient) {
        this.tc = techClient;
        this.tc.addHistoryListener(this);
        this.sessionPanel.setTechClient(techClient, sessionUploader);
        if (this.tc.getTechUser().isServerAdmin()) {
            this.technicianUsernameFilter = null;
            this.technicianGroupFilters = null;
        } else {
            this.technicianUsernameFilter = this.tc.getTechUser().username;
            this.technicianGroupFilters = this.tc.getTechUser().loggedInGroupIDs;
        }
        this.setSliderToShowAllData();
    }

    public void testCycleUi() {
        JScrollBar vert = this.sp.getVerticalScrollBar();
        for (int i = 0; i < 10; ++i) {
            vert.setValue(vert.getMaximum());
            this.sp.invalidate();
            this.sp.revalidate();
            this.sp.repaint();
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setSliderToShowAllData() {
        long oldestTime = this.tc.getOldestHistoricalSession();
        if (oldestTime == -1L) {
            oldestTime = System.currentTimeMillis();
        }
        if (this.slider != null) {
            TimelineModel model = new TimelineModel(oldestTime, System.currentTimeMillis(), 0);
            model.addTimelineListener(this);
            this.slider.setModel(model);
            this.timelineChanged(model.getSelectionStartTime(), model.getSelectionEndTime());
        } else {
            this.historySearchPanel.setModelTimeRange(oldestTime, System.currentTimeMillis());
            this.historySearchPanel.setSliderToShowAllData();
            this.historySearchPanel.timelineChanged(oldestTime, System.currentTimeMillis());
        }
    }

    public void setNewFilter(String filter) {
        long oldestTime;
        if (filter != null && filter.trim().length() == 0) {
            filter = null;
        }
        if ((oldestTime = this.tc.getOldestHistoricalSession()) > 0L) {
            if (this.previousFilter == null && filter == null) {
                return;
            }
            if (this.previousFilter != null && filter != null && this.previousFilter.trim().equals(filter.trim())) {
                return;
            }
            this.previousFilter = filter;
            this.timelineChanged(oldestTime, this.slider.getModel().getSelectionEndTime());
        }
    }

    private void initUI(MachineTreeModel machineTreeModel) {
        TableStructure ts = TableStructure.createTableStructure(GenericSessionType.class, new String[]{"getStartTime", "", "getDescription", "getAdditionalDescription", "getTechnicianDisplayName", "getDuration"}, new String[]{"", "", Language.get("CUI_TYPE_LABEL"), "", Language.get("TECHNICIAN"), Language.get("DURATION")});
        this.simpleList = new SimpleList();
        this.cellRenderer = new HistoryPanelCellRenderer(this.simpleList, this);
        SimpleTableModel slm = new SimpleTableModel(this.simpleList, ts){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = this.list.get(rowIndex);
                if (value instanceof LoadingCellRenderer.Loading) {
                    return value;
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        };
        this.table = new JTable();
        this.table.setRowHeight(HISTORY_PANEL_ROW_HEIGHT);
        this.table.setModel(slm);
        this.table.setDefaultRenderer(Object.class, this.cellRenderer);
        this.table.setDefaultRenderer(Long.class, this.cellRenderer);
        this.table.setDefaultRenderer(Long.TYPE, this.cellRenderer);
        this.table.getTableHeader().setDefaultRenderer(new HistoryPanelCellRenderer.HeaderAlignmentWrapper(this.table));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.cellRenderer.setupWidths(this.table);
        this.sp = new JScrollPane(this.table){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (HistoryPanel.this.showNoResults) {
                    Graphics2D g2d = (Graphics2D)g;
                    String text = Language.get("NO_RESULTS_SEARCH");
                    TextLayout tl = new TextLayout(text, g2d.getFont(), g2d.getFontRenderContext());
                    int x = (this.getWidth() - (int)tl.getBounds().getWidth() - 1) / 2;
                    int y = (int)tl.getAscent() + 5 + SHTableHeaderUI.HEADER_HEIGHT;
                    g2d.setColor(SHStyle.EXAMPLE_TEXT_COLOR);
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.drawString(text, x, y);
                }
            }
        };
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.sp, "Center");
        this.sp.setBorder(SHBorderFactory.createEmptyBorder());
        JPanel searchPanel = this.initSearchPanel(machineTreeModel);
        tablePanel.add((Component)searchPanel, "North");
        this.sessionPanel = new SessionPanel(this);
        this.infoPanel = new NoContentsInfoPanel(Language.get("HISTORY_NO_SESSION"), null, false);
        this.infoPanel.setContentsPanel(this.sessionPanel.getRootComponent());
        this.infoPanel.setFont(SHStyle.largeFont, SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.splitPane = new SHSplitPane(0);
        this.splitPane.setDividerLocation(0.6);
        this.splitPane.setLeftComponent(tablePanel);
        this.splitPane.setRightComponent(this.infoPanel);
        this.splitPane.setBorder(null);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setContinuousLayout(true);
        this.rootComponent.add((Component)this.splitPane, "Center");
    }

    private void showNoResults(boolean showNoResults) {
        if (showNoResults != this.showNoResults) {
            this.showNoResults = showNoResults;
            this.table.repaint();
        }
    }

    private JPanel initSearchPanel(MachineTreeModel machineTreeModel) {
        if (Switches.SH_historyPanelFilters) {
            this.historySearchPanel = new HistorySearchPanel(this, this);
            this.historySearchPanel.setMachineTreeModel(machineTreeModel);
            return this.historySearchPanel.getRootComponent();
        }
        ColorPropagatingGBPanel panel = new ColorPropagatingGBPanel();
        panel.setBorder(SHStyle.BUTTON_BAR_BORDER);
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        this.timeButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/calendar.svg,28"));
        this.filterButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,28"));
        SHButtonUI.makeButtonSegmentedLeft((AbstractButton)this.timeButton);
        SHButtonUI.makeButtonSegmentedCenter((AbstractButton)this.filterButton);
        this.timeButton.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.timeButton.setSelected(true);
        buttonsPanel.add(this.timeButton);
        buttonsPanel.add(this.filterButton);
        panel.add(buttonsPanel, 0, 0, 1, 1, 0, 1, 17, 0);
        this.cardLayout = new CardLayout();
        this.cardsPanel = new ColorPropagatingPanel((LayoutManager)this.cardLayout);
        this.filterPanel = new ColorPropagatingGBPanel();
        this.filterPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)3));
        this.messageTextField = new JSearchTextField(Language.get("FILTER") + "...");
        this.messageTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.messageTextField.setFilterListener(this);
        this.filterPanel.add((Component)this.messageTextField, 0, 0, 1, 1, 1, 1, 10, 2);
        this.timePanel = new ColorPropagatingGBPanel();
        this.timePanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)3, (int)0, (int)3));
        TimelineModel model = new TimelineModel(System.currentTimeMillis() - 77760000000L, System.currentTimeMillis(), 0);
        this.slider = new TimelineSlider(model);
        model.addTimelineListener(this);
        this.timePanel.add((Component)this.slider.getRootComponent(), 0, 0, 1, 1, 1, 1, 11, 1);
        this.cardsPanel.add((Component)this.filterPanel, FILTER_ID);
        this.cardsPanel.add((Component)this.timePanel, TIME_ID);
        this.showTime();
        panel.add(this.cardsPanel, 1, 0, 1, 1, 1, 1, 17, 1);
        panel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        return panel;
    }

    private void showFilter() {
        this.cardLayout.show(this.cardsPanel, FILTER_ID);
        this.timeButton.setSelected(false);
        this.filterButton.setSelected(true);
    }

    private void showTime() {
        this.cardLayout.show(this.cardsPanel, TIME_ID);
        this.timeButton.setSelected(true);
        this.filterButton.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TimelineModel model = this.slider.getModel();
        if (e.getSource() == this.filterButton) {
            if (this.filterButton.isSelected()) {
                this.setNewFilter(this.messageTextField.getText());
                this.showFilter();
            } else {
                this.timelineChanged(model.getSelectionStartTime(), model.getSelectionEndTime());
                this.showTime();
            }
        } else if (e.getSource() == this.timeButton) {
            if (this.timeButton.isSelected()) {
                this.timelineChanged(model.getSelectionStartTime(), model.getSelectionEndTime());
                this.showTime();
            } else {
                this.setNewFilter(this.messageTextField.getText());
                this.showFilter();
            }
        }
    }

    private static boolean objectsEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        return o1 != null && o2 != null && o1.equals(o2);
    }

    public void newSearch(SearchConfig query) {
        if (this.previousQuery != null && query.equals(this.previousQuery)) {
            return;
        }
        this.previousQuery = query;
        if (this.newSearchThread != null) {
            this.newSearchThread.die();
        }
        if (this.metricsThread != null) {
            this.metricsThread.die();
        }
        System.out.println("[HistoryPanel] A new search has been requested: " + query);
        this.newSearchThread = new NewSearchThread(query);
        this.newSearchThread.start();
        if (Switches.SH_historyPanelFilters) {
            query = query.clone();
            query.setReturnMetricsOnly(true);
            this.metricsThread = new NewSearchThread(query);
            this.metricsThread.start();
        }
    }

    public void moreData() {
        if (this.moreDataThread != null) {
            this.moreDataThread.die();
        }
        this.moreDataThread = new MoreDataThread();
        this.moreDataThread.start();
    }

    @Override
    public byte getHistoryID() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSessions(AbstractSession[] sessions) throws Exception {
        this.tc.deleteSessionHistories(sessions);
        this.simpleList.startBatch();
        try {
            for (AbstractSession session : sessions) {
                this.simpleList.remove(session);
            }
        }
        finally {
            this.simpleList.endBatch();
        }
        this.table.getSelectionModel().clearSelection();
    }

    @Override
    public void historyFilterChanged() {
        this.newSearch(this.getCurrentConfig(0L, 0L));
    }

    public void showSessionInHistory(AbstractSession abstractSession) {
        this.historySearchPanel.filterForSpecificSession(abstractSession);
    }

    private SearchConfig getCurrentConfig(long startTime, long endTime) {
        SearchConfig config;
        if (Switches.SH_historyPanelFilters) {
            config = this.historySearchPanel.getSearchConfig();
        } else {
            config = new SearchConfig();
            config.setStartTime(startTime);
            config.setEndTime(endTime);
            if (this.filterButton.isSelected()) {
                config.setTextFilter(this.messageTextField.getText());
            }
            if (!this.tc.getPermissions().canViewAllHistory()) {
                if (this.tc.getPermissions().canViewGroupHistory()) {
                    config.setTechnicianGroups(this.technicianGroupFilters);
                } else if (this.tc.getPermissions().canViewOwnHistory()) {
                    config.setTechnicianNameFilters(new String[]{this.technicianUsernameFilter});
                }
            }
        }
        return config;
    }

    @Override
    public void timelineChanged(long startTime, long endTime) {
        this.newSearch(this.getCurrentConfig(startTime, endTime));
    }

    public void setFilter(String filter, boolean immediate) {
        this.setNewFilter(filter);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (int selectedRow : selectedRows) {
            Object o = this.simpleList.get(selectedRow);
            if (!(o instanceof AbstractSession)) continue;
            sessions.add((AbstractSession)o);
        }
        if (sessions.size() > 0) {
            this.infoPanel.setHasContents(true);
            if (sessions.size() == 1) {
                this.sessionPanel.setSelectedSession((AbstractSession)sessions.get(0));
            } else {
                this.sessionPanel.setSelectedSessions(sessions.toArray(new AbstractSession[0]));
            }
        } else {
            this.infoPanel.setHasContents(false);
            this.sessionPanel.setSelectedSession(null);
        }
    }

    public void refreshCurrentSearch() {
        SearchConfig newQuery = this.previousQuery.clone();
        this.previousQuery.setEndTime(-1L);
        this.newSearch(newQuery);
    }

    @Override
    public void searchResults(ArrayList<AbstractSession> results, boolean isFinished) {
        this.simpleList.startBatch();
        try {
            if (this.clearOnNextResults) {
                this.simpleList.clear();
            }
            if (this.simpleList.size() > 0 && this.simpleList.get(this.simpleList.size() - 1) instanceof LoadingCellRenderer.Loading) {
                this.simpleList.remove(this.simpleList.size() - 1);
            }
            this.simpleList.addAll((Collection<Object>)results);
            if (!isFinished) {
                this.simpleList.add(new LoadingCellRenderer.Loading());
            }
            this.showNoResults(this.simpleList.size() == 0);
        }
        finally {
            this.simpleList.endBatch();
        }
    }

    @Override
    public void metricResults(HistoryMetrics metrics) {
        this.historySearchPanel.setMetrics(metrics);
    }

    public void addDebugSession(SupportSession createTestSession) {
        this.simpleList.add(createTestSession);
    }

    public ArrayList<AbstractSession> getLoadedSessionData() {
        Object[] current = this.simpleList.toArray();
        ArrayList<AbstractSession> list = new ArrayList<AbstractSession>();
        for (Object o : current) {
            if (!(o instanceof AbstractSession)) continue;
            list.add((AbstractSession)o);
        }
        return list;
    }

    public ArrayList<AbstractSession> getNextSessionDataBlock() {
        this.nextBatchForReport = null;
        this.resultsFeedForReport = true;
        this.moreData();
        long timeout = SafeClock.currentTimeMillis() + 60000L;
        while (this.nextBatchForReport == null) {
            if (SafeClock.currentTimeMillis() > timeout) {
                new IOException("Timed out while fetching results for history report").printStackTrace();
                return null;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        ArrayList<AbstractSession> list = this.nextBatchForReport;
        this.nextBatchForReport = null;
        this.resultsFeedForReport = false;
        if (list != null && list.size() == 0) {
            return null;
        }
        return list;
    }

    class MoreDataThread
    extends Thread {
        private boolean die;

        public MoreDataThread() {
            super("MoreDataThread");
            this.die = false;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            if (!HistoryPanel.this.resultsFeedForReport) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.die) {
                return;
            }
            HistoryPanel.this.clearOnNextResults = false;
            try {
                HistoryPanel.this.tc.requestMoreHistoryData(HistoryPanel.this.resultsFeedForReport ? 1000 : 100);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
        }
    }

    class NewSearchThread
    extends Thread {
        private SearchConfig query;
        private boolean die;

        public NewSearchThread(SearchConfig query) {
            super("NewSearchThread");
            this.die = false;
            query.roundStartAndEndTimesToStartAndEndOfMonth();
            query.setDescendingOrder();
            this.query = query;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            block9: {
                try {
                    this.query.setID(HistoryPanel.this.getHistoryID());
                    if (!this.query.isReturnMetricsOnly()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (this.die) {
                            return;
                        }
                        HistoryPanel.this.clearOnNextResults = true;
                        this.query.setMaxReturnedResults(100);
                        HistoryPanel.this.tc.requestNewHistorySearch(this.query);
                        break block9;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.die) {
                        return;
                    }
                    HistoryPanel.this.tc.requestNewHistorySearch(this.query);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return;
                }
            }
        }
    }
}

