/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.model;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.hierarchy.model.MachineUpdateResult;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeElementComparator;
import com.aem.shelp.tech.hierarchy.model.stats.DescendentTreeStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import utils.swing.simplelist.SimpleList;

public abstract class TreeGroup<T extends TreeGroup<T, E>, E extends TreeElement>
implements Comparable<T> {
    public SimpleList<E> elements = new SimpleList();
    protected HashMap<String, E> idToElementMap = new HashMap();
    private static long TREEGROUP_INDEX = 0L;
    private static final Object INDEX_LOCK = new Object();
    protected long uniqueIndex;
    public String groupName;
    protected transient ArrayList<String> metadata = new ArrayList();
    protected transient DescendentTreeStats<E> stats = this.initGroupStats();
    protected T parent;

    protected abstract DescendentTreeStats<E> initGroupStats();

    protected abstract E[] initElementArray(int var1);

    public void setParent(T parent) {
        this.parent = parent;
    }

    public T getParent() {
        return this.parent;
    }

    public boolean isDescendentOf(T ancestor) {
        if (((TreeGroup)ancestor).equals(this)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return ((TreeGroup)this.parent).isDescendentOf(ancestor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeGroup() {
        Object object = INDEX_LOCK;
        synchronized (object) {
            this.uniqueIndex = TREEGROUP_INDEX++;
        }
    }

    public void setGroupIndex(long index) {
        this.uniqueIndex = index;
    }

    public long getGroupIndex() {
        return this.uniqueIndex;
    }

    public Comparator<TreeElement> getTreeElementComparator() {
        return TreeElementComparator.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] removeElements(E[] machinesArray) {
        Arrays.sort(machinesArray, this.getTreeElementComparator());
        ArrayList<E> removedItems = new ArrayList<E>();
        this.elements.startBatch();
        try {
            for (int i = machinesArray.length - 1; i >= 0; --i) {
                if (!this.elements.remove(machinesArray[i])) continue;
                this.idToElementMap.remove(machinesArray[i].getID());
                removedItems.add(machinesArray[i]);
                this.stats.remove(machinesArray[i]);
            }
            for (T parent = this.getParent(); parent != null; parent = ((TreeGroup)parent).getParent()) {
                ((TreeGroup)parent).stats.descendentsRemoved(removedItems);
            }
        }
        finally {
            this.elements.endBatch();
        }
        return removedItems.toArray(this.initElementArray(0));
    }

    private String getFullPath(TreeGroup group) {
        if (group == null) {
            return "";
        }
        return this.getFullPath((TreeGroup)group.getParent()) + "\\" + group.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MachineUpdateResult<E> appendMachines(E[] machinesArray) {
        T parent;
        if (machinesArray.length > 1) {
            Arrays.sort(machinesArray, this.getTreeElementComparator());
        }
        MachineUpdateResult result = new MachineUpdateResult();
        this.elements.startBatch();
        try {
            block19: {
                int machinesArrayIndex = 0;
                Object machineToInsert = machinesArray[machinesArrayIndex++];
                while (machineToInsert != null && this.copyStateIfExists(machineToInsert, result)) {
                    if (machinesArrayIndex < machinesArray.length) {
                        machineToInsert = machinesArray[machinesArrayIndex++];
                        continue;
                    }
                    machineToInsert = null;
                }
                if (machineToInsert == null) break block19;
                block4: for (int i = 0; i < this.elements.size(); ++i) {
                    TreeElement oldMachine = (TreeElement)this.elements.get(i);
                    int compare = this.getTreeElementComparator().compare((TreeElement)machineToInsert, oldMachine);
                    if (compare > 0) continue;
                    while (true) {
                        block22: {
                            block21: {
                                block20: {
                                    if (compare >= 0 || machineToInsert == null) break block20;
                                    this.elements.add(i++, (E)machineToInsert);
                                    this.idToElementMap.put(machineToInsert.getID(), machineToInsert);
                                    result.addedMachines.add(machineToInsert);
                                    this.stats.add(machineToInsert);
                                    if (machinesArrayIndex == machinesArray.length) break block21;
                                    machineToInsert = machinesArray[machinesArrayIndex++];
                                    break block22;
                                }
                                if (machineToInsert == null) break block4;
                                continue block4;
                            }
                            MachineUpdateResult machineUpdateResult = result;
                            this.elements.endBatch();
                            T parent2 = this.getParent();
                            while (true) {
                                if (parent2 == null) {
                                    return machineUpdateResult;
                                }
                                ((TreeGroup)parent2).stats.descendentsAdded(result.addedMachines);
                                parent2 = ((TreeGroup)parent2).getParent();
                            }
                        }
                        while (machineToInsert != null && this.copyStateIfExists(machineToInsert, result)) {
                            if (machinesArrayIndex < machinesArray.length) {
                                machineToInsert = machinesArray[machinesArrayIndex++];
                                continue;
                            }
                            machineToInsert = null;
                        }
                        if (machineToInsert == null) continue;
                        compare = this.getTreeElementComparator().compare((TreeElement)machineToInsert, oldMachine);
                    }
                }
                while (machineToInsert != null) {
                    this.elements.add((E)machineToInsert);
                    this.idToElementMap.put(machineToInsert.getID(), machineToInsert);
                    result.addedMachines.add(machineToInsert);
                    this.stats.add(machineToInsert);
                    machineToInsert = machinesArrayIndex < machinesArray.length ? machinesArray[machinesArrayIndex++] : null;
                    while (machineToInsert != null && this.copyStateIfExists(machineToInsert, result)) {
                        if (machinesArrayIndex < machinesArray.length) {
                            machineToInsert = machinesArray[machinesArrayIndex++];
                            continue;
                        }
                        machineToInsert = null;
                    }
                }
            }
            this.elements.endBatch();
            parent = this.getParent();
        }
        catch (Throwable throwable) {
            this.elements.endBatch();
            T parent3 = this.getParent();
            while (true) {
                if (parent3 == null) {
                    throw throwable;
                }
                ((TreeGroup)parent3).stats.descendentsAdded(result.addedMachines);
                parent3 = ((TreeGroup)parent3).getParent();
            }
        }
        while (true) {
            if (parent == null) {
                return result;
            }
            ((TreeGroup)parent).stats.descendentsAdded(result.addedMachines);
            parent = ((TreeGroup)parent).getParent();
        }
    }

    public String toString() {
        return this.groupName;
    }

    public boolean equals(Object o) {
        if (o instanceof TreeGroup) {
            TreeGroup group = (TreeGroup)o;
            if (group.parent != null || this.parent != null) {
                if (group.parent == null || this.parent == null) {
                    return false;
                }
                if (!((TreeGroup)group.parent).equals(this.parent)) {
                    return false;
                }
            }
            if (!group.groupName.equals(this.groupName)) {
                return false;
            }
            return group.metadata.equals(this.metadata);
        }
        return false;
    }

    private boolean copyStateIfExists(E newMachine, MachineUpdateResult<E> result) {
        TreeElement existingMachine = (TreeElement)this.idToElementMap.get(newMachine.getID());
        if (existingMachine != null) {
            Machine.MachineChanges change = existingMachine.copyStateFrom((TreeElement)newMachine);
            if (!change.nameChange) {
                result.updatedMachines.add(newMachine);
                result.updatedMachineChanges.updateWith(change);
                return true;
            }
            this.elements.remove(newMachine);
            this.idToElementMap.remove(newMachine.getID());
            result.removedMachines.add(newMachine);
            return false;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.uniqueIndex * (long)this.metadata.hashCode());
    }

    public SimpleList<E> getElements() {
        return this.elements;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public void clearMachines() {
        this.elements.clear();
        this.idToElementMap.clear();
    }

    public TreeElement getElementWithID(String id) {
        return (TreeElement)this.idToElementMap.get(id);
    }

    public void appendToMetadata(String metadata) {
        this.metadata.add(metadata);
    }

    public DescendentTreeStats<E> getGroupStats() {
        return this.stats;
    }

    protected void copyStateFrom(T group) {
        ((TreeGroup)group).uniqueIndex = this.uniqueIndex;
        ((TreeGroup)group).metadata = new ArrayList<String>(this.metadata);
        ((TreeGroup)group).elements = (SimpleList)this.elements.clone();
        ((TreeGroup)group).idToElementMap = (HashMap)this.idToElementMap.clone();
        ((TreeGroup)group).stats.copyFrom(this.stats);
    }

    public int getTreeElementDescendents() {
        return this.stats.descendentElementCount;
    }
}

