/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.gstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.License;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.gstarted.P2BusinessUpsellPane;
import com.aem.shelp.tech.gstarted.P2EnterpriseUpsellPane;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.site.transact.TrialUtil;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.MessageGlassDialog;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class TrialUtils {
    public static TrialUtil getTU() {
        return new TrialUtil(JWSystem.getAllAppVersionsSharedFolder());
    }

    public static boolean amTriallingBizOrEnt() {
        TrialUtil tu = TrialUtils.getTU();
        return tu.amTrialling(TrialUtil.FEATURE_BIZ) || tu.amTrialling(TrialUtil.FEATURE_ENT);
    }

    public static boolean amTriallingBiz() {
        TrialUtil tu = TrialUtils.getTU();
        return tu.amTrialling(TrialUtil.FEATURE_BIZ);
    }

    public static boolean amTriallingEnt() {
        TrialUtil tu = TrialUtils.getTU();
        return tu.amTrialling(TrialUtil.FEATURE_ENT);
    }

    public static void overMachineLimitPopup(RootPaneContainer rpc, Component c, TechClient client) {
        if (client.getServerLicenses().isVersion2Business()) {
            TrialUtils.overMachineLimitEntPopup(rpc, c, client);
        } else {
            TrialUtils.overMachineLimitBizPopup(rpc, c, client);
        }
    }

    public static void overMachineLimitBizPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, false, true, false);
    }

    public static void overMachineLimitEntPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, false, true, true);
    }

    public static void bizUpgradeRequestPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, false, false, false);
    }

    public static void entUpgradeRequestPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, false, false, true);
    }

    public static void appConnectionsDisallowedPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, true, false, false);
    }

    public static void alertsDisallowedPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, true, false, false);
    }

    public static void toolboxDisallowedPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, true, false, false);
    }

    public static void massNotifyDisallowedPopup(RootPaneContainer rpc, Component c, TechClient client) {
        TrialUtils.licensePopup(rpc, c, client, true, false, false);
    }

    public static void licensePopup(RootPaneContainer rpc, Component c, TechClient client, boolean showDisallowed, boolean showOverLimit, boolean showEnterpriseUpgrade) {
        block9: {
            UpsellDialog dialog = new UpsellDialog(rpc, (JPanel)(showEnterpriseUpgrade ? new P2EnterpriseUpsellPane(showDisallowed, showOverLimit){

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height += SimpleHelpLookAndFeel.scale((int)20);
                    return d;
                }
            } : new P2BusinessUpsellPane(showDisallowed, showOverLimit){

                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height += SimpleHelpLookAndFeel.scale((int)20);
                    return d;
                }
            }));
            dialog.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            dialog.showDialog();
            if (dialog.isOK()) {
                if (dialog.isTrialButton) {
                    if (OemBranding.OEM_IS_SH) {
                        try {
                            if (showEnterpriseUpgrade) {
                                TrialUtils.getTrialNow(rpc, client, TrialUtil.FEATURE_ENT);
                                break block9;
                            }
                            TrialUtils.getTrialNow(rpc, client, TrialUtil.FEATURE_BIZ);
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    } else {
                        SHWebsiteURLUtil.launchTrialPage();
                    }
                } else if (dialog.isStartedButton) {
                    SHWebsiteURLUtil.launchBuyPage();
                }
            }
        }
    }

    public static void getTrialNow(RootPaneContainer rpc, TechClient client, String feature) throws Exception {
        boolean refresh = TrialUtils.getTU().hasTrialStarted(feature);
        String[] info = TrialUtils.getUserTrialInfo(rpc, client.getLicenseFromServer());
        if (info != null) {
            TrialUtil tu = TrialUtils.getTU();
            try {
                tu.requestNewTrial(feature, info[0], info[1], info[2], true);
            }
            catch (IOException x) {
                x.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)rpc, (String)(Language.get("TRIAL_PROBLEM_CONNECT") + "<br><br>(" + x + ")"), (String)Language.get("TRIAL_PROBLEM"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                return;
            }
            System.out.println("[ManagementUtil] Notifying server of trial");
            byte[] trialMarker = tu.getRawLocalTrialMarker(feature);
            client.setServerTrialMarker(feature, trialMarker);
            if (tu.hasTrialStarted(feature)) {
                if (tu.hasTrialEnded(feature)) {
                    MessageGlassDialog dialog = MessageGlassDialog.getDialog((RootPaneContainer)rpc, (int)500, (String)Language.get("TRIAL_ENDED_DESC"), (String)Language.get("TRIAL_ENDED_TITLE"), (String)Language.get("EXIT"), null, (Icon)ImageLoader.getImageIcon((String)"images/svg/general/clock-darker.svg,48"), (boolean)false);
                    JButton upgrade = dialog.getDialogPanel().addRightButton(Language.get("UPGRADE"), false, null);
                    JButton buy = dialog.getDialogPanel().addRightButton(Language.get("BUY_NEW"), false, null);
                    if (dialog.isOKResult()) {
                        if (dialog.getCloseRequestor() == upgrade) {
                            SHWebsiteURLUtil.launchAccountPage();
                        } else if (dialog.getCloseRequestor() == buy) {
                            SHWebsiteURLUtil.launchBuyPage();
                        }
                    }
                } else if (!refresh) {
                    MessageGlassDialog dialog = MessageGlassDialog.getDialog((RootPaneContainer)rpc, (int)500, (String)Language.get("TRIAL_READY_DESC", tu.trialDaysLeft(feature) + ""), (String)Language.get("TRIAL_READY_TITLE"), (String)Language.get("GET_STARTED"), null, (Icon)ImageLoader.getImageIcon((String)"images/svg/general/clock-darker.svg,48"), (boolean)false);
                    dialog.showDialog();
                }
            } else {
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)rpc, (String)Language.get("TRIAL_PROBLEM_NOTSTARTED"), (String)Language.get("TRIAL_PROBLEM"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }

    public static String[] getUserTrialInfo(RootPaneContainer rpc, LicenseSet licenses) {
        License license = licenses.getFirstLicense();
        String email = license.getEmail().trim();
        String fullname = license.getName().trim();
        String company = license.getCompany().trim();
        if (email.equals("")) {
            TextField txemail = new TextField(Language.get("INFO_EMAIL"), null, 5);
            TextField txname = new TextField(Language.get("INFO_FULLNAME"), null, 0);
            TextField txcompany = new TextField(Language.get("INFO_COMPANY"), null, 0);
            FixedWidthCUIPanel cuiPanel = new FixedWidthCUIPanel();
            cuiPanel.setFields(new CUIField[]{new LabelField(Language.get("TRIAL_NOW_DESC")), txemail, txname, txcompany});
            OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("TRIAL_NOW"), Language.get("CANCEL"));
            dialogPanel.setContent((FixedWidthComponent)cuiPanel);
            dialogPanel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/clock-darker.svg,48"));
            AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)dialogPanel);
            dialog.setTitle(Language.get("TRIAL_NOW"));
            dialog.showDialog();
            if (dialogPanel.isOK()) {
                email = txemail.getTextFieldValue();
                fullname = txname.getTextFieldValue();
                company = txcompany.getTextFieldValue();
            } else {
                return null;
            }
        }
        return new String[]{email, fullname, company};
    }

    public static JButton getUpgradeButton(String text) {
        JButton buy = new JButton(text, ImageLoader.getImageIcon((String)"images/svg/commerce/basket-add.svg,16"));
        buy.addActionListener(new UpdateLauncher());
        return buy;
    }

    public static JButton getUpgradeButton(String text, String licensesource) {
        JButton buy = new JButton(text, ImageLoader.getImageIcon((String)"images/svg/commerce/basket-add.svg,16"));
        buy.addActionListener(new UpdateLauncher(licensesource));
        return buy;
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setSize(900, 500);
        frame.setVisible(true);
        TrialUtils.appConnectionsDisallowedPopup((RootPaneContainer)frame, null, null);
        TrialUtils.bizUpgradeRequestPopup((RootPaneContainer)frame, null, null);
        TrialUtils.entUpgradeRequestPopup((RootPaneContainer)frame, null, null);
        TrialUtils.overMachineLimitBizPopup((RootPaneContainer)frame, null, null);
        TrialUtils.overMachineLimitEntPopup((RootPaneContainer)frame, null, null);
    }

    private static class UpdateLauncher
    implements ActionListener {
        String licenseSource;

        public UpdateLauncher() {
        }

        public UpdateLauncher(String licenseSource) {
            this.licenseSource = licenseSource;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.licenseSource != null) {
                SHWebsiteURLUtil.launchAccountPage();
            } else {
                SHWebsiteURLUtil.launchAccountPage();
            }
        }
    }

    static class UpsellDialog
    extends PanelGlassDialog {
        private final JButton getStartedButton;
        private final JButton trialButton;
        public boolean isStartedButton;
        public boolean isTrialButton;

        public UpsellDialog(RootPaneContainer rootPane, JPanel panel) {
            super(rootPane, "", 720, Language.get("CLOSE"), null);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == UpsellDialog.this.getStartedButton) {
                        UpsellDialog.this.isStartedButton = true;
                    } else if (e.getSource() == UpsellDialog.this.trialButton) {
                        UpsellDialog.this.isTrialButton = true;
                    } else {
                        UpsellDialog.this.cancelPressed();
                        return;
                    }
                    UpsellDialog.this.okPressed();
                }
            };
            this.getStartedButton = this.addRightButton(Language.get("GETTING_STARTED_BUY"), false, listener);
            this.trialButton = this.addRightButton(Language.get("TRIAL_NOW"), false, listener);
            this.setContentPanel(panel);
        }
    }
}

