/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.tech.customer.CustomerListListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class AdditionalCustomerInfoPanel
implements ActionListener {
    private GbPanel additionalInfoPanel;
    private JLabel fullOSLabel = new DetailLabel(true);
    private JLabel fullOSValue = new DetailLabel(false);
    private JLabel usernameLabel = new DetailLabel(true);
    private JLabel usernameValue = new DetailLabel(false);
    private JLabel countryLabel = new DetailLabel(true);
    private JLabel countryValue = new DetailLabel(false);
    private JLabel requestDomainLabel = new DetailLabel(true);
    private JLabel requestDomainValue = new DetailLabel(false);
    private ArrayList<JLabel> cachedLabels = new ArrayList();
    private ArrayList<JLabel> cachedValues = new ArrayList();
    private JPanel fetchedInfoLabels;
    private JPanel fetchedInfoValues;
    private JPanel detailsLabels;
    private JPanel detailsValues;
    private GbPanel buttonsPanel;
    private JButton connectButton2;
    private JButton terminateButton;
    private CustomerListListener listener;
    private Customer customer = null;

    public JComponent getRootComponent() {
        return this.additionalInfoPanel;
    }

    public AdditionalCustomerInfoPanel() {
        this.initUI();
    }

    public void setCustomerListListener(CustomerListListener listener) {
        this.listener = listener;
    }

    private JLabel getJLabel(boolean isLabel, int number) {
        ArrayList<JLabel> list = isLabel ? this.cachedLabels : this.cachedValues;
        if (list.size() > number) {
            return list.get(number);
        }
        DetailLabel label = new DetailLabel(isLabel);
        list.add(label);
        return label;
    }

    public void setBackground(Color c) {
        this.additionalInfoPanel.setBackground(c);
        this.fetchedInfoLabels.setBackground(c);
        this.fetchedInfoValues.setBackground(c);
        this.detailsLabels.setBackground(c);
        this.detailsValues.setBackground(c);
        this.buttonsPanel.setBackground(c);
    }

    private void initUI() {
        this.connectButton2 = new JButton(Language.get("CONNECT"));
        this.connectButton2.setVisible(true);
        this.connectButton2.addActionListener(this);
        this.terminateButton = new JButton(Language.get("KICK_USER"));
        SHButtonUI.makeButtonRed((JButton)this.terminateButton);
        this.terminateButton.addActionListener(this);
        SwingUtil.setSizesToWidest((JComponent)this.connectButton2, (JComponent)this.terminateButton);
        this.additionalInfoPanel = new GbPanel();
        this.additionalInfoPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        this.fetchedInfoLabels = new JPanel();
        this.fetchedInfoLabels.setLayout(new GridLayout(4, 1, 0, SimpleHelpLookAndFeel.scale((int)3)));
        this.fetchedInfoLabels.add(this.fullOSLabel);
        this.fetchedInfoLabels.add(this.usernameLabel);
        this.fetchedInfoLabels.add(this.countryLabel);
        this.fetchedInfoLabels.add(this.requestDomainLabel);
        this.fetchedInfoValues = new JPanel();
        this.fetchedInfoValues.setLayout(new GridLayout(4, 1, 0, SimpleHelpLookAndFeel.scale((int)3)));
        this.fetchedInfoValues.add(this.fullOSValue);
        this.fetchedInfoValues.add(this.usernameValue);
        this.fetchedInfoValues.add(this.countryValue);
        this.fetchedInfoValues.add(this.requestDomainValue);
        this.detailsLabels = new JPanel();
        this.detailsValues = new JPanel();
        this.buttonsPanel = new ColorPropagatingGBPanel(new ScaledInsets(0, 0, 5, 0));
        this.buttonsPanel.add((Component)this.connectButton2, 0, 0, 1, 1, 1, 0, 10, 1);
        this.buttonsPanel.add((Component)this.terminateButton, 0, 1, 1, 1, 1, 0, 10, 1);
        this.buttonsPanel.add((Component)new JPanel(), 0, 2, 1, 1, 1, 1, 10, 1);
        int Y = 0;
        int X = 0;
        this.additionalInfoPanel.add((Component)this.detailsLabels, X++, 0, 1, Y, 0, 1, 12, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.additionalInfoPanel.add((Component)this.detailsValues, X++, 0, 1, Y, 1, 1, 18, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.additionalInfoPanel.add((Component)this.fetchedInfoLabels, X++, 0, 1, Y, 1, 1, 12, 2, (Insets)new ScaledInsets(0, 20, 0, 0));
        this.additionalInfoPanel.add((Component)this.fetchedInfoValues, X++, 0, 1, Y, 1, 1, 18, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.additionalInfoPanel.add((Component)this.buttonsPanel, X++, 0, 1, Y, 0, 0, 13, 3, (Insets)new ScaledInsets(0, 10, 2, 0));
        this.fullOSLabel.setText(Language.get("OPERATING_SYSTEM") + ": ");
        this.usernameLabel.setText(Language.get("USERNAME") + ": ");
        this.countryLabel.setText(Language.get("COUNTRY") + ": ");
        this.requestDomainLabel.setText(Language.get("CONNECT_DOMAIN") + ": ");
    }

    public void initWith(Customer customer, boolean isSupportSession, TechGroupPermissions permissions) {
        this.customer = customer;
        this.connectButton2.setVisible(!isSupportSession);
        if (!isSupportSession) {
            this.terminateButton.setVisible(permissions == null || permissions.canRemoveCustomersFromQueue());
        } else {
            this.terminateButton.setVisible(permissions == null || permissions.canTerminateOtherUsersSessions());
        }
        this.fullOSValue.setText(customer.getOsSummary());
        this.usernameValue.setText(customer.getRemoteUsername());
        this.countryValue.setText(customer.getCountry());
        this.requestDomainValue.setText(customer.getRequestDomain());
        String[] keys = customer.getDetailsKeys();
        this.detailsLabels.removeAll();
        this.detailsValues.removeAll();
        this.detailsLabels.setLayout(new GridLayout(keys.length, 1, 0, SimpleHelpLookAndFeel.scale((int)3)));
        this.detailsValues.setLayout(new GridLayout(keys.length, 1, 0, SimpleHelpLookAndFeel.scale((int)3)));
        for (int i = 0; i < keys.length; ++i) {
            JLabel label = this.getJLabel(true, i);
            JLabel value = this.getJLabel(false, i);
            if (keys[i] != null && keys[i].length() > 0) {
                label.setText(keys[i] + ": ");
            } else {
                label.setText("");
            }
            value.setText(customer.getValue(keys[i], true));
            this.detailsLabels.add(label);
            this.detailsValues.add(value);
        }
        this.additionalInfoPanel.revalidate();
    }

    public void removeFromParent() {
        Container p = this.additionalInfoPanel.getParent();
        if (p != null) {
            p.remove((Component)this.additionalInfoPanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton2) {
            this.listener.connectToCustomer(this.customer, 0, false);
        } else {
            this.listener.terminateCustomerOrSession(this.customer);
        }
    }

    class DetailLabel
    extends JLabel {
        public DetailLabel(boolean isLabel) {
            this.setFont(SHStyle.smallerFont);
            if (isLabel) {
                this.setForeground(OEMSwitches.DARK_THEME ? SHStyle.EXAMPLE_TEXT_COLOR_DARKER : SHStyle.EXAMPLE_TEXT_COLOR);
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        }
    }
}

