/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.AppProfiles;
import com.aem.profiles.model.ProfileType;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.appprofile.AppProfileListPanel;
import com.aem.shelp.tech.appprofile.ProfileDetailsPanel;
import com.aem.shelp.tech.appprofile.ProfileTypePanel;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import testing.classes.access.AccessPanelTester;
import utils.progtools.SaverUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.layout.SlackStylePanel;

public class AppProfileUI
implements ProfileUIListener,
SaverUtil.SaveListener {
    boolean hideOtherAppTypes = false;
    private SlackStylePanel rootComponent = new SlackStylePanel();
    private ProfileTypePanel profileTypePanel = new ProfileTypePanel(this, AppProfiles.PROFILE_TYPES, false);
    private AppProfileListPanel profileListPanel = new AppProfileListPanel(this);
    private ProfileDetailsPanel profileDetailsPanel;
    private TechClient techClient;
    private SaverUtil saverUtil = new SaverUtil("AppProfileSaver", 2000, this, false);
    private LinkedList<AppProfile> profilesToSave = new LinkedList();

    public JPanel getRootComponent() {
        return this.rootComponent.getRootComponent();
    }

    public AppProfileUI(RootPaneContainer rpc, TechClient techClient) {
        this(rpc, techClient, null, false, false);
    }

    public void setCloseDialog(GlassDialog close) {
        this.profileListPanel.setCloseDialog(close);
        this.profileDetailsPanel.setCloseDialog(close);
    }

    public void setCloseListener(ActionListener listener) {
        this.profileListPanel.setCloseListener(listener);
    }

    public AppProfileUI(RootPaneContainer rpc, TechClient techClient, ProfileType type, boolean hideOtherAppTypes, boolean showClose) {
        this.techClient = techClient;
        this.hideOtherAppTypes = hideOtherAppTypes;
        if (showClose) {
            this.profileListPanel = new AppProfileListPanel(this, showClose);
        }
        this.profileDetailsPanel = new ProfileDetailsPanel(rpc, techClient, this);
        if (showClose) {
            this.rootComponent.setWidths(SimpleHelpLookAndFeel.scale((int)70), SimpleHelpLookAndFeel.scale((int)220));
        } else {
            this.rootComponent.setWidths(SimpleHelpLookAndFeel.scale((int)70), SimpleHelpLookAndFeel.scale((int)200));
        }
        this.rootComponent.getLeftPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getMiddlePanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getRightPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getLeftPanel().add(this.profileTypePanel.getRootComponent());
        this.rootComponent.getMiddlePanel().add(this.profileListPanel.getRootComponent());
        this.rootComponent.getRightPanel().add(this.profileDetailsPanel.getRootComponent());
        MatteBorder rightLineBorder = SHBorderFactory.createMatteBorder((int)0, (int)0, (int)0, (int)1, (Color)SHStyle.BORDER_COLOR);
        this.profileListPanel.getRootComponent().setBorder(rightLineBorder);
        if (type == null) {
            type = AppProfiles.PROFILE_TYPES[0];
        }
        if (hideOtherAppTypes) {
            this.rootComponent.setLeftPanelVisible(false);
        }
        this.showAppsOfType(type);
    }

    public static void popupAppProfile(RootPaneContainer rpc, TechClient client, ProfileType type) {
        AppProfileUI ui = new AppProfileUI(rpc, client, type, true, true);
        AbstractGlassDialog dialog = SHGlassOptionPane.showBorderlessDialog((RootPaneContainer)rpc, (JComponent)ui.getRootComponent(), (String)Language.get("ADD_REMOTE_ACCESS_MACHINE"), (int)700);
        ui.setCloseDialog((GlassDialog)dialog);
    }

    public static AppProfileUI getAppProfileUI(RootPaneContainer rpc, TechClient client, ProfileType type) {
        return new AppProfileUI(rpc, client, type, true, true);
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        TechClient tc = AccessPanelTester.getTechClient();
        AppProfileUI panel = new AppProfileUI((RootPaneContainer)frame, tc, AppProfiles.PROFILE_TYPES[0], false, false);
        frame.getContentPane().add(panel.getRootComponent());
        frame.setSize(800, 500);
        frame.setVisible(true);
    }

    @Override
    public void showAppsOfType(final ProfileType type) {
        new Thread(){

            @Override
            public void run() {
                AppProfileUI.this.profileListPanel.showLoading(true);
                AppProfileUI.this.profileDetailsPanel.showAppProfileTypeExplainer(type);
                AppProfile[] result = null;
                try {
                    result = AppProfileUI.this.techClient.getAllAppProfilesByType(type);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (result == null || result.length == 0) {
                    AppProfileUI.this.profileListPanel.setHasContents(false);
                } else {
                    AppProfileUI.this.profileListPanel.setHasContents(true);
                }
                AppProfileUI.this.profileListPanel.setAppProfiles(type, result);
            }
        }.start();
    }

    @Override
    public void showApp(AppProfile app) {
        this.profileDetailsPanel.setAppProfile(app);
        if (app != null) {
            this.rootComponent.getRightPanel().removeAll();
            this.rootComponent.getRightPanel().add(this.profileDetailsPanel.getRootComponent());
            this.rootComponent.getRightPanel().revalidate();
            this.rootComponent.getRightPanel().repaint();
        }
    }

    @Override
    public void deleteProfile(AppProfile app) {
        System.out.println("[AppProfileUI] Deleting app profile " + app.getName() + " / " + app.getType());
        this.profileListPanel.deleteProfile(app);
        TechUi.INSTANCE.removeGroupAssociatedWith(app, false);
        new ProfileDelete(app).run();
        this.profilesToSave.clear();
    }

    public boolean removeProfileByID(String associatedAppProfileID) {
        AppProfile profileByID = this.profileListPanel.getProfileByID(associatedAppProfileID);
        if (profileByID == null) {
            return false;
        }
        this.deleteProfile(profileByID);
        return true;
    }

    @Override
    public void newProfile(final ProfileType selectedProfileType) {
        new Thread(){

            @Override
            public void run() {
                try {
                    final AppProfile newProfile = AppProfileUI.this.techClient.createAppProfile(selectedProfileType, selectedProfileType.getName() + " App");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppProfileUI.this.profileListPanel.addNewProfile(newProfile);
                        }
                    });
                    try {
                        AppProfileUI.this.techClient.saveAppProfiles(new AppProfile[]{newProfile});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(AppProfile appProfile) {
        System.out.println("[AppProfileUI] Asked to save " + appProfile.getName() + " - " + appProfile.getLaunchProperties());
        LinkedList<AppProfile> linkedList = this.profilesToSave;
        synchronized (linkedList) {
            if (!this.profilesToSave.contains(appProfile)) {
                this.profilesToSave.add(appProfile);
            }
        }
        this.saverUtil.queueSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performSave() {
        AppProfile[] saves;
        LinkedList<AppProfile> linkedList = this.profilesToSave;
        synchronized (linkedList) {
            saves = this.profilesToSave.toArray(new AppProfile[0]);
            this.profilesToSave.clear();
        }
        try {
            this.techClient.saveAppProfiles(saves);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renameProfile(AppProfile app, String newValue) {
        app.setName(newValue);
        this.profileListPanel.renamed(app);
        this.save(app);
    }

    @Override
    public String[][] getVisibleMachineGroups() {
        try {
            return this.techClient.getEntireMachineGroupList();
        }
        catch (Exception ex) {
            return null;
        }
    }

    class ProfileDelete
    extends Thread {
        AppProfile profile;

        public ProfileDelete(AppProfile profile) {
            this.profile = profile;
        }

        @Override
        public void run() {
            try {
                AppProfileUI.this.techClient.deleteAppProfile(this.profile);
                System.out.println("[AppProfileUI] Deleted app profile OK");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

