/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.profiles.model.ProfileType;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import com.aem.shelp.tech.appprofile.UIConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import utils.swing.SwingUtil;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jlist.SimpleListModel;
import utils.swing.simplelist.wrapper.SortWrapper;

public class AppProfileListPanel
implements ListSelectionListener,
ActionListener {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private ProfileUIListener listener;
    private GbPanel headerPanel = new GbPanel();
    private JButton closeButton = new JButton(Language.get("BACK"), ImageLoader.getImageIcon((String)"images/svg/arrows/left.svg,16"));
    private ActionListener closeListener;
    private GlassDialog close;
    private boolean showClose;
    private JButton newAppProfileButton = new JButton(Language.get("NEW_APP_PROFILE"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    private ProfileType selectedProfileType;
    private NoContentsInfoPanel centrePanel = new NoContentsInfoPanel(Language.get("APP_PROFILE_NONE"), null, false);
    private JList list = new JList();
    private ProfileListCellRenderer cellRenderer = new ProfileListCellRenderer();
    private SimpleList<AppProfile> listModel = new SimpleList();
    private SortWrapper<AppProfile> wrapper = new SortWrapper<AppProfile>(this.listModel, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
    private boolean ignoreSelectionChange;
    Icon smaller;

    private Icon getSmallerIcon() {
        if (this.smaller == null) {
            this.smaller = ImageLoader.getImageIcon((String)(this.selectedProfileType.getIconKey() + ",16"));
        }
        return this.smaller;
    }

    public AppProfileListPanel(ProfileUIListener listener) {
        this(listener, false);
    }

    public AppProfileListPanel(ProfileUIListener listener, boolean showClose) {
        this.listener = listener;
        this.showClose = showClose;
        this.initUI();
    }

    public void setCloseDialog(GlassDialog dialog) {
        this.close = dialog;
    }

    public void setCloseListener(ActionListener closeListener) {
        this.closeListener = closeListener;
    }

    private void initUI() {
        SimpleListModel<AppProfile> slm = new SimpleListModel<AppProfile>(this.wrapper);
        this.list.setModel(slm);
        this.list.addListSelectionListener(this);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.cellRenderer);
        JScrollPane pane = new JScrollPane(this.list);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.newAppProfileButton.addActionListener(this);
        SwingUtil.setHeight((JComponent)this.headerPanel, (int)UIConstants.getHeaderHeight());
        this.headerPanel.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.centrePanel.setContentsPanel(pane);
        this.centrePanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        if (this.showClose) {
            this.headerPanel.add((Component)this.closeButton, 0, 0, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 5));
            SwingUtil.setSizesToWidest((JComponent)this.closeButton, (JComponent)this.newAppProfileButton);
            this.closeButton.addActionListener(this);
        }
        this.headerPanel.add((Component)this.newAppProfileButton, 1, 0, 1, 1, 0, 0, 13, 0);
        this.headerPanel.setBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
        this.initContents();
    }

    private void initLoading() {
        ArrowedProgressBar bar = new ArrowedProgressBar();
        bar.on();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        panel.add("Center", bar.getRootComponent());
        this.rootComponent.remove(this.centrePanel);
        this.rootComponent.add((Component)panel, "Center");
        this.centrePanel.setHasContents(true);
        this.newAppProfileButton.setEnabled(false);
    }

    private void initContents() {
        this.rootComponent.removeAll();
        this.rootComponent.add((Component)this.centrePanel, "Center");
        this.rootComponent.add((Component)this.headerPanel, "North");
        this.newAppProfileButton.setEnabled(true);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppProfiles(ProfileType selectedProfileType, AppProfile[] profiles) {
        this.smaller = null;
        this.showLoading(false);
        this.selectedProfileType = selectedProfileType;
        this.listModel.startBatch();
        try {
            this.listModel.clear();
            for (AppProfile p : profiles) {
                this.listModel.add(p);
            }
        }
        finally {
            this.listModel.endBatch();
        }
    }

    public void showLoading(boolean showLoading) {
        if (SwingUtilities.isEventDispatchThread()) {
            new LoadingFlipper(showLoading).run();
        } else {
            SwingUtilities.invokeLater(new LoadingFlipper(showLoading));
        }
    }

    public AppProfile getProfileByID(String associatedAppProfileID) {
        for (AppProfile profile : this.listModel) {
            if (!profile.getID().equals(associatedAppProfileID)) continue;
            return profile;
        }
        return null;
    }

    private AppProfile getSelectedProfile() {
        Object selectedValue = this.list.getSelectedValue();
        if (selectedValue == null || !(selectedValue instanceof AppProfile)) {
            return null;
        }
        return (AppProfile)selectedValue;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.ignoreSelectionChange) {
            return;
        }
        this.listener.showApp(this.getSelectedProfile());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newAppProfileButton) {
            this.listener.newProfile(this.selectedProfileType);
        } else if (e.getSource() == this.closeButton) {
            if (this.close != null) {
                this.close.setVisible(false);
            }
            if (this.closeListener != null) {
                this.closeListener.actionPerformed(null);
            }
        }
    }

    public void addNewProfile(AppProfile profile) {
        this.listModel.add(profile);
        this.list.setSelectedValue(profile, true);
        this.setHasContents(true);
    }

    public void deleteProfile(AppProfile app) {
        this.list.clearSelection();
        this.listModel.remove(app);
    }

    public void setHasContents(boolean b) {
        this.centrePanel.setHasContents(b);
    }

    public void renamed(final AppProfile app) {
        this.ignoreSelectionChange = true;
        try {
            this.listModel.notifyElementUpdate(app);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int index = AppProfileListPanel.this.wrapper.indexOf(app);
                    AppProfileListPanel.this.list.setSelectedIndex(index);
                }
            });
        }
        finally {
            this.ignoreSelectionChange = false;
        }
    }

    class ProfileListCellRenderer
    extends DefaultListCellRenderer {
        Border emptyBorder = SHBorderFactory.createEmptyBorder((int)4, (int)4, (int)4, (int)4);
        int i = 0;
        Icon small;

        ProfileListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderComponent.setIcon(AppProfileListPanel.this.getSmallerIcon());
            renderComponent.setFont(SHStyle.bitBiggerFont);
            renderComponent.setBorder(this.emptyBorder);
            return renderComponent;
        }
    }

    class LoadingFlipper
    implements Runnable {
        private boolean showLoading;

        public LoadingFlipper(boolean showLoading) {
            this.showLoading = showLoading;
        }

        @Override
        public void run() {
            if (this.showLoading) {
                AppProfileListPanel.this.initLoading();
            } else {
                AppProfileListPanel.this.initContents();
            }
            AppProfileListPanel.this.rootComponent.revalidate();
            AppProfileListPanel.this.rootComponent.repaint();
        }
    }
}

