/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.events.server.model;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.ServerEvent;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.model.filters.TextAlertFilter;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertBlankRowGroup;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertHeadingGroup;
import com.aem.shelp.tech.alerts.events.server.model.EventAlertGroup;
import com.aem.shelp.tech.alerts.events.server.model.IconnedEventAlertGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import org.w3c.dom.Element;
import utils.swing.images.ImageLoader;

public class ServerEventsTreeModel
extends AbstractTreeModel<ResourceContainerGroup, ResourceContainer> {
    protected TechClient client;
    private AlertBlankRowGroup blankRowGroup1;
    private AlertBlankRowGroup blankRowGroup2;
    private AlertHeadingGroup savedSearchHeading;

    public ServerEventsTreeModel() {
        this.initSaveHeading();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    @Override
    protected void addFilterProcessors() {
        this.blankRowGroup1 = AlertBlankRowGroup.newBlankRowGroup();
        this.blankRowGroup2 = AlertBlankRowGroup.newBlankRowGroup();
        this.treeModel.addChild(null, this.blankRowGroup1);
        this.treeModel.addChild(null, this.blankRowGroup2);
        this.savedSearchHeading = AlertHeadingGroup.newHeadingGroup(Language.get("SAVED_SEARCHES"));
    }

    public TechClient getTechClient() {
        return this.client;
    }

    @Override
    protected void insertSpecialRootGroup(ResourceContainerGroup group) {
        if (this.containsRootGroup(group)) {
            return;
        }
        if (group == this.savedSearchHeading) {
            this.treeModel.insertChildAfter(null, group, this.blankRowGroup2);
        }
    }

    @Override
    protected ResourceContainerGroup initRootGroup() {
        return IconnedEventAlertGroup.newIconnedGroup(Language.get("SERVER_ALERTS"), ImageLoader.getImageIcon((String)"images/svg/computing/database.svg,24"));
    }

    @Override
    public ResourceContainerGroup newGroup(String name) {
        return EventAlertGroup.newGroup(name);
    }

    public ResourceContainerGroup[] initGroupArray(int size) {
        return new ResourceContainerGroup[size];
    }

    public ServerEvent[] initElementArray(int size) {
        return new ServerEvent[size];
    }

    @Override
    public String getXMLRootTag() {
        return "ServerEventsModel";
    }

    private void initSaveHeading() {
        if (this.savedSearchHeading == null) {
            this.savedSearchHeading = AlertHeadingGroup.newHeadingGroup(Language.get("SAVED_SEARCHES"));
        }
    }

    @Override
    public void moveGroupToFinalChild(ResourceContainerGroup groupToSave) {
        this.insertSpecialRootGroup(this.savedSearchHeading);
        super.moveGroupToFinalChild(groupToSave);
    }

    @Override
    protected void startBatchAddMachines() {
        super.startBatchAddMachines();
    }

    @Override
    protected void endBatchAddMachines() {
        super.endBatchAddMachines();
    }

    @Override
    protected void loadFilterProcessor(Element filterProcessor) {
        TextAlertFilter filter = new TextAlertFilter(null, null);
        filter.fromXML(this, filterProcessor);
        this.addFilterProcessor(filter, filter.getRoot(), false);
    }
}

