/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.model;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.alerts.LocatedAlertGroup;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.model.IconnedAlertGroup;
import com.aem.shelp.tech.alerts.alerts.model.filters.TextAlertFilter;
import com.aem.shelp.tech.alerts.alerts.model.filters.TriggeredAlertFilter;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertBlankRowGroup;
import com.aem.shelp.tech.alerts.alerts.model.subgroups.AlertHeadingGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import java.util.ArrayList;
import org.w3c.dom.Element;
import utils.swing.images.ImageLoader;

public class AlertTreeModel
extends AbstractTreeModel<ResourceContainerGroup, ResourceContainer> {
    protected TechClient client;
    protected ResourceContainerGroup triggeredAlerts;
    private AlertBlankRowGroup blankRowGroup1;
    private AlertBlankRowGroup blankRowGroup2;
    private AlertHeadingGroup savedSearchHeading;

    public AlertTreeModel() {
        this.initSaveHeading();
    }

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFilterProcessors() {
        this.triggeredAlerts = IconnedAlertGroup.newIconnedGroup(Language.get("TRIGGERED_ALERTS"), ImageLoader.getImageIcon((String)Icons.ALERT_STATUS_TAB_BAD));
        this.blankRowGroup1 = AlertBlankRowGroup.newBlankRowGroup();
        this.blankRowGroup2 = AlertBlankRowGroup.newBlankRowGroup();
        this.treeModel.addChild(null, this.blankRowGroup1);
        this.treeModel.addChild(null, this.blankRowGroup2);
        this.savedSearchHeading = AlertHeadingGroup.newHeadingGroup(Language.get("SAVED_SEARCHES"));
        ArrayList arrayList = this.filterProcessors;
        synchronized (arrayList) {
            this.filterProcessors.add(new TriggeredAlertFilter(this.triggeredAlerts));
        }
    }

    public TechClient getTechClient() {
        return this.client;
    }

    @Override
    protected void insertSpecialRootGroup(ResourceContainerGroup group) {
        if (this.containsRootGroup(group)) {
            return;
        }
        if (group == this.triggeredAlerts) {
            this.treeModel.insertChildAfter(null, group, this.rootElementGroup);
        } else if (group == this.savedSearchHeading) {
            this.treeModel.insertChildAfter(null, group, this.blankRowGroup2);
        }
    }

    @Override
    protected ResourceContainerGroup initRootGroup() {
        return IconnedAlertGroup.newIconnedGroup(Language.get("ALL_ALERTS"), ImageLoader.getImageIcon((String)"images/svg/charts/meter.svg,16"));
    }

    @Override
    public ResourceContainerGroup newGroup(String name) {
        return LocatedAlertGroup.newGroup(name);
    }

    public ResourceContainerGroup[] initGroupArray(int size) {
        return new ResourceContainerGroup[size];
    }

    public LocatedAlert[] initElementArray(int size) {
        return new LocatedAlert[size];
    }

    @Override
    public String getXMLRootTag() {
        return "AlertsModel";
    }

    private void initSaveHeading() {
        if (this.savedSearchHeading == null) {
            this.savedSearchHeading = AlertHeadingGroup.newHeadingGroup(Language.get("SAVED_SEARCHES"));
        }
    }

    @Override
    public void moveGroupToFinalChild(ResourceContainerGroup groupToSave) {
        this.insertSpecialRootGroup(this.savedSearchHeading);
        super.moveGroupToFinalChild(groupToSave);
    }

    @Override
    protected void startBatchAddMachines() {
        super.startBatchAddMachines();
    }

    @Override
    protected void endBatchAddMachines() {
        super.endBatchAddMachines();
    }

    @Override
    protected void loadFilterProcessor(Element filterProcessor) {
        TextAlertFilter filter = new TextAlertFilter(null, null);
        filter.fromXML(this, filterProcessor);
        this.addFilterProcessor(filter, filter.getRoot(), false);
    }
}

