/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.alerts.AlertCategory;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerConfigListener;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerConfigPanel;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import utils.swing.components.animated.slider.ChoiceItem;
import utils.swing.components.animated.slider.SlidingChoiceList;
import utils.swing.components.animated.slider.SlidingChoiceListener;
import utils.swing.images.ImageLoader;

public class TriggerPickerPanel
extends JPanel
implements SlidingChoiceListener,
TriggerConfigListener {
    TriggerConfigListener listener;
    TechClient client;
    MachineTreeModel machines;
    TriggerConfigPanel current;
    boolean acceptable = false;

    public void setTriggerPickerListener(TriggerConfigListener listener) {
        this.listener = listener;
    }

    public TriggerPickerPanel(TechClient client, MachineTreeModel machines) {
        this.client = client;
        this.machines = machines;
        this.initUI(null);
    }

    public TriggerPickerPanel(TechClient client, MachineTreeModel machines, Alert alert) {
        this.client = client;
        this.machines = machines;
        this.initUI(alert);
    }

    private ChoiceItem getChoiceItem(Alert alert) {
        Icon icon = alert.getTypeOverlayKey() != null ? ImageLoader.getImageIcon((String)Icons.overlay(alert.getTypeIconKey(), alert.getTypeOverlayKey())) : ImageLoader.getImageIcon((String)alert.getTypeIconKey());
        ChoiceItem cc = new ChoiceItem(Language.get(alert.getTypeNameKey()), Language.get(alert.getTypeDescKey()), null, icon, new TriggerConfigPanel(this.client, this.machines, alert));
        return cc;
    }

    private ChoiceItem getChoiceItem(AlertCategory cat, Alert loadme) {
        ArrayList<Alert> alerts = ResourceSerialiser.getCategory(cat);
        ArrayList<ChoiceItem> choices = new ArrayList<ChoiceItem>();
        for (Alert alert : alerts) {
            if (loadme != null) {
                if (alert.getClass() == loadme.getClass()) {
                    ChoiceItem item = this.getChoiceItem(loadme);
                    item.setPreSelected(true);
                    this.current = (TriggerConfigPanel)item.getContentPanel();
                    choices.add(item);
                    continue;
                }
                choices.add(this.getChoiceItem(alert.cloneWithNewID()));
                continue;
            }
            choices.add(this.getChoiceItem(alert.cloneWithNewID()));
        }
        String exampleKey = cat.getName() + "_EX";
        String example = Language.get(exampleKey);
        if (example.equals(exampleKey)) {
            example = null;
        }
        return new ChoiceItem(Language.get(cat.getName()), Language.get(cat.getName() + "_DESC"), example, ImageLoader.getImageIcon((String)cat.getIcon()), choices);
    }

    private void initUI(Alert loadme) {
        AlertCategory[] cats = AlertCategory.ALL;
        ArrayList<ChoiceItem> list = new ArrayList<ChoiceItem>();
        for (AlertCategory cat : cats) {
            list.add(this.getChoiceItem(cat, loadme));
        }
        SlidingChoiceList choiceList = new SlidingChoiceList(list);
        choiceList.setSlidingChoiceListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", choiceList.getRootComponent());
    }

    @Override
    public void transitionedTo(ChoiceItem item) {
        JComponent jc = item.getContentPanel();
        if (jc != null) {
            this.current = (TriggerConfigPanel)jc;
            this.current.setTriggerConfigListener(this);
        } else {
            this.isAcceptable(false);
        }
    }

    public Alert getConfiguredAlert() {
        return this.current.getConfiguredAlert();
    }

    public boolean isAcceptable() {
        return this.acceptable;
    }

    @Override
    public void isAcceptable(boolean acceptable) {
        this.acceptable = acceptable;
        this.listener.isAcceptable(acceptable);
    }

    public boolean canCreateCorollary() {
        return this.current.canCreateCorollary();
    }
}

