/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerConfigListener;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerPickerPanel;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;

public class TriggerPickerDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener,
TriggerConfigListener {
    protected JPanel main = new JPanel();
    protected JButton bok;
    protected JButton bokpair;
    protected JButton bcancel;
    protected Object userData;
    protected boolean isOK = false;
    protected boolean createPair = false;
    protected JPanel contentPanel;
    protected TriggerPickerPanel picker;
    private boolean amEditing = false;
    private TechClient client;
    private MachineTreeModel machines;

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        TriggerPickerDialog dialog = new TriggerPickerDialog(null, null, (RootPaneContainer)frame);
        dialog.showDialog();
    }

    public TriggerPickerDialog(TechClient client, MachineTreeModel machines, RootPaneContainer rootPane) {
        this(client, machines, rootPane, null);
    }

    public TriggerPickerDialog(TechClient client, MachineTreeModel machines, RootPaneContainer rootPane, Alert loadme) {
        super(rootPane, 600, 500, true, true, false);
        if (loadme != null) {
            this.amEditing = true;
        }
        this.machines = machines;
        this.client = client;
        this.setModal(true);
        this.initUI(loadme);
        this.setTitle(Language.get("ALERT_TRIGGER_CREATE_DIALOG"));
        if (loadme == null) {
            this.bok.setEnabled(false);
        } else {
            this.bok.setEnabled(true);
        }
        this.bokpair.setEnabled(this.bok.isEnabled());
    }

    public boolean mustCreatePair() {
        return this.createPair;
    }

    public boolean isOKResult() {
        return this.isOK;
    }

    public void showDialog() {
        this.setVisible(true);
    }

    protected String getDescription() {
        return null;
    }

    protected Insets getFieldInsets() {
        return new ScaledInsets(3, 3, 3, 3);
    }

    protected boolean isValid() {
        return this.picker.isAcceptable();
    }

    protected void initUI(Alert loadme) {
        this.main.setLayout(new BorderLayout());
        this.contentPanel = new JPanel(new BorderLayout());
        this.main.add("Center", this.contentPanel);
        this.contentPanel.setLayout(new GridLayout(1, 1));
        this.picker = new TriggerPickerPanel(this.client, this.machines, loadme);
        this.picker.setTriggerPickerListener(this);
        this.contentPanel.add(this.picker);
        this.bok = this.amEditing ? new JButton(Language.get("FINISH")) : new JButton(Language.get("CREATE_ONE"));
        SHButtonUI.makeButtonBlue((JButton)this.bok);
        this.bokpair = new JButton(Language.get("CREATE_PAIR"));
        SHButtonUI.makeButtonBlue((JButton)this.bokpair);
        this.bcancel = new JButton(Language.get("CANCEL"));
        this.bcancel.addActionListener(this);
        JPanel buttons = this.initButtonsPanel();
        this.main.add("South", buttons);
        this.bok.addActionListener(this);
        this.bok.setEnabled(this.isValid());
        this.bokpair.addActionListener(this);
        this.bokpair.setEnabled(this.bok.isEnabled());
        this.setFocusComponent(this.bok);
        this.bok.addKeyListener(this);
        this.getContentPane().add(this.main);
    }

    private JPanel initButtonsPanel() {
        JPanel buttons = new JPanel();
        buttons.setLayout((LayoutManager)new ScaledFlowLayout(2, SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        buttons.add(this.bcancel);
        if (!this.amEditing) {
            buttons.add(this.bokpair);
        }
        buttons.add(this.bok);
        if (!this.amEditing) {
            SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.bcancel, this.bok, this.bokpair});
        } else {
            SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.bcancel, this.bok});
        }
        return buttons;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bok) {
            this.okPressed(false);
        } else if (e.getSource() == this.bokpair) {
            this.okPressed(true);
        } else {
            this.cancelPressed();
        }
    }

    public void changed() {
        if (this.bok != null) {
            this.bok.setEnabled(this.isValid());
            this.bokpair.setEnabled(this.bok.isEnabled());
        }
        this.bokpair.setVisible(this.picker.canCreateCorollary());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.isValid()) {
            this.okPressed(false);
        } else if (e.getKeyCode() == 27) {
            this.cancelPressed();
        }
    }

    protected void okPressed(boolean createPair) {
        this.isOK = true;
        this.createPair = createPair;
        this.setVisible(false);
    }

    protected void cancelPressed() {
        this.isOK = false;
        this.setVisible(false);
    }

    public Alert getConfiguredAlert() {
        return this.picker.getConfiguredAlert();
    }

    @Override
    public void isAcceptable(boolean acceptable) {
        this.changed();
    }
}

