/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details;

import com.aem.shelp.proxy.types.filters.CombinedMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.utils.filters.CombinedMachineFiltersUI;
import com.aem.shelp.tech.utils.filters.FilterChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import utils.swing.customlaf.SHBorderFactory;

public class AlertMachinePickerPanel
implements FilterChangeListener {
    private JPanel rootComponent = new JPanel();
    private CombinedMachineFiltersUI combinedFiltersUI;
    private MachineTreeModel model;
    private AlertModifyListener modify;
    private boolean initialising;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public AlertMachinePickerPanel(AlertModifyListener modify, MachineTreeModel model) {
        this.modify = modify;
        this.model = model;
        this.initUI();
    }

    public void initUI() {
        this.combinedFiltersUI = new CombinedMachineFiltersUI(this, true);
        this.combinedFiltersUI.setMachineTreeModel(this.model);
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.rootComponent.setLayout(new BorderLayout());
        this.rootComponent.add((Component)this.combinedFiltersUI.getRootComponent(), "Center");
    }

    @Override
    public void filterChanged() {
        if (this.modify != null && !this.initialising) {
            this.modify.alertModified();
        }
    }

    public void load(CombinedMachineFilter machineFilter) {
        this.initialising = true;
        try {
            this.combinedFiltersUI.setExistingFilters(machineFilter);
        }
        finally {
            this.initialising = false;
        }
    }

    public CombinedMachineFilter getMachineFilter() {
        return this.combinedFiltersUI.getMachineFilter();
    }
}

