/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.AlertSearchConfig;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.common.HistoryElement;
import com.aem.shelp.proxy.common.alerts.AlertReason;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.alerts.AlertHistoryListener;
import com.aem.shelp.tech.alerts.alerts.details.utils.VariableRowHeightTable;
import com.aem.shelp.tech.history.HistoryPanelCellRenderer;
import com.aem.shelp.tech.utils.MachineGroupLabel;
import com.aem.shelp.util.EasyDateTimeFormatter;
import com.aem.shelp.util.ElapsedTimeFormatter;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import utils.progtools.OnDemandThreadPool;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHJTable;
import utils.swing.components.scrollpane.LockableViewPort;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthGbPanel;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.EmptyIcon;
import utils.swing.images.ImageLoader;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class AlertHistorySubPanel
implements AlertHistoryListener,
MouseListener {
    private final AlertPanelListener accessPanelListener;
    private static final int MAX_RESULTS = 50;
    private NoContentsInfoPanel rootComponent;
    private SimpleList<HistoryElement> elementList;
    private JScrollPane pane;
    private SHJTable table;
    private TableStructure ts;
    private SimpleTableModel model;
    private AlertHistoryRenderer renderer;
    private TechClient techClient;
    private LockableViewPort viewPort;
    private OnDemandThreadPool threadPool = new OnDemandThreadPool("HistoryDetailsPanel", 2, 0, 5);
    private LoadingHistoryElement loadingElement = new LoadingHistoryElement();
    private boolean includedLoading = false;
    private MoreDataThread moreDataThread;

    public AlertHistorySubPanel(AlertPanelListener accessPanelListener) {
        this.accessPanelListener = accessPanelListener;
        this.initUI();
    }

    private void initUI() {
        this.elementList = new SimpleList();
        this.ts = TableStructure.createTableStructure(HistoryElement.class, new String[]{"triggered", "time", "", "", "", ""}, new String[]{"", Language.get("ALERT_HISTORY_TIME"), Language.get("ALERT_HISTORY_TRIGGERED_FOR"), Language.get("ALERT_HISTORY_REASON"), Language.get("MACHINE_NAME"), Language.get("")}, SimpleHelpLookAndFeel.scale((int[])new int[]{25, 120, 110, -1, -1, 30}), new boolean[]{false, false, false, false, false});
        this.ts.setMinWidths(SimpleHelpLookAndFeel.scale((int[])new int[]{25, 120, 110, -1, -1, 30}));
        this.ts.setMaxWidths(SimpleHelpLookAndFeel.scale((int[])new int[]{25, 120, 110, -1, -1, 30}));
        this.ts.setAlignment(new int[]{4, 4, 2, 2, 0});
        this.model = new SimpleTableModel(this.elementList, this.ts);
        this.table = new SHJTable(this.model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                try {
                    HistoryElement historyElement = (HistoryElement)AlertHistorySubPanel.this.elementList.get(rowIndex);
                    if (historyElement != null) {
                        return historyElement.getReasonSummary();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.table.addMouseListener(this);
        this.table.getTableHeader().setDefaultRenderer(new HistoryPanelCellRenderer.HeaderAlignmentWrapper(this.table));
        this.model.assignToTable(this.table);
        this.renderer = new AlertHistoryRenderer();
        this.table.setDefaultRenderer(Boolean.class, this.renderer);
        this.table.setDefaultRenderer(Long.class, this.renderer);
        this.table.setDefaultRenderer(Object.class, this.renderer);
        this.table.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.rootComponent = new NoContentsInfoPanel(Language.get("LOADING") + "...", null, false);
        this.pane = new JScrollPane();
        this.viewPort = new LockableViewPort();
        this.viewPort.setView(this.table);
        this.pane.setViewport(this.viewPort);
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.rootComponent.setContentsPanel(this.pane);
        this.rootComponent.setTitle(Language.get("ALERTS_NO_HISTORY"));
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
        techClient.addAlertHistoryListener(this);
    }

    @Override
    public void searchResults(final ArrayList<HistoryElement> results, final boolean isFinished) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AlertHistorySubPanel.this.elementList.size() + results.size() == 0) {
                    AlertHistorySubPanel.this.rootComponent.setHasContents(false);
                } else {
                    AlertHistorySubPanel.this.rootComponent.setHasContents(true);
                }
                int currentSize = AlertHistorySubPanel.this.elementList.size();
                if (currentSize > 0 && AlertHistorySubPanel.this.elementList.get(currentSize - 1) == AlertHistorySubPanel.this.loadingElement) {
                    AlertHistorySubPanel.this.elementList.remove(currentSize - 1);
                }
                AlertHistorySubPanel.this.elementList.addAll(results);
                if (!isFinished) {
                    AlertHistorySubPanel.this.includedLoading = true;
                    AlertHistorySubPanel.this.elementList.add(AlertHistorySubPanel.this.loadingElement);
                    ((AlertHistorySubPanel)AlertHistorySubPanel.this).loadingElement.loadRequested = false;
                } else {
                    AlertHistorySubPanel.this.includedLoading = false;
                }
            }
        });
    }

    @Override
    public byte getHistoryID() {
        return 1;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void showAlertHistory(final String alertID) {
        this.threadPool.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    AlertHistorySubPanel.this.rootComponent.setHasContents(false);
                    AlertHistorySubPanel.this.elementList.clear();
                    AlertSearchConfig config = new AlertSearchConfig();
                    config.setId(AlertHistorySubPanel.this.getHistoryID());
                    config.setStartTime(0L);
                    config.setEndTime(System.currentTimeMillis());
                    config.setAlertID(alertID);
                    config.setMaxResults(50);
                    AlertHistorySubPanel.this.techClient.requestNewAlertHistorySearch(config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void moreData() {
        if (this.moreDataThread != null) {
            this.moreDataThread.die();
        }
        this.moreDataThread = new MoreDataThread();
        this.moreDataThread.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        HistoryElement historyElement;
        Point p = e.getPoint();
        int row = this.table.rowAtPoint(p);
        int col = this.table.columnAtPoint(p);
        if (row != -1 && col == 5 && (historyElement = this.elementList.get(row)) != null) {
            this.showAlertDialog(historyElement);
        }
    }

    private void showAlertDialog(HistoryElement historyElement) {
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)((Object)new AlertSummaryPanel(historyElement)));
        panel.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)600));
        SHGlassOptionPane.showOkCancelPanelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (JComponent)panel, (String)Language.get("ALERT_HISTORY_TITLE"), (String)Language.get("CLOSE"), null);
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        HistoryElement element = new HistoryElement(System.currentTimeMillis(), true);
        for (int i = 0; i < 1; ++i) {
            AlertReason reason = new AlertReason();
            reason.reason = "This is the short reason\nWith\nSome\nNew lines This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason --DONE--";
            reason.contextDump = "This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason This is the longer reason --DONE--";
            Machine m = new Machine("Group " + i + "/Machine " + i);
            element.addTriggerEvent(System.currentTimeMillis() + (long)(i * 60000), m, reason);
        }
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)((Object)new AlertSummaryPanel(element)));
        panel.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)600));
        SHGlassOptionPane.showOkCancelPanelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)frame), (JComponent)panel, (String)Language.get("ALERT_HISTORY_TITLE"), (String)Language.get("OK"), null);
    }

    class MoreDataThread
    extends Thread {
        private boolean die;

        public MoreDataThread() {
            super("AlertMoreDataThread");
            this.die = false;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.die) {
                return;
            }
            try {
                AlertHistorySubPanel.this.techClient.requestMoreAlertHistoryData(50);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
        }
    }

    static class TriggerEventsSummaryPanel
    extends JPanel {
        private VariableRowHeightTable table;

        public TriggerEventsSummaryPanel(HistoryElement element) {
            DefaultTableModel tableModel = new DefaultTableModel(0, 1){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            for (HistoryElement.TriggerEvent event : element.getTriggerEvents()) {
                tableModel.addRow(new Object[]{event});
            }
            this.table = new VariableRowHeightTable(tableModel);
            this.table.setTableHeader(null);
            this.table.getColumnModel().getColumn(0).setCellRenderer(new TriggerEventsSummaryPanelRenderer());
            JScrollPane pane = new JScrollPane(this.table);
            this.setLayout(new GridLayout(1, 1));
            this.add(pane);
            this.table.doLayout();
            int height = this.table.getPreferredSize().height + SimpleHelpLookAndFeel.scale((int)10);
            SwingUtil.setHeight((JComponent)pane, (int)Math.min(SimpleHelpLookAndFeel.scale((int)300), height));
        }
    }

    static class TriggerEventsSummaryPanelRenderer
    extends DefaultTableCellRenderer {
        private TriggerEventsPanel rendererPanel = new TriggerEventsPanel();

        TriggerEventsSummaryPanelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            HistoryElement.TriggerEvent event = (HistoryElement.TriggerEvent)value;
            MachineName machineName = MachineName.extractFromNameWithGroup(event.machineName);
            this.rendererPanel.machineLabel.setText(machineName.getName());
            this.rendererPanel.groupLabel.setMachineName(machineName, false);
            this.rendererPanel.setTime(event.time);
            this.rendererPanel.reasonValue.setText("<html>" + event.reason.reason);
            if (row % 2 == 1) {
                this.rendererPanel.setBackground(UIManager.getColor("Table.alternateRowColor"));
            } else {
                this.rendererPanel.setBackground(UIManager.getColor("Table.background"));
            }
            return this.rendererPanel;
        }
    }

    static class TriggerEventsPanel
    extends ColorPropagatingPanel
    implements VariableRowHeightTable.RowHeightCellRenderer {
        private final ColorPropagatingGBPanel subPanel;
        private JLabel machineLabel = new JLabel();
        private JLabel timeLabel = new JLabel();
        private MachineGroupLabel groupLabel = new MachineGroupLabel();
        private FixedWidthLabel reasonValue = new FixedWidthLabel();
        private EasyDateTimeFormatter dateTimeFormatter = new EasyDateTimeFormatter();

        public TriggerEventsPanel() {
            this.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
            this.setLayout(new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
            this.subPanel = new ColorPropagatingGBPanel(new ScaledInsets(5, 0, 0, 0));
            this.subPanel.add(this.machineLabel, 0, 0, 1, 1, 1, 1, 17, 1);
            this.subPanel.add(this.timeLabel, 1, 0, 1, 1, 0, 1, 13, 1);
            this.subPanel.add((Component)((Object)this.groupLabel), 0, 1, 2, 1, 1, 1, 17, 1);
            this.add((Component)((Object)this.subPanel), "North");
            this.add((Component)this.reasonValue, "Center");
            this.reasonValue.setPreferredWidth(SimpleHelpLookAndFeel.scale((int)450));
            this.machineLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
            this.groupLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16"));
        }

        public void setTime(long time) {
            this.timeLabel.setText(this.dateTimeFormatter.formatDateTime(time));
        }

        @Override
        public int getPreferredHeight() {
            return this.reasonValue.getPreferredSize().height + this.subPanel.getPreferredSize().height + SimpleHelpLookAndFeel.scale((int)10) * 2;
        }
    }

    static class AlertSummaryPanel
    extends FixedWidthGbPanel {
        private EasyDateTimeFormatter dateTimeFormatter = new EasyDateTimeFormatter();
        private final HistoryElement element;

        public AlertSummaryPanel(HistoryElement element) {
            super(new ScaledInsets(5, 5, 5, 5));
            this.element = element;
            this.initUI();
        }

        public void initUI() {
            FixedWidthLabel dateLabel = new FixedWidthLabel(Language.get("ALERT_HISTORY_TIME"));
            FixedWidthLabel triggerTypeLabel = new FixedWidthLabel(Language.get("ALERT_HISTORY_STATE"));
            FixedWidthLabel reasonLabel = new FixedWidthLabel(Language.get("ALERT_HISTORY_REASON"));
            dateLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            triggerTypeLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            reasonLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            reasonLabel.setVerticalAlignment(1);
            FixedWidthLabel dateValue = new FixedWidthLabel();
            FixedWidthLabel triggerValue = new FixedWidthLabel();
            dateLabel.setHorizontalAlignment(4);
            triggerTypeLabel.setHorizontalAlignment(4);
            reasonLabel.setHorizontalAlignment(4);
            this.add((Component)dateLabel, 0, 0, 1, 1, 0, 0, 13, 3);
            this.add((Component)dateValue, 1, 0, 1, 1, 1, 0, 17, 1);
            this.add((Component)triggerTypeLabel, 0, 1, 1, 1, 0, 0, 13, 3);
            this.add((Component)triggerValue, 1, 1, 1, 1, 1, 0, 17, 1);
            if (this.element.getTriggerEvents() != null && this.element.getTriggerEvents().size() > 0) {
                this.add((Component)reasonLabel, 0, 2, 1, 1, 0, 0, 13, 3);
                TriggerEventsSummaryPanel summaryPanel = new TriggerEventsSummaryPanel(this.element);
                this.add(summaryPanel, 1, 2, 1, 1, 1, 1, 17, 1);
            }
            dateValue.setText(this.dateTimeFormatter.formatDateTime(this.element.getTime()));
            if (this.element.isTriggered()) {
                triggerValue.setText(Language.get("TRIGGERED"));
                triggerValue.setIcon(ImageLoader.getImageIcon((String)Icons.ALERT_STATUS_TAB_BAD));
            } else {
                triggerValue.setText(Language.get("ALERT_RESET"));
                triggerValue.setIcon(null);
            }
        }
    }

    class AlertHistoryRenderer
    extends DefaultTableCellRenderer {
        private Icon arrowIcon = new SHProgressAnimatedIcon();
        private EasyDateTimeFormatter dateTimeFormatter = new EasyDateTimeFormatter();
        private EmptyIcon emptyIcon = new EmptyIcon(SimpleHelpLookAndFeel.scale((int)16));
        private ElapsedTimeFormatter elapsedTimeFormatter = new ElapsedTimeFormatter();

        AlertHistoryRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            label.setText("");
            if (value == null) {
                return label;
            }
            if (AlertHistorySubPanel.this.includedLoading && row == AlertHistorySubPanel.this.elementList.size() - 1) {
                if (column == 0) {
                    label.setIcon(this.arrowIcon);
                    label.setText(Language.get("LOADING") + "...");
                    label.setFont(SHStyle.smallerFont);
                    label.setHorizontalAlignment(2);
                    label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
                    if (!((AlertHistorySubPanel)AlertHistorySubPanel.this).loadingElement.loadRequested) {
                        ((AlertHistorySubPanel)AlertHistorySubPanel.this).loadingElement.loadRequested = true;
                        AlertHistorySubPanel.this.moreData();
                    }
                }
                return label;
            }
            if (isSelected) {
                label.setForeground(UIManager.getColor("Table.selectionForeground"));
            } else {
                label.setForeground(UIManager.getColor("Table.foreground"));
            }
            if (column == 0 || column == 2) {
                label.setFont(SHStyle.smallerFont);
            } else {
                label.setFont(SHStyle.normalFont);
            }
            if (column == 0) {
                if (((Boolean)value).booleanValue()) {
                    label.setIcon(ImageLoader.getImageIcon((String)Icons.ALERT_STATUS_TAB_BAD));
                } else {
                    label.setIcon(ImageLoader.getImageIconLightGrey((String)"images/svg/alert-flags/blue-down.svg,24"));
                }
            }
            if (column == 1) {
                label.setFont(SHStyle.smallerFont);
                if (!isSelected) {
                    label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
                }
                label.setText(this.dateTimeFormatter.formatDateTime((Long)value));
            } else if (column == 2) {
                HistoryElement historyElement;
                HistoryElement ourElement = (HistoryElement)value;
                if (!ourElement.isTriggered() && AlertHistorySubPanel.this.elementList.size() > row + 1 && (historyElement = (HistoryElement)AlertHistorySubPanel.this.elementList.get(row + 1)).isTriggered() && historyElement != AlertHistorySubPanel.this.loadingElement) {
                    label.setText(this.elapsedTimeFormatter.getFormattedTime(ourElement.getTime() - historyElement.getTime()));
                }
            } else if (column == 3) {
                HistoryElement ourElement = (HistoryElement)value;
                label.setText(ourElement.getReasonSummary());
            } else if (column == 4) {
                HistoryElement ourElement = (HistoryElement)value;
                ArrayList<HistoryElement.TriggerEvent> triggers = ourElement.getTriggerEvents();
                if (triggers != null && triggers.size() == 1) {
                    label.setText(triggers.get((int)0).machineName);
                    label.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
                } else {
                    label.setText(ourElement.getReasonSummary());
                }
            } else if (column == 5) {
                label.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/dialogs/information.svg,16"));
            }
            return label;
        }
    }

    class LoadingHistoryElement
    extends HistoryElement {
        boolean loadRequested;

        public LoadingHistoryElement() {
            super(0L, true);
            this.loadRequested = false;
        }
    }
}

