/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.ActionableResourceContainer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.AlertsAdvancedPanel;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeListener;
import com.aem.shelp.tech.alerts.alerts.utils.AlertSelection;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import com.aem.shelp.tech.hierarchy.ui.AbstractDetailsPanel;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import com.aem.shelp.tech.utils.MonitoringSwitch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.JEditableLabel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public abstract class AbstractAlertsDetailsPanel
extends AbstractDetailsPanel
implements AlertModelChangeListener,
JEditableLabel.EditListener,
ActionListener,
AlertModifyListener {
    private static boolean AUTO_APPLY = true;
    private AlertsAdvancedPanel contentMultiple;
    protected AbstractTreeModel<ResourceContainerGroup, ResourceContainer> model;
    protected AlertPanelListener alertPanelListener;
    protected ResourceContainer alert;
    protected ResourceContainerGroup parentGroup;
    protected MachineTreeModel machineModel;
    protected TreeSelection.SelectedGroup selection;
    protected AlertSelection multipleSelection;
    protected TechClient client;
    protected JButton deleteButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,16"));
    protected JButton saveButton = new JButton(Language.get("ALERTS_SAVE"));
    protected MonitoringSwitch activeButton;
    protected JLabel activeLabel;
    private TreeNodeFilterProcessor selectedFilterProcessor;
    boolean unavailableView = false;
    private ResourceContainer alertToEdit;
    private ResourceContainerGroup alertGroupToEdit;

    public void setTechClient(TechClient client) {
        this.client = client;
    }

    public AbstractAlertsDetailsPanel(MachineTreeModel machineModel, AlertPanelListener alertPanelListener) {
        super(alertPanelListener);
        this.machineModel = machineModel;
        this.alertPanelListener = alertPanelListener;
        this.initUI();
    }

    public void setModel(AbstractTreeModel<ResourceContainerGroup, ResourceContainer> model) {
        this.model = model;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.multipleSelection == null) {
            if (e.getSource() == this.saveButton) {
                this.saveAlert();
            } else if (e.getSource() == this.activeButton) {
                this.activeToggled();
            } else if (e.getSource() == this.deleteButton) {
                this.deleteAlert();
            } else if (e.getSource() instanceof AbstractButton) {
                this.handleViewSwitch((AbstractButton)e.getSource());
            }
        }
    }

    public void deleteAlert() {
        boolean isOK = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("ALERT_DELETE_ENTIRE_MSG", "'" + this.alert.getName().getName() + "'"), (String)Language.get("ALERT_DELETE_ENTIRE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,48"), (String)Language.get("DELETE"), (String)Language.get("CANCEL"));
        if (!isOK) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AbstractAlertsDetailsPanel.this.model.removeElements(new ResourceContainer[]{AbstractAlertsDetailsPanel.this.alert});
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(task).start();
        } else {
            task.run();
        }
        this.initUIWithNoSelection();
        this.alertPanelListener.alertDeleted(this.alert);
    }

    public void activeToggled() {
        if (this.activeButton.isSelected()) {
            this.activeLabel.setText(Language.get("ALERTS_ACTIVE"));
        } else {
            this.activeLabel.setText(Language.get("ALERTS_INACTIVE"));
        }
        boolean save = true;
        if (save) {
            this.saveAlert();
        } else {
            this.activeButton.setSelected(!this.activeButton.isSelected());
        }
    }

    public void saveAlert() {
        if (this.alert instanceof ActionableResourceContainer) {
            ((ActionableResourceContainer)this.alert).setActive(this.activeButton.isSelected());
        }
        if (!AUTO_APPLY) {
            this.saveButton.setEnabled(false);
        }
        this.alertPanelListener.alertUpdated(this.alert);
    }

    @Override
    public void alertModified() {
        if (AUTO_APPLY) {
            this.saveAlert();
        } else {
            this.saveButton.setEnabled(true);
        }
    }

    @Override
    protected void initButtonBar() {
        super.initButtonBar();
        this.activeButton = new MonitoringSwitch();
        this.activeButton.setBackground(AccessStyle.GROUP_TITLE_BACKGROUND);
        this.activeLabel = new JLabel(Language.get("ALERTS_INACTIVE")){
            JLabel x1;
            JLabel x2;
            {
                this.x1 = new JLabel(Language.get("ALERTS_ACTIVE") + " ");
                this.x2 = new JLabel(Language.get("ALERTS_INACTIVE") + " ");
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = Math.max(this.x1.getPreferredSize().width, this.x2.getPreferredSize().width);
                return d;
            }
        };
        this.initViewButtons(null);
        SHButtonUI.makeButtonBlue((JButton)this.saveButton);
        this.buttonBarRight.add(this.activeButton);
        this.buttonBarRight.add(this.activeLabel);
        this.buttonBarRight.add(this.deleteButton);
        if (!AUTO_APPLY) {
            this.buttonBarRight.add(this.saveButton);
        }
        this.deleteButton.setToolTipText(Language.get("SERVER_EVENT_DELETE_TOOLTIP"));
        this.deleteButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.activeButton.addActionListener(this);
        SwingUtil.setHeight((JComponent)this.saveButton, (int)this.getButtonHeight());
        SwingUtil.setHeight((JComponent)this.deleteButton, (int)this.getButtonHeight());
        this.saveButton.setEnabled(false);
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.contentMultiple = new AlertsAdvancedPanel(this.alertPanelListener);
    }

    public void initUIForMultipleMachines(TreeSelection<ResourceContainerGroup, ResourceContainer> selection) {
        this.selection = null;
        this.multipleSelection = (AlertSelection)selection;
        this.contentMultiple.initSelectedMachines(this.multipleSelection);
        this.setCoreComponent((JPanel)((Object)this.contentMultiple));
        this.rootComponent.repaint();
        if (!AUTO_APPLY) {
            this.saveButton.setEnabled(false);
        }
    }

    private boolean isAlreadySelected(TreeSelection.SelectedGroup newSelection) {
        if (this.selection == null) {
            return false;
        }
        if (newSelection == null) {
            return false;
        }
        ResourceContainer current = (ResourceContainer)this.selection.getFirstMachine();
        ResourceContainer newMachine = (ResourceContainer)newSelection.getFirstMachine();
        return current.getID().equals(newMachine.getID());
    }

    public JComponent getChild(JPanel parent, int row, int column, int width) {
        int index = row * width + column;
        if (index >= parent.getComponentCount()) {
            return null;
        }
        return (JComponent)parent.getComponent(index);
    }

    public void initUIWithNoSelection() {
        this.selection = null;
        this.multipleSelection = null;
        this.setCoreComponent(new JPanel());
    }

    public void initUIWithSingleMachine(TreeSelection.SelectedGroup selection) {
        if (this.isAlreadySelected(selection)) {
            return;
        }
        if (this.selection != null && selection != null) {
            ResourceContainer alert = (ResourceContainer)selection.getFirstMachine();
            ResourceContainer thisAlert = (ResourceContainer)this.selection.getFirstMachine();
            if (alert != null && thisAlert != null && alert.getID().equals(thisAlert.getID()) && this.saveButton.isEnabled()) {
                return;
            }
        }
        this.selection = selection;
        this.multipleSelection = null;
        if (selection == null) {
            this.alert = null;
        } else {
            this.alert = (ResourceContainer)selection.getFirstMachine();
            this.parentGroup = (ResourceContainerGroup)selection.group;
        }
        this.saveButton.setEnabled(false);
        if (this.alert == null) {
            this.setCoreComponent(new JPanel());
            return;
        }
        if (!this.containerSingle.isVisible()) {
            this.containerSingle.setVisible(true);
        }
        this.setCoreComponent(this.containerSingle);
        this.initUIForSingleAlert(this.alert);
        this.rootComponent.repaint();
        this.saveButton.setEnabled(false);
    }

    protected void initUIForSingleAlert(ResourceContainer alert) {
        if (alert instanceof ActionableResourceContainer) {
            this.activeButton.setSelected(((ActionableResourceContainer)alert).isActive());
        }
        if (this.activeButton.isSelected()) {
            this.activeLabel.setText(Language.get("ALERTS_ACTIVE"));
        } else {
            this.activeLabel.setText(Language.get("ALERTS_INACTIVE"));
        }
    }

    private void setCoreComponent(JPanel newComponent) {
        if (this.rootComponent.getComponentCount() == 0 || this.rootComponent.getComponent(0) != newComponent) {
            this.rootComponent.removeAll();
            this.rootComponent.add(newComponent);
            this.rootComponent.revalidate();
        }
    }

    public void setSelectedAlert(TreeSelection<ResourceContainerGroup, ResourceContainer> selection) {
        if (selection != null) {
            this.initUIWithSingleMachine(selection.getFirstSelectedGroup());
        } else {
            this.initUIWithSingleMachine(null);
        }
    }

    public void setSelectedAlerts(TreeSelection<ResourceContainerGroup, ResourceContainer> selection) {
        if (selection != null) {
            this.initUIForMultipleMachines(selection);
        } else {
            this.initUIWithSingleMachine(null);
        }
    }

    public void groupsRemoved(ResourceContainerGroup parentGroup, ResourceContainerGroup[] removedChildren, int[] removedIndices) {
    }

    public void groupsAdded(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    public void machinesChanged(ResourceContainerGroup parent, ResourceContainer[] inserted, ResourceContainer[] removed, ResourceContainer[] updated, Machine.MachineChanges updateResults) {
        if (this.selection != null) {
            ResourceContainer machine = (ResourceContainer)this.selection.getFirstMachine();
            if (machine == null) {
                return;
            }
            if (updated != null && updated.length > 0) {
                for (ResourceContainer m : updated) {
                    if (!m.equals(machine)) continue;
                    this.initUIWithSingleMachine(this.selection);
                }
            }
        }
    }

    @Override
    public void editableLabelStartEdit() {
        this.alertToEdit = this.alert;
        this.alertGroupToEdit = this.parentGroup;
    }

    @Override
    public void editableLabelValueSet(String newMachineName) {
        if (this.alertToEdit != null) {
            MachineName newName = new MachineName(newMachineName, this.alertToEdit.getName().getGroup());
            this.alertPanelListener.setElementName(this.alertGroupToEdit, this.alertToEdit, newName);
        }
    }

    public void setAncestorFilterProcessor(TreeNodeFilterProcessor selectedFilterProcessor) {
        this.selectedFilterProcessor = selectedFilterProcessor;
    }

    @Override
    public void filterProcessorChanged() {
    }

    public void updateUIWithPermissions(TechGroupPermissions permissions) {
        this.contentMultiple.initUIWithPermissions(permissions);
    }
}

