/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.admin.GroupMembership;
import com.aem.shelp.tech.admin.subsections.technicians.AdminTechnicians;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;

public class GroupTable
extends MouseAdapter {
    private final AdminTechnicians adminTechnicians;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private SHJTable groupsTable;
    private SimpleTableModel groupsModel;
    private SimpleList<GroupMembership> groupList = new SimpleList();
    private SortWrapper<GroupMembership> sortWrapper = new SortWrapper<GroupMembership>(this.groupList, new Comparator<GroupMembership>(){

        @Override
        public int compare(GroupMembership o1, GroupMembership o2) {
            return o1.getGroupName().toLowerCase().compareTo(o2.getGroupName().toLowerCase());
        }
    });
    private boolean forceSelection = false;
    private int groupMemberCount = 0;

    public GroupTable(AdminTechnicians adminTechnicians) {
        this.adminTechnicians = adminTechnicians;
        this.initUI();
    }

    public void forceAtLeastOneGroupSelected() {
        this.forceSelection = true;
    }

    public boolean isForceAtLeastOneGroupSelected() {
        return this.forceSelection;
    }

    public void setEnabled(boolean enabled) {
        this.groupsTable.setEnabled(enabled);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(GroupMembership[] groups) {
        this.groupMemberCount = 0;
        for (GroupMembership membership : groups) {
            if (!membership.isMember()) continue;
            ++this.groupMemberCount;
        }
        this.groupList.startBatch();
        try {
            while (this.groupList.size() > groups.length) {
                this.groupList.remove(this.groupList.size() - 1);
            }
            for (int i = 0; i < groups.length; ++i) {
                if (i < this.groupList.size()) {
                    this.groupList.set(i, groups[i]);
                    continue;
                }
                this.groupList.add(groups[i]);
            }
        }
        finally {
            this.groupList.endBatch();
        }
        this.rootComponent.repaint();
    }

    public void initUI() {
        TableStructure ts = TableStructure.createTableStructure(GroupMembership.class, new String[]{"getGroupName", "", ""}, new String[]{Language.get("ADMIN_GROUP_NAME"), Language.get("GROUP_MEMBER"), Language.get("GROUP_ADMIN")});
        ts.setMinWidths(SimpleHelpLookAndFeel.scale((int[])new int[]{100, 100, 100}));
        ts.setMaxWidths(new int[]{-1, SimpleHelpLookAndFeel.scale((int)100), SimpleHelpLookAndFeel.scale((int)100)});
        ts.setAlignment(new int[]{2, 0, 0});
        this.groupsModel = new SimpleTableModel(this.sortWrapper, ts);
        this.groupsTable = new SHJTable();
        this.groupsTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)30));
        this.groupsTable.addMouseListener(this);
        this.groupsModel.assignToTable(this.groupsTable);
        TableCellRenderer renderer = new GroupTableRenderer();
        this.groupsTable.setDefaultRenderer(Object.class, renderer);
        this.groupsTable.setDefaultRenderer(Boolean.class, renderer);
        renderer = new BorderedTableCellRendererWrapper(this.groupsTable.getDefaultRenderer(Object.class), SHBorderFactory.createEmptyBorder((int)4, (int)5, (int)4, (int)0));
        this.groupsTable.setDefaultRenderer(Object.class, renderer);
        TableCellRenderer headerRenderer = this.groupsTable.getTableHeader().getDefaultRenderer();
        headerRenderer = new BorderedTableCellRendererWrapper(new AlignTableCellRendererWrapper(headerRenderer, new int[]{2, 0, 0}));
        this.groupsTable.getTableHeader().setDefaultRenderer(headerRenderer);
        ts.initTableDimensions(this.groupsTable);
        JScrollPane tableScroller = new JScrollPane(this.groupsTable);
        this.rootComponent.add((Component)tableScroller, "Center");
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        int row = this.groupsTable.rowAtPoint(event.getPoint());
        int col = this.groupsTable.columnAtPoint(event.getPoint());
        GroupMembership member = (GroupMembership)this.sortWrapper.get(row);
        if (col == 1 || col == 2) {
            if (col == 1) {
                boolean newState;
                boolean bl = newState = !member.isMember();
                this.groupMemberCount = newState ? ++this.groupMemberCount : --this.groupMemberCount;
                if (!this.forceSelection || this.groupMemberCount > 0) {
                    member.setIsMember(newState);
                    if (this.forceSelection) {
                        this.rootComponent.repaint();
                    }
                }
            } else {
                member.setIsAdmin(!member.isAdmin());
            }
            this.adminTechnicians.updateTechnicianGroupMembership(member);
            Rectangle cell = this.groupsTable.getCellRect(row, col, false);
            this.groupsTable.repaint(cell);
        }
    }

    class GroupTableRenderer
    extends DefaultTableCellRenderer {
        private JCheckBox checkBox = new JCheckBox();

        GroupTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.checkBox.setEnabled(true);
            if (column == 0) {
                return label;
            }
            if (column == 1) {
                this.checkBox.setSelected(((GroupMembership)value).isMember());
                if (this.checkBox.isSelected() && GroupTable.this.groupMemberCount == 1 && GroupTable.this.forceSelection) {
                    this.checkBox.setEnabled(false);
                }
                this.checkBox.setHorizontalAlignment(0);
                this.checkBox.setBackground(label.getBackground());
            } else if (column == 2) {
                this.checkBox.setSelected(((GroupMembership)value).isAdmin());
                this.checkBox.setBackground(label.getBackground());
            }
            return this.checkBox;
        }
    }
}

