/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.PatternWrapper;
import com.aem.shelp.util.swing.IconedAbstractListUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminTechRestrictions
extends SubSection {
    private TechRestrictionList techRestrictionList;

    @Override
    protected void initUI() {
        this.techRestrictionList = new TechRestrictionList(Language.DEFLANG, new String[0]);
        SwingUtil.setHeight((JComponent)((Object)this.techRestrictionList), (int)SimpleHelpLookAndFeel.scale((int)80));
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_TECHREST_DESC") + "</html>");
        wrapper.add((Component)descriptionLabel, 0, 0, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, 0, 5, 0));
        wrapper.add((Component)((Object)this.techRestrictionList), 0, 1, 1, 1, 1, 100, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_TECHREST_TITLE");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        if (config.techRestrictions != null) {
            String[] restrictions = new String[config.techRestrictions.length];
            for (int i = 0; i < restrictions.length; ++i) {
                restrictions[i] = config.techRestrictions[i].toString();
            }
            this.techRestrictionList.setObjects(restrictions);
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        String[] objects = this.techRestrictionList.getObjects(new String[0]);
        config.techRestrictions = new PatternWrapper[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            config.techRestrictions[i] = new PatternWrapper(objects[i], false);
        }
    }

    class TechRestrictionList
    extends IconedAbstractListUI<String> {
        public TechRestrictionList(ResourceBundle lang, String[] initialList) {
            super(lang, initialList, false, false);
        }

        @Override
        protected Icon getIconForObject(String element) {
            return ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,16");
        }

        @Override
        protected String getNewObject() {
            return SHGlassOptionPane.showInputDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminTechRestrictions.this.rootComponent), (String)("<html>" + this.lang.getString("ADMIN_TECHREST_DESC") + "<br><br>" + this.lang.getString("ADMIN_IP_RESTRICTION_1") + "<br>" + this.lang.getString("ADMIN_IP_RESTRICTION_2") + "</html>"), (String)this.lang.getString("ADMIN_TECHREST_NEW_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/lock-open.svg,48"), (String)this.lang.getString("OK"), (String)"*");
        }

        @Override
        protected void listChanged() {
            AdminTechRestrictions.this.contentChanged(AdminTechRestrictions.this.checkIfValid());
            AdminTechRestrictions.this.saveListener.techRestrictionsChanged();
        }
    }
}

