/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.authentication.TOTPAuthenticator;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.tech.admin.MultiTierConfigPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.authentication.TOTPRegistrationPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.JComponent;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.layout.GbPanelWrapper;

public class AdminAuthentication
extends SubSection {
    public static AdminAuthentication INSTANCE;
    private final AdminPanel adminPanel;
    private MultiTierConfigPanel adminTwoTierConfig;
    private LazyEncryptedPassword simpleHelpAdminTOTPKey = null;
    private boolean force = false;

    public AdminAuthentication(AdminPanel adminPanel) {
        INSTANCE = this;
        this.adminPanel = adminPanel;
    }

    @Override
    public boolean forceSave() {
        if (this.force) {
            this.force = false;
            return true;
        }
        return false;
    }

    @Override
    protected void initUI() {
        GbPanelWrapper tierWrapper = new GbPanelWrapper((Container)this.rootComponent);
        JWrapLabel descriptionLabel = new JWrapLabel("<html>" + Language.get("ADMIN_AUTHENTICATION_DESC_2") + "</html>");
        this.adminTwoTierConfig = new MultiTierConfigPanel(Templates.adminTwoTierActivationSubject, Templates.adminTwoTierActivationContent, true){

            @Override
            public void saveSettings() {
                AdminAuthentication.this.contentChanged(AdminAuthentication.this.checkIfValid());
                AdminAuthentication.this.force = true;
                AdminAuthentication.this.saveListener.requestImmediateSave();
            }

            @Override
            public void switchToEmailServerConfig() {
                AdminAuthentication.this.adminPanel.switchToEmailSection();
            }

            @Override
            public boolean isAdmin() {
                return true;
            }

            @Override
            public void launchAppBasedConfiguration() {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            TOTPAuthenticator.TOTPRequest request = AdminAuthentication.this.techClient.requestNewTOTPKey();
                            PanelGlassDialog totpAuthenticationPanelHandle = new PanelGlassDialog(SwingUtil.getRootPaneContainer((Component)AdminAuthentication.this.rootComponent), Language.get("GROUP_APP"), 650, null, null);
                            TOTPRegistrationPanel panel = new TOTPRegistrationPanel(request.key, request.digits, request.username, request.hostname, request.issuer);
                            totpAuthenticationPanelHandle.setContentPanel((JComponent)panel.getRootComponent());
                            totpAuthenticationPanelHandle.showDialog(false);
                            boolean success = false;
                            while (!success) {
                                String codeString = panel.getEnteredCode();
                                if (codeString == null) {
                                    totpAuthenticationPanelHandle.okPressed();
                                    return;
                                }
                                long code = Long.parseLong(codeString);
                                success = AdminAuthentication.this.techClient.validateTOTPCode(code, request.key);
                                if (success) {
                                    if (AdminAuthentication.this.simpleHelpAdminTOTPKey == null) {
                                        AdminAuthentication.this.simpleHelpAdminTOTPKey = new LazyEncryptedPassword(request.key);
                                    } else {
                                        AdminAuthentication.this.simpleHelpAdminTOTPKey.setDecryptedPassword(request.key);
                                    }
                                    this.saveSettings();
                                    panel.setOK();
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                panel.setError();
                            }
                            totpAuthenticationPanelHandle.okPressed();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }.start();
            }
        };
        this.adminTwoTierConfig.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        int Y = 0;
        tierWrapper.add((Component)descriptionLabel, 0, Y++, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 5, 0));
        tierWrapper.add((Component)this.adminTwoTierConfig.getRootComponent(), 0, Y++, 1, 1, 1, 1, 10, 2);
    }

    public void setBackground(Color c) {
        this.adminTwoTierConfig.setBackground(c);
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        this.adminTwoTierConfig.setTechClient(techClient);
    }

    public void reloadTwoTierEmailDefaults() {
        this.adminTwoTierConfig.setEmailAuthenticationEmailDefaults(Templates.adminTwoTierActivationSubject, Templates.adminTwoTierActivationContent);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_AUTHENTICATION_2");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.adminTwoTierConfig.setUseAppAuthentication(config.serverAdminGroup.isMultiTierApp());
        this.adminTwoTierConfig.setUseEmailAuthentication(config.serverAdminGroup.isMultiTierEmail());
        if (config.serverAdminGroup.isMultiTierEmail()) {
            this.adminTwoTierConfig.setTwoTierSettings(config.serverAdminGroup.getTwoTierCodeLength(), config.serverAdminGroup.getTwoTierSubject(), config.serverAdminGroup.getTwoTierBody(), config.serverAdmin.getEmail());
        }
        this.adminTwoTierConfig.setRememberMachine(config.serverAdminGroup.getMultiTierRememberMachine());
        this.adminTwoTierConfig.setEmailServerConfigured(config.emailSettingsEnabled);
        this.simpleHelpAdminTOTPKey = config.serverAdmin.getTOTPKey();
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.serverAdminGroup.setMultiTierApp(this.adminTwoTierConfig.getUseAppAuthentication());
        config.serverAdminGroup.setMultiTierEmail(this.adminTwoTierConfig.getUseEmailAuthentication());
        config.serverAdminGroup.setTwoTierCodeLength(this.adminTwoTierConfig.getEmailCodeLength());
        config.serverAdminGroup.setTwoTierEmail(this.adminTwoTierConfig.getEmailSubject(), this.adminTwoTierConfig.getEmailBody());
        config.serverAdmin.setEmail(this.adminTwoTierConfig.getEmailAddress());
        config.serverAdminGroup.setMultiTierRememberMachine(this.adminTwoTierConfig.rememberBox.isSelected());
        config.serverAdmin.setTOTPKey(this.simpleHelpAdminTOTPKey);
    }

    @Override
    public void saveComplete(ServerConfig config) {
        this.adminTwoTierConfig.setEmailServerConfigured(config.emailSettingsEnabled);
    }

    @Override
    public void checkEnabled() {
    }
}

