/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.simulation;

import com.aem.StyleUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.admin.subsections.simulation.AdminSimulation;
import com.aem.shelp.tech.admin.subsections.simulation.Simulation;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.steps.SessionsStep;
import com.aem.shelp.tech.admin.subsections.simulation.steps.WaitStep;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import utils.progtools.arrays.CircularFixedList;
import utils.string.SimpleRegex;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.VariableLinePanel;

public class SimulationRun
extends Thread {
    AdminSimulation adminSimulation;
    Simulation sim;
    JLabel title;
    BorderPanel main;
    VariableLinePanel line;
    VariableLinePanel buttons;
    ArrayList<SimulationStep> steps;
    boolean aborted = false;
    HashMap<String, CircularFixedList<Machine>> machineGroups = new HashMap();

    public SimulationRun(AdminSimulation adminSimulation, Simulation sim) {
        this.adminSimulation = adminSimulation;
        this.sim = sim;
        DefaultListModel<SimulationStep> list = sim.getList();
        this.steps = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            this.steps.add(list.get(i));
        }
        this.title = new JLabel();
        this.line = new VariableLinePanel(0, false, true);
        StyleUtil.applyPanelSpacingBorder((JComponent)this.line);
        this.buttons = new VariableLinePanel(1, true, false);
        StyleUtil.makeButtonPanel(this.buttons);
        JButton abort = new JButton(Language.get("CANCEL"));
        this.buttons.add((Component)abort);
        abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isOK = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)SimulationRun.this.main), (String)Language.get("SIM_ABORT_MSG"), (String)Language.get("SIM_ABORT_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,48"), (String)Language.get("OK"), (String)Language.get("CANCEL"));
                if (!isOK) {
                    return;
                }
                SimulationRun.this.abort(Language.get("CANCELLED_BY_USER"));
            }
        });
        this.main = new BorderPanel();
        this.main.addNorth(StyleUtil.makeTitlePanel("images/svg/computing/design-color_code-editor.svg", Language.get("SIM_RUNNING_TITLE", sim.getName()), this.title));
        this.main.addCenter((JComponent)new JScrollPane((Component)this.line, 20, 31));
        this.main.addSouth((JComponent)this.buttons);
        this.start();
    }

    private void abort(String abortReason) {
        System.out.println("[Simulation] Simulation aborted: " + abortReason);
        this.adminSimulation.finishedRunning(this.sim);
        this.aborted = true;
    }

    private TechUi getTechUI() {
        return TechUi.INSTANCE;
    }

    public JComponent getPanel() {
        return this.main;
    }

    public CircularFixedList<Machine> getMachinesFor(String match) {
        CircularFixedList<Machine> list = this.machineGroups.get(match);
        if (list == null) {
            Pattern pattern = SimpleRegex.simpleToPattern(match, false);
            list = new CircularFixedList<Machine>(this.getTechUI().simulationGetMachinesMatching(pattern));
            list.shuffle();
            this.machineGroups.put(match, list);
        }
        if (list.size() == 0) {
            this.abort(Language.get("MATCHED_NO_MACHNES"));
        }
        return list;
    }

    @Override
    public void run() {
        int i;
        ArrayList<StepLabel> labels = new ArrayList<StepLabel>();
        for (i = 0; i < this.steps.size(); ++i) {
            StepLabel label = new StepLabel(this.steps.get(i));
            labels.add(label);
            this.line.add((Component)((Object)label));
        }
        for (i = 0; i < this.steps.size(); ++i) {
            SimulationStep step = this.steps.get(i);
            StepLabel label = (StepLabel)((Object)labels.get(i));
            if (this.aborted) break;
            label.setActive();
            if (step instanceof WaitStep) {
                WaitStep waitStep = (WaitStep)step;
                try {
                    System.out.println("[Simulation] Waiting for " + waitStep.getWaitTimeMillis());
                    Thread.sleep(waitStep.getWaitTimeMillis());
                }
                catch (Exception exception) {}
            } else if (step instanceof SessionsStep) {
                SessionsStep sessionsStep = (SessionsStep)step;
                String match = sessionsStep.getMatch();
                int count = sessionsStep.getCount();
                double millis = sessionsStep.getMins() * 60000.0;
                long sleep = (long)(millis / (double)count);
                CircularFixedList<Machine> machines = this.getMachinesFor(match);
                for (int m = 0; m < count; ++m) {
                    Machine machine = machines.nextItem();
                    System.out.println("[Simulation] Launching session " + (m + 1) + "/" + count + " to " + machine);
                    this.getTechUI().simulationLaunchOneSession(machine, sessionsStep.toMessage());
                    if (sleep <= 0L) continue;
                    try {
                        System.out.println("[Simulation] Sleeping for " + sleep + "ms");
                        Thread.sleep(sleep);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                Thread.sleep(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            label.setFinished();
        }
        this.title.setIcon(ImageLoader.getImageIcon((String)("images/svg/computing/design-color_code-editor.svg," + StyleUtil.getTitleIconSize())));
        this.title.setText(Language.get("SIM_FINISHED"));
        this.buttons.removeAll();
        JButton finish = new JButton(Language.get("FINISH"));
        this.buttons.add((Component)finish);
        finish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationRun.this.adminSimulation.finishedRunning(SimulationRun.this.sim);
            }
        });
    }

    class StepLabel
    extends BorderPanel {
        SimulationStep step;
        JLabel label;
        BorderPanel east;
        CircularProgressIcon circ;

        public StepLabel(SimulationStep step) {
            this.step = step;
            this.label = new JLabel();
            this.label.setIcon(ImageLoader.getImageIconDisabled((String)(step.getTypeIconKeyNoSize() + "," + StyleUtil.getLargeListIconSize())));
            this.label.setText(step.getSummary());
            this.east = new BorderPanel();
            this.addWest(this.label);
            this.addEast((JComponent)this.east);
        }

        public BorderPanel getEastPanel() {
            return this.east;
        }

        public void setActive() {
            this.circ = SHProgressIcons.getCircularInfinite(StyleUtil.getLargeListIconSize());
            this.circ.setUpdateComponent((Component)this.label);
            this.label.setIcon((Icon)this.circ);
        }

        public void setFinished() {
            if (this.circ != null) {
                this.circ.switchOff();
            }
            this.label.setIcon(ImageLoader.getImageIcon((String)(this.step.getTypeIconKeyNoSize() + "," + StyleUtil.getLargeListIconSize())));
        }

        public void setText(String text) {
            this.label.setText(text);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = SHStyle.ROW_HEIGHT;
            return d;
        }
    }
}

