/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.KeystoreDescriptionPanel;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.serversettings.SSLUtil;
import com.aem.shelp.util.KeytoolUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.ssl.KeyStoreUtility;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminSSL
extends SubSection
implements ActionListener {
    private JButton selfGenerate;
    private JTextField domain;
    private JTextField organisation;
    private JButton browse;
    private JTextField keystore;
    private JPasswordField storepass;
    private JPasswordField keypass;
    private JButton uploadKeystore;
    private JButton checkKeystore;
    private JButton keystoreView;
    private String recentKeystorePath;
    private String recentKeystoreStorePassword;
    private String recentKeystoreKeyPassword;
    private RoundBorderPanel uploadPanel;
    private JRadioButton selfSignedOption;
    private JRadioButton uploadOption;
    private GbPanel generateGbPanel;
    private GbPanel generateUploadPanel;

    @Override
    protected void initUI() {
        this.initSslPanel(this.rootComponent);
    }

    private void initSslPanel(JPanel sslPanel) {
        sslPanel.setLayout(new BorderLayout());
        GbPanel main = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        sslPanel.add("Center", (Component)main);
        JLabel domainl = new JLabel(Language.get("CERT_DOMAIN"), 4);
        JLabel orgl = new JLabel(Language.get("CERT_ORGANISATION"), 4);
        this.domain = new JTextField(25);
        this.organisation = new JTextField(25);
        this.selfGenerate = new JButton(Language.get("GEN_SELF_SIGNED"));
        KeyListener nonEmptyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (AdminSSL.this.domain.getText().trim().length() == 0 || AdminSSL.this.organisation.getText().trim().length() == 0) {
                    AdminSSL.this.selfGenerate.setEnabled(false);
                } else {
                    AdminSSL.this.selfGenerate.setEnabled(true);
                }
            }
        };
        this.domain.addKeyListener(nonEmptyListener);
        this.organisation.addKeyListener(nonEmptyListener);
        this.domain.setText("www.example.com");
        this.organisation.setText(Language.get("YOUR_ORG"));
        this.selfSignedOption = new JRadioButton(Language.get("CERT_SELF_SIGN_TITLE"));
        this.uploadOption = new JRadioButton(Language.get("CERT_UPLOAD_TITLE"));
        this.keystoreView = new JButton(Language.get("KEYSTORE_VIEW"));
        this.keystoreView.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.selfSignedOption);
        bg.add(this.uploadOption);
        int Y = 0;
        main.add((Component)new JWrapLabel("<html><b>" + Language.get("IMPORTANT_PREFIX") + "</b> " + Language.get("ADMIN_SSL_WARNING_2") + "</html>"), 0, Y++, 3, 1, 100, 1, 17, 2);
        main.add((Component)this.keystoreView, 2, Y, 1, 2, 0, 1, 17, 0);
        main.add((Component)this.selfSignedOption, 0, Y++, 2, 1, 100, 1, 17, 2);
        main.add((Component)this.uploadOption, 0, Y++, 2, 1, 100, 1, 17, 2);
        this.selfSignedOption.setSelected(true);
        this.selfSignedOption.addActionListener(this);
        this.uploadOption.addActionListener(this);
        int YY = 0;
        this.generateGbPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        this.generateGbPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.generateGbPanel.add((Component)new JWrapLabel("<html>" + Language.get("CERT_SELF_SIGN_WARNING") + "</html>"), 0, YY++, 2, 1, 100, 1, 17, 2);
        this.generateGbPanel.add((Component)new JLabel(" "), 0, YY++, 2, 1, 100, 1, 17, 2);
        this.generateGbPanel.add((Component)domainl, 0, YY, 1, 1, 25, 1, 13, 0);
        this.generateGbPanel.add((Component)this.domain, 1, YY++, 1, 1, 75, 1, 17, 0);
        this.generateGbPanel.add((Component)orgl, 0, YY, 1, 1, 25, 1, 13, 0);
        this.generateGbPanel.add((Component)this.organisation, 1, YY++, 1, 1, 75, 1, 17, 0);
        this.generateGbPanel.add((Component)this.selfGenerate, 1, YY++, 1, 1, 75, 1, 17, 0);
        JLabel keystorel = new JLabel(Language.get("CERT_KEYSTORE"), 4);
        JLabel storepassl = new JLabel(Language.get("CERT_STOREPASS"), 4);
        JLabel keypassl = new JLabel(Language.get("CERT_KEYPASS"), 4);
        this.browse = new JButton(Language.get("BROWSE"));
        this.keystore = new JTextField(25);
        this.storepass = new JFixedWidthPasswordField(25);
        this.keypass = new JFixedWidthPasswordField(25);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.browse);
        this.uploadKeystore = new JButton(Language.get("UPLOAD_KEYSTORE"));
        this.checkKeystore = new JButton(Language.get("CHECK_KEYSTORE"));
        int YY2 = 0;
        this.generateUploadPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        this.generateUploadPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.generateUploadPanel.add((Component)new JWrapLabel("<html>" + Language.get("CERT_UPLOAD_WARNING") + "</html>"), 0, YY2++, 2, 1, 100, 1, 17, 2);
        this.generateUploadPanel.add((Component)new JLabel(" "), 0, YY2++, 2, 1, 100, 1, 17, 2);
        this.generateUploadPanel.add((Component)keystorel, 0, YY2, 1, 1, 25, 1, 13, 0);
        JPanel tmp = new JPanel();
        tmp.setLayout(new BorderLayout());
        tmp.add("Center", this.keystore);
        tmp.add("East", this.browse);
        this.generateUploadPanel.add((Component)tmp, 1, YY2++, 1, 1, 75, 1, 17, 0);
        this.generateUploadPanel.add((Component)storepassl, 0, YY2, 1, 1, 25, 1, 13, 0);
        this.generateUploadPanel.add((Component)this.storepass, 1, YY2++, 1, 1, 75, 1, 17, 0);
        this.generateUploadPanel.add((Component)keypassl, 0, YY2, 1, 1, 25, 1, 13, 0);
        this.generateUploadPanel.add((Component)this.keypass, 1, YY2++, 1, 1, 75, 1, 17, 0);
        GbPanel buttonPanel = new GbPanel(new ScaledInsets(5, 0, 5, 5));
        buttonPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        buttonPanel.add((Component)this.checkKeystore, 0, 0, 1, 1, 1, 0, 17, 0);
        buttonPanel.add((Component)this.uploadKeystore, 1, 0, 1, 1, 0, 0, 17, 0);
        this.generateUploadPanel.add((Component)buttonPanel, 1, YY2, 1, 1, 0, 1, 17, 0);
        this.uploadPanel = new RoundBorderPanel();
        this.uploadPanel.setLayout(new GridLayout(1, 1));
        this.uploadPanel.add((Component)this.generateGbPanel);
        main.add((Component)this.uploadPanel, 0, Y++, 3, 1, 100, 1, 17, 2);
        this.selfGenerate.addActionListener(this);
        this.browse.addActionListener(this);
        this.uploadKeystore.addActionListener(this);
        this.checkKeystore.addActionListener(this);
        this.uploadKeystore.setEnabled(false);
        this.checkKeystore.setEnabled(false);
        KeyListener nonEmptyUploadListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (AdminSSL.this.storepass.getPassword().length == 0 || AdminSSL.this.keypass.getPassword().length == 0 || AdminSSL.this.keystore.getText().trim().length() == 0) {
                    AdminSSL.this.uploadKeystore.setEnabled(false);
                    AdminSSL.this.checkKeystore.setEnabled(false);
                } else {
                    AdminSSL.this.uploadKeystore.setEnabled(true);
                    AdminSSL.this.checkKeystore.setEnabled(true);
                }
            }
        };
        this.storepass.addKeyListener(nonEmptyUploadListener);
        this.keypass.addKeyListener(nonEmptyUploadListener);
        this.keystore.addKeyListener(nonEmptyUploadListener);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SSL");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
        if (this.recentKeystorePath != null) {
            config.keystoreStorePassword = new LazyEncryptedPassword(this.recentKeystoreStorePassword);
            config.keystoreKeyPassword = new LazyEncryptedPassword(this.recentKeystoreKeyPassword);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.keystoreView)) {
            this.keystoreView.setEnabled(false);
            new KeystoreViewThread().start();
        }
        if (e.getSource().equals(this.browse)) {
            File selectedFile = SafeJFileChooser.pickFile((Component)this.rootComponent);
            if (selectedFile != null) {
                this.keystore.setText(selectedFile.getAbsolutePath());
                this.keystore.repaint();
            }
        } else if (e.getSource().equals(this.selfGenerate)) {
            try {
                this.selfGenerate.setEnabled(false);
                this.selfGenerate.repaint();
                this.requestSelfSignedCertificate(this.domain.getText(), SSLUtil.sanitiseForSsl(this.organisation.getText()));
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
        } else if (e.getSource().equals(this.checkKeystore)) {
            File storefile = new File(this.keystore.getText());
            String store = this.storepass.getText();
            String key = this.keypass.getText();
            KeystoreDescriptionPanel.showDescriptionPanel(SwingUtil.getRootPaneContainer((Component)this.rootComponent), storefile, store, key);
        } else if (e.getSource().equals(this.uploadKeystore)) {
            try {
                File storefile = new File(this.keystore.getText());
                String store = this.storepass.getText();
                String key = this.keypass.getText();
                this.uploadKeystore.setEnabled(false);
                this.uploadKeystore.repaint();
                this.uploadKeystore(storefile, store, key);
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
        } else if (e.getSource().equals(this.uploadOption)) {
            this.switchToUploadOption();
        } else if (e.getSource().equals(this.selfSignedOption)) {
            this.switchToSelfSignedOption();
        }
    }

    private void switchToSelfSignedOption() {
        this.uploadPanel.removeAll();
        this.uploadPanel.add((Component)this.generateGbPanel);
        this.uploadPanel.revalidate();
        this.uploadPanel.repaint();
    }

    private void switchToUploadOption() {
        this.uploadPanel.removeAll();
        this.uploadPanel.add((Component)this.generateUploadPanel);
        this.uploadPanel.revalidate();
        this.uploadPanel.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uploadKeystore(File file, String storepass, String keypass) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                KeytoolUtil.KeyStoreResult result = this.techClient.uploadKeystoreWithCertificate(file, storepass, keypass);
                if (result.success == 0) {
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("UPLOAD_CERT_SUCCESS_MSG"), (String)Language.get("UPLOAD_CERT_SUCCESS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
                    this.recentKeystorePath = result.keystorePath;
                    this.recentKeystoreStorePassword = storepass;
                    this.recentKeystoreKeyPassword = keypass;
                    this.contentChanged(this.checkIfValid());
                    return;
                }
                if (result.success == 2) {
                    SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("UPLOAD_CERT_FAILURE_MSG_KEY"), (String)Language.get("UPLOAD_CERT_FAILURE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                    return;
                }
                if (result.success != 1) return;
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("UPLOAD_CERT_FAILURE_MSG_STORE"), (String)Language.get("UPLOAD_CERT_FAILURE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("UPLOAD_CERT_FAILURE_MSG"), (String)Language.get("UPLOAD_CERT_FAILURE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                return;
            }
            finally {
                this.uploadKeystore.setEnabled(true);
            }
        } else {
            new Thread(new UploadKeystore(file, storepass, keypass)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSelfSignedCertificate(String domain, String organisation) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                KeytoolUtil.KeyStoreResult result = this.techClient.requestSelfSignedCertificate(domain, organisation);
                if (result.success == 0) {
                    this.recentKeystorePath = result.keystorePath;
                    this.recentKeystoreStorePassword = "changeit";
                    this.recentKeystoreKeyPassword = "changeit";
                    this.contentChanged(this.checkIfValid());
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("GEN_CERT_SUCCESS_MSG"), (String)Language.get("GEN_CERT_SUCCESS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("GEN_CERT_FAILURE_MSG"), (String)Language.get("GEN_CERT_FAILURE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Exception x) {
                x.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)Language.get("GEN_CERT_FAILURE_MSG"), (String)Language.get("GEN_CERT_FAILURE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
            finally {
                this.selfGenerate.setEnabled(true);
            }
        } else {
            new Thread(new RequestSelfSignedCertificate(domain, organisation)).start();
        }
    }

    public void setKeystoreAndSave(String keystorePath, String storePassword, String keyPassword) {
        this.recentKeystorePath = keystorePath;
        this.recentKeystoreStorePassword = storePassword;
        this.recentKeystoreKeyPassword = keyPassword;
        this.contentChanged(this.checkIfValid());
    }

    class RequestSelfSignedCertificate
    implements Runnable {
        private String domain;
        private String organisation;

        public RequestSelfSignedCertificate(String domain, String organisation) {
            this.domain = domain;
            this.organisation = organisation;
        }

        @Override
        public void run() {
            AdminSSL.this.requestSelfSignedCertificate(this.domain, this.organisation);
        }
    }

    class UploadKeystore
    implements Runnable {
        File file;
        String storepass;
        String keypass;

        public UploadKeystore(File file, String storepass, String keypass) {
            this.file = file;
            this.storepass = storepass;
            this.keypass = keypass;
        }

        @Override
        public void run() {
            AdminSSL.this.uploadKeystore(this.file, this.storepass, this.keypass);
        }
    }

    class KeystoreViewThread
    extends Thread {
        KeystoreViewThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AdminSSL.this.saveListener.requestImmediateSave();
            try {
                KeyStoreUtility.KeystoreValidationResult result = AdminSSL.this.techClient.fetchKeystoreDetails();
                KeystoreDescriptionPanel.showValidationResult(SwingUtil.getRootPaneContainer((Component)AdminSSL.this.rootComponent), result);
            }
            catch (Exception e) {
                String error = "<html>" + Language.get("UNABLE_TO_LOAD_KEYSTORE") + ".";
                String explanation = e.getMessage();
                if (explanation != null) {
                    error = error + "<BR><BR>" + explanation;
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminSSL.this.rootComponent), (String)error, (String)Language.get("UNABLE_TO_LOAD_KEYSTORE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
            finally {
                AdminSSL.this.keystoreView.setEnabled(true);
            }
        }
    }
}

