/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.gettingstarted;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.ErrorDialogs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.progtools.DataUtil;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthLabel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.images.ColorUtils;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminMemory
extends SubSection
implements ActionListener {
    private boolean restartRequired = false;
    private ProgressRef[] memProgress;
    private JLabel memLoadLabel;
    private JLabel currentMemoryUsedLabel;
    private JLabel currentMaxMemoryLabel;
    private JButton setServerMemoryButton;
    private final Object LOCK = new Object();
    private QueryThread queryThread;
    private TechClient.MemoryUsage usage = null;

    @Override
    protected void initUI() {
        ColorProvider blueProvider = new ColorProvider(){

            public Color nextColor(double d) {
                if (d < 0.8) {
                    return AccessStyle.MINISTAT_BLUE;
                }
                if (d < 0.9) {
                    return AccessStyle.MINISTAT_ORANGE;
                }
                return AccessStyle.MINISTAT_RED;
            }

            public Color nextBackgroundColor(double value) {
                return SHStyle.PANEL_BACKGROUND_DARKER;
            }
        };
        int progressIconSize = SimpleHelpLookAndFeel.scale((int)72);
        int arcSize = SimpleHelpLookAndFeel.scale((int)18);
        this.memProgress = new ProgressRef[]{new ProgressRef(), new ProgressRef(), new ProgressRef()};
        CircularProgressIcon memLoadAverage = new CircularProgressIcon(progressIconSize, progressIconSize, blueProvider);
        memLoadAverage.setRemoveWhenDone(false);
        memLoadAverage.setArcDimensions(arcSize, SimpleHelpLookAndFeel.scale((int)2));
        memLoadAverage.setBaseColorOnValue(true);
        this.memLoadLabel = new JLabel((Icon)memLoadAverage);
        memLoadAverage.setUpdateComponent((Component)this.memLoadLabel);
        Dimension size = new Dimension(memLoadAverage.getIconWidth(), memLoadAverage.getIconHeight());
        this.memLoadLabel.setMinimumSize(size);
        this.memLoadLabel.setPreferredSize(size);
        for (ProgressRef ref : this.memProgress) {
            memLoadAverage.addProgressRef(ref);
        }
        GbPanel contentPanel = new GbPanel();
        contentPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
        this.rootComponent.setLayout(new BorderLayout());
        this.rootComponent.add((Component)this.memLoadLabel, "West");
        this.rootComponent.add((Component)contentPanel, "Center");
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("MEMORY_DESC") + ". " + Language.get("MEMORY_DESC2") + ".");
        contentPanel.add((Component)desc, 0, 0, 1, 1, 1, 1, 10, 2);
        this.currentMemoryUsedLabel = new JLabel();
        this.currentMaxMemoryLabel = new JLabel();
        this.setServerMemoryButton = new JButton(Language.get("SET_MEMORY_LIMIT"));
        this.currentMemoryUsedLabel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
        this.currentMaxMemoryLabel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)0, (int)0));
        contentPanel.add((Component)this.currentMemoryUsedLabel, 0, 1, 1, 1, 1, 1, 17, 2);
        contentPanel.add((Component)this.currentMaxMemoryLabel, 0, 2, 1, 1, 1, 1, 17, 2);
        contentPanel.add((Component)this.setServerMemoryButton, 0, 3, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(10, 0, 0, 5));
        this.setServerMemoryButton.addActionListener(this);
    }

    public void setLatestData(TechClient.MemoryUsage usage) {
        this.memProgress[0].setProgress(usage.loadAverage1 / 100.0);
        this.memProgress[1].setProgress(usage.loadAverage5 / 100.0);
        this.memProgress[2].setProgress(usage.loadAverage15 / 100.0);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("1m: ").append((int)usage.loadAverage1).append("%");
        tooltip.append("  5m: ").append((int)usage.loadAverage5).append("%");
        tooltip.append("  15m: ").append((int)usage.loadAverage15).append("%");
        this.memLoadLabel.setToolTipText(tooltip.toString());
        this.memLoadLabel.repaint();
        this.currentMemoryUsedLabel.setText(Language.get("MEMORY_LIMIT_USED", DataUtil.getSensiblePercentage((double)(usage.currentPercentage / 100.0))) + " (" + tooltip + ").");
        String text = "<html>" + Language.get("MEMORY_LIMIT_CONFIGURED", DataUtil.getSensibleSize((long)usage.maxAllocatable));
        if (this.restartRequired) {
            text = text + " (<font color='" + ColorUtils.colorToHexRGBString((Color)SHStyle.WARNING_TEXT_COLOR) + "'>" + Language.get("MEMORY_SERVER_RESTART") + "</font>)";
        }
        text = text + ".";
        this.currentMaxMemoryLabel.setText(text);
        this.rootComponent.repaint();
    }

    @Override
    public String getTitle() {
        return Language.get("SERVER_STATUS_TEST_4");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchedTo() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.queryThread == null || this.queryThread.die) {
                this.queryThread = new QueryThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchedAway() {
        Object object = this.LOCK;
        synchronized (object) {
            this.queryThread.die = true;
            this.queryThread = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long maxAllowed = this.usage.totalServerMemory;
        maxAllowed = (long)(0.8 * (double)maxAllowed);
        if (!this.usage.jre64bit) {
            maxAllowed = Math.min(0x80000000L, maxAllowed);
        }
        this.showSetServerMemoryDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), (int)(maxAllowed / 0x100000L), (int)(this.usage.maxAllocatable / 0x100000L));
    }

    private void showSetServerMemoryDialog(final RootPaneContainer rpc, int maxMegaBytes, int currentMegaBytes) {
        int min = 384;
        int max = maxMegaBytes;
        final JLabel currentValue = new JLabel(currentMegaBytes + " MB");
        final JSlider slider = new JSlider(min, max);
        final Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                currentValue.setText(slider.getValue() + " MB");
                slider.setLabelTable(labels);
                slider.revalidate();
                slider.repaint();
            }
        });
        slider.setValue(Math.min(currentMegaBytes, maxMegaBytes));
        JLabel jLabel = new JLabel(min + " MB");
        jLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        labels.put(min, jLabel);
        jLabel = new JLabel(max + " MB");
        jLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        labels.put(max, jLabel);
        labels.put(min + (max - min) / 2, currentValue);
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        slider.setMajorTickSpacing((maxMegaBytes - 384) / 2);
        FixedWidthPanel panel = new FixedWidthPanel((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        panel.add((Component)new FixedWidthLabel("<html>" + Language.get("SET_MEMORY_LIMIT_DESC")), (Object)"North");
        panel.add((Component)slider, (Object)"Center");
        panel.add((Component)new FixedWidthLabel("<html>" + Language.get("SET_MEMORY_LIMIT_NOTE")), (Object)"South");
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(Language.get("SET_MEMORY"), Language.get("CANCEL"));
        dialogPanel.setContent((FixedWidthComponent)panel);
        dialogPanel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/spanner-dark.svg,48"));
        AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, 450, (AbstractDialogPanel)dialogPanel);
        dialog.setTitle(Language.get("SET_MEMORY_LIMIT"));
        dialog.setShowDecoration(true);
        dialog.showDialog();
        if (dialogPanel.isOK()) {
            this.setServerMemoryButton.setEnabled(false);
            this.setServerMemoryButton.repaint();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long bytesValue = (long)slider.getValue() * 0x100000L;
                        try {
                            AdminMemory.this.techClient.setServerMemoryLimit(bytesValue);
                            AdminMemory.this.restartRequired = true;
                            AdminMemory.this.setLatestData(AdminMemory.this.usage);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ErrorDialogs.ErrorGlassDialog egd = new ErrorDialogs.ErrorGlassDialog(rpc, Language.get("ERROR_MEMORY_TITLE"));
                            egd.setText(Language.get("ERROR_MEMORY_TITLE"), Language.get("ERROR_MEMORY_DESC"), e.getMessage());
                            egd.showDialog();
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AdminMemory.this.setServerMemoryButton.setEnabled(true);
                                AdminMemory.this.setServerMemoryButton.repaint();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }.start();
        }
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        new AdminMemory().showSetServerMemoryDialog((RootPaneContainer)frame, 1024, 512);
    }

    class QueryThread
    extends Thread {
        private boolean die;

        public QueryThread() {
            super("MemoryUsageQuery");
            this.die = false;
            this.start();
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    AdminMemory.this.usage = AdminMemory.this.techClient.getServerMemoryUsage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (AdminMemory.this.usage != null) {
                    AdminMemory.this.setLatestData(AdminMemory.this.usage);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

