/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.util.PatternWrapper;
import com.aem.shelp.util.swing.IconedAbstractListUI;
import com.jw.SHJWUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class AdminStatus
extends SubSection
implements ValidationKeyListener.ValidationInterface {
    private JCheckBox enableStatusPage;
    private JCheckBox includeMachinesInStatusPageBox;
    private JCheckBox includeSessionsInStatusPageBox;
    private StatusPageList statusPageList;
    private Object currentServerExampleUrl;
    private int currentServerPort;
    private String currentServerHost;
    private JWrapLabel ports2;
    private JWrapLabel ports1;
    private RoundBorderPanel detailsPanel;

    @Override
    protected void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_NOTIFY_STATUS_DESC") + "</html>");
        this.ports1 = new JWrapLabel();
        this.ports2 = new JWrapLabel();
        this.enableStatusPage = new JCheckBox(Language.get("ADMIN_NOTIFY_STATUS_ENABLE"));
        this.statusPageList = new StatusPageList(Language.DEFLANG, new String[0]);
        this.includeMachinesInStatusPageBox = new JCheckBox(Language.get("ADMIN_NOTIFY_STATUS_INCLUDE_MACHINES"));
        this.includeSessionsInStatusPageBox = new JCheckBox(Language.get("ADMIN_NOTIFY_STATUS_INCLUDE_SESSIONS"));
        JWrapLabel techrestrictionDesc = new JWrapLabel("<html>" + Language.get("ADMIN_NOTIFY_STATUS_REST_DESC") + "</html>");
        JPanel panel = new JPanel();
        JPanel connectToPanel = new JPanel();
        connectToPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        connectToPanel.setLayout(new GridLayout(2, 1, SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        connectToPanel.add((Component)this.ports1);
        connectToPanel.add((Component)this.ports2);
        this.detailsPanel = new RoundBorderPanel();
        GridBagLayout gbl3 = new GridBagLayout();
        this.detailsPanel.setLayout(gbl3);
        int Y = 0;
        gbl3.setConstraints((Component)techrestrictionDesc, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(2, 0, 0, 0), 0, 0));
        gbl3.setConstraints((Component)((Object)this.statusPageList), new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        gbl3.setConstraints(this.includeMachinesInStatusPageBox, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        gbl3.setConstraints(this.includeSessionsInStatusPageBox, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        gbl3.setConstraints(connectToPanel, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0), 0, 0));
        this.detailsPanel.add((Component)techrestrictionDesc);
        this.detailsPanel.add((Component)((Object)this.statusPageList));
        this.detailsPanel.add(this.includeMachinesInStatusPageBox);
        this.detailsPanel.add(this.includeSessionsInStatusPageBox);
        this.detailsPanel.add(connectToPanel);
        GridBagLayout gbl = new GridBagLayout();
        this.rootComponent.setLayout(gbl);
        int Y2 = 0;
        gbl.setConstraints((Component)desc, new GridBagConstraints(0, Y2++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 10, 0), 0, 0));
        gbl.setConstraints(this.enableStatusPage, new GridBagConstraints(0, Y2++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(this.detailsPanel, new GridBagConstraints(0, Y2++, 1, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        gbl.setConstraints(panel, new GridBagConstraints(0, Y2++, 1, 1, 1.0, 1000.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        this.rootComponent.add((Component)desc);
        this.rootComponent.add(this.enableStatusPage);
        this.rootComponent.add(this.detailsPanel);
        this.rootComponent.add(panel);
        this.enableStatusPage.addActionListener(this.validateListener);
        this.includeMachinesInStatusPageBox.addActionListener(this.validateListener);
        this.includeSessionsInStatusPageBox.addActionListener(this.validateListener);
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_STATUSPAGE_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.enableStatusPage.setSelected(config.statusPage);
        this.includeMachinesInStatusPageBox.setSelected(config.statusPageIncludeMachines);
        this.includeSessionsInStatusPageBox.setSelected(config.statusPageIncludeSessions);
        if (config.statusPageRestrictions != null) {
            String[] restrictions = new String[config.statusPageRestrictions.length];
            for (int i = 0; i < restrictions.length; ++i) {
                restrictions[i] = config.statusPageRestrictions[i].toString();
            }
            this.statusPageList.setObjects(restrictions);
        }
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.statusPage = this.enableStatusPage.isSelected();
        config.statusPageIncludeMachines = this.includeMachinesInStatusPageBox.isSelected();
        config.statusPageIncludeSessions = this.includeSessionsInStatusPageBox.isSelected();
        String[] objects = this.statusPageList.getObjects(new String[0]);
        config.statusPageRestrictions = new PatternWrapper[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            config.statusPageRestrictions[i] = new PatternWrapper(objects[i], false);
        }
    }

    @Override
    public void checkEnabled() {
        this.detailsPanel.setVisible(this.enableStatusPage.isSelected());
        this.statusPageList.setEnabled(this.enableStatusPage.isSelected());
        this.includeMachinesInStatusPageBox.setEnabled(this.enableStatusPage.isSelected());
        this.includeSessionsInStatusPageBox.setEnabled(this.enableStatusPage.isSelected());
    }

    @Override
    public void setTechClient(TechClient techClient) {
        super.setTechClient(techClient);
        this.currentServerHost = "";
        this.currentServerPort = 0;
        if (techClient != null) {
            this.currentServerHost = techClient.getHost();
            this.currentServerPort = techClient.getPort();
        }
        this.currentServerExampleUrl = SHJWUtil.getUpdateURLProtocol() + "://" + this.currentServerHost + ":" + this.currentServerPort + "/";
        this.ports1.setText("<html><b>" + this.currentServerExampleUrl + "statuspage</b> - (" + Language.get("ADMIN_NOTIFY_STATUS_XML_URL") + ")</html>");
        this.ports2.setText("<html><b>" + this.currentServerExampleUrl + "techsloggedin</b> - (" + Language.get("ADMIN_NOTIFY_STATUS_TECH_URL") + ")</html>");
    }

    class StatusPageList
    extends IconedAbstractListUI<String> {
        public StatusPageList(ResourceBundle lang, String[] initialList) {
            super(lang, initialList, false, false);
            this.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        }

        @Override
        protected Icon getIconForObject(String element) {
            return ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,16");
        }

        @Override
        protected String getNewObject() {
            return SHGlassOptionPane.showInputDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminStatus.this.rootComponent), (String)("<html>" + this.lang.getString("ADMIN_NOTIFY_STATUS_NEW_MSG") + "<br><br>" + this.lang.getString("ADMIN_IP_RESTRICTION_1") + "<br>" + this.lang.getString("ADMIN_IP_RESTRICTION_2") + "</html>"), (String)this.lang.getString("ADMIN_NOTIFY_STATUS_NEW_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/lock-open.svg,48"), (String)this.lang.getString("OK"), (String)"*");
        }

        @Override
        protected void listChanged() {
            AdminStatus.this.contentChanged(AdminStatus.this.checkIfValid());
            AdminStatus.this.saveListener.statusPageChanged();
        }
    }
}

