/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.dataexport;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.ssl.SSLUploadDialog;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class AdminEmail
extends SubSection
implements ValidationKeyListener.ValidationInterface,
ActionListener {
    JCheckBox emailBox;
    JTextField smtpHostField;
    JTextField smtpPortField;
    JTextField smtpUserField;
    JPasswordField smtpPasswordField;
    JTextField smtpFromEmailField;
    JTextField smtpFromNameField;
    JCheckBox smtpSSL;
    JCheckBox smtpTLS;
    JButton testConnection;
    JCheckBox sendAsTechnician;
    JButton manageSSLCertificates;
    private PleaseWaitDialog pleaseWaitDialog;
    TestListener testListener;

    @Override
    protected void initUI() {
        this.initEmailPanel(this.rootComponent);
    }

    private void initEmailPanel(JPanel emailPanel) {
        this.testListener = new TestListener();
        emailPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.emailBox = new JCheckBox(Language.get("ADMIN_EMAIL_ENABLE"));
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("ADMIN_EMAIL_DESC") + "</html>");
        JLabel smtpHostLabel = new JLabel(Language.get("ADMIN_EMAIL_HOSTNAME"));
        this.smtpHostField = new JTextField();
        JLabel smtpPortLabel = new JLabel(Language.get("ADMIN_EMAIL_PORT"));
        this.smtpPortField = new JTextField();
        this.smtpPortField.setDocument(new DigitDocument());
        JLabel smtpUserLabel = new JLabel(Language.get("ADMIN_EMAIL_USERNAME"));
        this.smtpUserField = new JTextField();
        JLabel smtpPasswordLabel = new JLabel(Language.get("ADMIN_EMAIL_PASSWORD"));
        this.smtpPasswordField = new JFixedWidthPasswordField();
        JLabel smtpFromEmailLabel = new JLabel(Language.get("ADMIN_EMAIL_FROM_EMAIL"));
        this.smtpFromEmailField = new JTextField();
        JLabel smtpFromNameLabel = new JLabel(Language.get("ADMIN_EMAIL_FROM_NAME"));
        this.smtpFromNameField = new JTextField();
        this.smtpSSL = new JCheckBox(Language.get("ADMIN_EMAIL_SSL"));
        this.smtpTLS = new JCheckBox(Language.get("ADMIN_EMAIL_TLS"));
        this.sendAsTechnician = new JCheckBox(Language.get("ADMIN_EMAIL_SEND_AS_TECHNICIAN"));
        this.testConnection = new JButton(Language.get("ADMIN_EMAIL_TEST_CONNECTION"));
        JPanel paddy = new JPanel();
        this.manageSSLCertificates = new JButton(Language.get("MANAGE_SSL"));
        SwingUtil.setWidth((JComponent)this.smtpHostField, (int)SimpleHelpLookAndFeel.scale((int)300));
        SwingUtil.setWidth((JComponent)this.smtpPortField, (int)SimpleHelpLookAndFeel.scale((int)60));
        SwingUtil.setWidth((JComponent)this.smtpUserField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setSize((JComponent)this.smtpPasswordField, (int)SimpleHelpLookAndFeel.scale((int)200), (int)this.smtpPortField.getPreferredSize().height);
        SwingUtil.setWidth((JComponent)this.smtpFromEmailField, (int)SimpleHelpLookAndFeel.scale((int)300));
        SwingUtil.setWidth((JComponent)this.smtpFromNameField, (int)SimpleHelpLookAndFeel.scale((int)300));
        RoundBorderPanel panel = new RoundBorderPanel(Language.get("ADMIN_EMAIL_TITLE"));
        GridBagLayout gbl2 = new GridBagLayout();
        panel.setLayout(gbl2);
        int Y = 0;
        GbPanel sslPanel = new GbPanel();
        sslPanel.add((Component)this.smtpSSL, 0, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(10, 0, 3, 0));
        sslPanel.add((Component)this.manageSSLCertificates, 1, 0, 1, 1, 0, 1, 13, 0, (Insets)new ScaledInsets(10, 0, 3, 0));
        sslPanel.add((Component)this.smtpTLS, 0, 1, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(3, 0, 10, 0));
        ColorPropagatingGBPanel sendAsTechPanel = new ColorPropagatingGBPanel();
        sendAsTechPanel.add(this.sendAsTechnician, 0, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(3, 0, 3, 0));
        this.smtpSSL.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.smtpTLS.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        sendAsTechPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        gbl2.setConstraints(smtpHostLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpHostField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints(smtpPortLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpPortField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints(smtpUserLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpUserField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints(smtpPasswordLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpPasswordField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints(smtpFromEmailLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpFromEmailField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints(smtpFromNameLabel, new GridBagConstraints(0, Y, 1, 1, 1.0, 1.0, 13, 0, (Insets)new ScaledInsets(0, 0, 3, 5), 0, 0));
        gbl2.setConstraints(this.smtpFromNameField, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 0, 0));
        gbl2.setConstraints((Component)((Object)sendAsTechPanel), new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 20, 0));
        gbl2.setConstraints((Component)sslPanel, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0), 20, 0));
        gbl2.setConstraints(this.testConnection, new GridBagConstraints(1, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(10, 0, 10, 50), 0, 0));
        ((Container)panel).add(smtpHostLabel);
        ((Container)panel).add(this.smtpHostField);
        ((Container)panel).add(smtpPortLabel);
        ((Container)panel).add(this.smtpPortField);
        ((Container)panel).add(smtpUserLabel);
        ((Container)panel).add(this.smtpUserField);
        ((Container)panel).add(smtpPasswordLabel);
        ((Container)panel).add(this.smtpPasswordField);
        ((Container)panel).add(smtpFromEmailLabel);
        ((Container)panel).add(this.smtpFromEmailField);
        ((Container)panel).add(smtpFromNameLabel);
        ((Container)panel).add(this.smtpFromNameField);
        ((Container)panel).add((Component)sslPanel);
        ((Container)panel).add((Component)((Object)sendAsTechPanel));
        ((Container)panel).add(this.testConnection);
        GridBagLayout gbl = new GridBagLayout();
        emailPanel.setLayout(gbl);
        Y = 0;
        gbl.setConstraints((Component)desc, new GridBagConstraints(0, Y++, 2, 1, 1.0, 1.0, 13, 2, (Insets)new ScaledInsets(0, 0, 10, 0), 0, 0));
        gbl.setConstraints(this.emailBox, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 0, (Insets)new ScaledInsets(0, 0, 10, 5), 0, 0));
        gbl.setConstraints(panel, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1.0, 17, 2, (Insets)new ScaledInsets(0, 0, 10, 0), 0, 0));
        gbl.setConstraints(paddy, new GridBagConstraints(0, Y++, 1, 1, 1.0, 1000.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
        emailPanel.add((Component)desc);
        emailPanel.add(this.emailBox);
        emailPanel.add(panel);
        emailPanel.add(paddy);
        this.emailBox.addActionListener(this.validateListener);
        this.smtpHostField.addKeyListener(this.validateListener);
        this.smtpPortField.addKeyListener(this.validateListener);
        this.smtpUserField.addKeyListener(this.validateListener);
        this.smtpPasswordField.addKeyListener(this.validateListener);
        this.smtpFromEmailField.addKeyListener(this.validateListener);
        this.smtpFromNameField.addKeyListener(this.validateListener);
        this.smtpSSL.addActionListener(this.validateListener);
        this.smtpTLS.addActionListener(this.validateListener);
        this.sendAsTechnician.addActionListener(this.validateListener);
        this.manageSSLCertificates.addActionListener(this);
        this.testConnection.addActionListener(this.testListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.manageSSLCertificates) {
            try {
                SSLUploadDialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.manageSSLCertificates), this.techClient);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_NOTIFY_EMAIL_TAB");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.emailBox.setSelected(config.emailSettingsEnabled);
        this.smtpHostField.setText(config.smtpHost);
        this.smtpPortField.setText(Integer.toString(config.smtpPort));
        this.smtpUserField.setText(config.smtpUser);
        this.smtpPasswordField.setText(config.smtpPassword.getDecryptedPassword());
        this.smtpFromEmailField.setText(config.smtpFromEmail);
        this.smtpFromNameField.setText(config.smtpFromName);
        this.smtpSSL.setSelected(config.smtpSSL);
        this.smtpTLS.setSelected(config.smtpTLS);
        this.sendAsTechnician.setSelected(config.smtpSendAsTechnicians);
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.emailSettingsEnabled = this.emailBox.isSelected();
        config.smtpHost = this.smtpHostField.getText();
        try {
            config.smtpPort = Integer.parseInt(this.smtpPortField.getText());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        config.smtpUser = this.smtpUserField.getText();
        if (config.smtpPassword == null) {
            config.smtpPassword = new LazyEncryptedPassword(new String(this.smtpPasswordField.getPassword()));
        } else {
            config.smtpPassword.setDecryptedPassword(new String(this.smtpPasswordField.getPassword()));
        }
        config.smtpFromEmail = this.smtpFromEmailField.getText();
        config.smtpFromName = this.smtpFromNameField.getText();
        config.smtpSSL = this.smtpSSL.isSelected();
        config.smtpTLS = this.smtpTLS.isSelected();
        config.smtpSendAsTechnicians = this.sendAsTechnician.isSelected();
    }

    @Override
    public boolean insertDefaultPadding() {
        return true;
    }

    @Override
    public void checkEnabled() {
        this.smtpHostField.setEnabled(this.emailBox.isSelected());
        this.smtpPortField.setEnabled(this.emailBox.isSelected());
        this.smtpUserField.setEnabled(this.emailBox.isSelected());
        this.smtpPasswordField.setEnabled(this.emailBox.isSelected());
        this.smtpFromEmailField.setEnabled(this.emailBox.isSelected());
        this.smtpFromNameField.setEnabled(this.emailBox.isSelected());
        this.smtpSSL.setEnabled(this.emailBox.isSelected());
        this.smtpTLS.setEnabled(this.emailBox.isSelected());
        this.sendAsTechnician.setEnabled(this.emailBox.isSelected());
        this.testConnection.setEnabled(this.emailBox.isSelected());
        this.manageSSLCertificates.setEnabled(this.emailBox.isSelected());
    }

    @Override
    public ArrayList<JComponent> checkAndMarkValid() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        int oldSize = list.size();
        if (this.emailBox.isSelected()) {
            if (this.smtpHostField.getText().length() == 0) {
                list.add(this.smtpHostField);
            } else {
                this.smtpHostField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.smtpPortField.getText().length() == 0 || !AdminEmail.isValidPortField(this.smtpPortField.getText())) {
                list.add(this.smtpPortField);
            } else {
                this.smtpPortField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.smtpFromEmailField.getText().length() == 0) {
                list.add(this.smtpFromEmailField);
            } else {
                this.smtpFromEmailField.setBorder(this.defaultTextFieldBorder);
            }
            if (this.smtpFromNameField.getText().length() == 0) {
                list.add(this.smtpFromNameField);
            } else {
                this.smtpFromNameField.setBorder(this.defaultTextFieldBorder);
            }
        } else {
            this.smtpHostField.setBorder(this.defaultTextFieldBorder);
            this.smtpPortField.setBorder(this.defaultTextFieldBorder);
            this.smtpUserField.setBorder(this.defaultTextFieldBorder);
            this.smtpPasswordField.setBorder(this.defaultTextFieldBorder);
            this.smtpFromEmailField.setBorder(this.defaultTextFieldBorder);
            this.smtpFromNameField.setBorder(this.defaultTextFieldBorder);
        }
        boolean emailConfigComplete = list.size() == oldSize;
        this.testConnection.setEnabled(this.emailBox.isSelected() && emailConfigComplete);
        return list;
    }

    class TestListener
    implements ActionListener {
        TestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                try {
                    String str = SHGlassOptionPane.showInputDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminEmail.this.rootComponent), (String)Language.get("ADMIN_TEST_EMAIL_MSG"), (String)Language.get("ADMIN_TEST_EMAIL_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/computing/email.svg,48"), (String)Language.get("ADMIN_EMAIL_SEND_MSG"), (String)"");
                    if (str != null) {
                        AdminEmail.this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)AdminEmail.this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_EMAILING"));
                        new EmailTestThread(str).start();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (AdminEmail.this.pleaseWaitDialog == null) break block3;
                    AdminEmail.this.pleaseWaitDialog.setVisible(false);
                }
            }
        }
    }

    class EmailTestThread
    extends Thread {
        private String emailAddy;

        public EmailTestThread(String emailAddy) {
            super("EmailTestThread");
            this.emailAddy = emailAddy;
        }

        @Override
        public void run() {
            String host = AdminEmail.this.smtpHostField.getText();
            String port = AdminEmail.this.smtpPortField.getText();
            boolean tls = AdminEmail.this.smtpTLS.isSelected();
            boolean ssl = AdminEmail.this.smtpSSL.isSelected();
            String username = AdminEmail.this.smtpUserField.getText();
            String password = new String(AdminEmail.this.smtpPasswordField.getPassword());
            String fromEmail = AdminEmail.this.smtpFromEmailField.getText();
            boolean auth = true;
            if (username == null || username.trim().length() == 0) {
                auth = false;
            }
            try {
                boolean success = AdminEmail.this.techClient.testEmail(host, port, tls, ssl, username, password, fromEmail, this.emailAddy, auth);
                AdminEmail.this.pleaseWaitDialog.setVisible(false);
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminEmail.this.rootComponent), (String)Language.get("ADMIN_EMAIL_OK_MSG"), (String)Language.get("ADMIN_TEST_EMAIL_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Throwable e) {
                e.printStackTrace();
                AdminEmail.this.pleaseWaitDialog.setVisible(false);
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminEmail.this.rootComponent), (String)(Language.get("ADMIN_EMAIL_ERR_MSG") + ": " + e.getMessage()), (String)Language.get("ADMIN_TEST_EMAIL_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

