/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections;

import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.sectionproperties.Section;

public abstract class SubSection
implements ValidationKeyListener.ValidationInterface {
    protected JPanel rootComponent = new ColorPropagatingPanel();
    protected TechClient techClient;
    protected ValidationKeyListener validateListener;
    protected Section section;
    protected AdminSection.RequestSaveListener saveListener;
    protected JLabel leftTitleLabel = new JLabel();
    protected JLabel rightTitleLabel = new JLabel();
    protected Border defaultTextFieldBorder;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public SubSection() {
        this.validateListener = new ValidationKeyListener(this);
        this.initUI();
        this.defaultTextFieldBorder = UIManager.getBorder("TextField.border");
    }

    public void setRequestSaveListener(AdminSection.RequestSaveListener listener) {
        this.saveListener = listener;
    }

    public void setSection(Section section) {
        this.section = section;
    }

    public boolean forceSave() {
        return false;
    }

    @Override
    public void checkEnabled() {
    }

    protected String getRightTitle() {
        return null;
    }

    protected abstract void initUI();

    public abstract String getTitle();

    public abstract void loadFrom(ServerConfig var1);

    public abstract void saveTo(ServerConfig var1);

    public boolean insertDefaultPadding() {
        return true;
    }

    public void overrideBorderForSubSection() {
    }

    public boolean grabAllVerticalSpace() {
        return false;
    }

    public void saveComplete(ServerConfig config) {
    }

    @Override
    public void contentChanged(boolean isValid) {
        this.section.setIsValidAndComplete(isValid);
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
    }

    protected ArrayList<JComponent> checkAndMarkValid() {
        return null;
    }

    @Override
    public boolean checkIfValid() {
        ArrayList<JComponent> list = this.checkAndMarkValid();
        if (list != null) {
            for (JComponent comp : list) {
                comp.setBorder(SHStyle.TEXTFIELDBORDER_RED);
            }
            return list.size() == 0;
        }
        return true;
    }

    protected static boolean isValidPortField(String portText) {
        return SubSection.isValidPortField(portText, false);
    }

    protected static boolean isValidPortField(String portText, boolean multiple) {
        String[] list = multiple ? portText.split(",") : new String[]{portText};
        try {
            for (String aList : list) {
                String port = aList.trim();
                if (port.length() == 0) {
                    return false;
                }
                int ii = Integer.parseInt(port);
                if (!(ii < 1 | ii > 65535)) continue;
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public JLabel getRightTitleLabel() {
        return this.rightTitleLabel;
    }

    public JLabel getLeftTitleLabel() {
        return this.leftTitleLabel;
    }

    protected void updateTitleLabels() {
        if (this.leftTitleLabel == null) {
            return;
        }
        this.leftTitleLabel.setText(this.getTitle());
        if (this.rightTitleLabel != null && this.getRightTitle() != null) {
            this.rightTitleLabel.setText(this.getRightTitle());
        }
        this.leftTitleLabel.repaint();
        this.rightTitleLabel.repaint();
    }

    protected void setRightTitleNormal() {
        this.rightTitleLabel.setForeground(UIManager.getColor("Label.foreground"));
        this.rightTitleLabel.repaint();
    }

    protected void setRightTitleGreen() {
        this.rightTitleLabel.setForeground(SHStyle.OK_TEXT_COLOR);
        this.rightTitleLabel.repaint();
    }

    protected void setRightTitleYellow() {
        this.rightTitleLabel.setForeground(SHStyle.WARNING_TEXT_COLOR);
        this.rightTitleLabel.repaint();
    }

    protected void setRightTitleRed() {
        this.rightTitleLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        this.rightTitleLabel.repaint();
    }

    protected void setRightTitleIcon(ImageIcon icon) {
        this.rightTitleLabel.setIcon(icon);
        this.rightTitleLabel.repaint();
    }

    public void switchedTo() {
    }

    public void switchedAway() {
    }
}

