/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import utils.message.TypedMap;

public class PeerConfigRepository {
    private static final File CONFIGS_FOLDER = new File("configuration/peers");
    public static PeerConfigRepository INSTANCE = new PeerConfigRepository();
    private final Object LOCK = new Object();
    private final ArrayList<PeerConfigWrapper> loadedConfigs = new ArrayList();
    private String peerServerName = null;
    private long peerMetadataLastModified = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeerConfig(PeerConfig newConfig) throws IOException {
        ArrayList<PeerConfigWrapper> arrayList = this.loadedConfigs;
        synchronized (arrayList) {
            System.out.println("[PeerConfig] Setting config " + newConfig);
            PeerConfigWrapper wrapper = this.getWrapperForConfig(newConfig);
            if (wrapper == null) {
                wrapper = new PeerConfigWrapper();
                wrapper.saveFile = this.getSaveFile(newConfig);
                wrapper.trimmedAuthToken = wrapper.saveFile.getName();
            }
            wrapper.peerConfig = newConfig;
            wrapper.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PeerConfig remoteConfig) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            PeerConfigWrapper wrapper = this.getWrapperForConfig(remoteConfig);
            if (wrapper != null) {
                wrapper.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfig(PeerConfig config) {
        ArrayList<PeerConfigWrapper> arrayList = this.loadedConfigs;
        synchronized (arrayList) {
            System.out.println("[PeerConfig] Deleting config " + config);
            PeerConfigWrapper toRemove = this.getWrapperForConfig(config);
            if (toRemove != null) {
                this.loadedConfigs.remove(toRemove);
                toRemove.saveFile.delete();
            } else {
                File file = this.getSaveFile(config);
                if (file.exists()) {
                    file.delete();
                } else {
                    System.out.println("[PeerConfig] Couldn't find config " + config.getAuthToken() + " to delete?");
                }
            }
        }
    }

    private PeerConfigWrapper getWrapperForConfig(PeerConfig config) {
        for (PeerConfigWrapper wrapper : this.loadedConfigs) {
            if (wrapper.peerConfig == config) {
                return wrapper;
            }
            if (!wrapper.peerConfig.getAuthToken().equals(config.getAuthToken())) continue;
            return wrapper;
        }
        return null;
    }

    private File getSaveFile(PeerConfig config) {
        return this.getSaveFile(config.getAuthToken());
    }

    private File getSaveFile(String longAuthToken) {
        String filename = longAuthToken.substring(0, 20);
        CONFIGS_FOLDER.mkdirs();
        return new File(CONFIGS_FOLDER, filename);
    }

    public boolean hasStoredConfig(PeerConfig key) {
        return this.getSaveFile(key).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PeerConfig> getAllConfigs() {
        Object object = this.LOCK;
        synchronized (object) {
            this.loadAll();
            ArrayList<PeerConfig> allConfigs = new ArrayList<PeerConfig>();
            for (PeerConfigWrapper wrapper : this.loadedConfigs) {
                allConfigs.add(wrapper.peerConfig);
            }
            return allConfigs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerConfigWrapper getWrapperForTrimmedAuthToken(String trimmedAuthToken) {
        Object object = this.LOCK;
        synchronized (object) {
            PeerConfigWrapper existingWrapper = null;
            for (PeerConfigWrapper wrapper : this.loadedConfigs) {
                if (!wrapper.trimmedAuthToken.equals(trimmedAuthToken)) continue;
                existingWrapper = wrapper;
                break;
            }
            if (existingWrapper == null) {
                File file = new File(CONFIGS_FOLDER, trimmedAuthToken);
                if (!file.exists()) {
                    return null;
                }
                existingWrapper = new PeerConfigWrapper();
                existingWrapper.saveFile = new File(CONFIGS_FOLDER, trimmedAuthToken);
                existingWrapper.trimmedAuthToken = trimmedAuthToken;
                this.loadedConfigs.add(existingWrapper);
            }
            if (existingWrapper.lastModified != existingWrapper.saveFile.lastModified()) {
                existingWrapper.lastModified = existingWrapper.saveFile.lastModified();
                try {
                    existingWrapper.peerConfig = PeerConfig.fromFile(existingWrapper.saveFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return existingWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAll() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<PeerConfigWrapper> previousConfigs = new ArrayList<PeerConfigWrapper>(this.loadedConfigs);
            File[] files = CONFIGS_FOLDER.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.equals(PeerConfigRepository.getPeerMetadataFile())) {
                        if (file.lastModified() == this.peerMetadataLastModified) continue;
                        this.peerMetadataLastModified = file.lastModified();
                        this.peerServerName = null;
                        try {
                            TypedMap map = TypedMap.fromFile((File)file);
                            String name = map.getString("name");
                            if (name == null || name.length() <= 0) continue;
                            this.peerServerName = name;
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        continue;
                    }
                    if (file.getName().contains(".")) continue;
                    try {
                        PeerConfigWrapper wrapperForTrimmedAuthToken = this.getWrapperForTrimmedAuthToken(file.getName());
                        previousConfigs.remove(wrapperForTrimmedAuthToken);
                    }
                    catch (Throwable t) {
                        System.out.println("[PeerConfigRepository] Unable to load " + file);
                    }
                }
                this.loadedConfigs.removeAll(previousConfigs);
            }
        }
    }

    public PeerConfig getConfigForAuthToken(String authToken) {
        String trimmedToken = authToken.substring(0, 20);
        PeerConfigWrapper wrapperForTrimmedAuthToken = this.getWrapperForTrimmedAuthToken(trimmedToken);
        if (wrapperForTrimmedAuthToken == null) {
            return null;
        }
        return wrapperForTrimmedAuthToken.peerConfig;
    }

    private static File getPeerMetadataFile() {
        CONFIGS_FOLDER.mkdirs();
        return new File(CONFIGS_FOLDER, "__peer_metadata__");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeerServerName(String name) {
        Object object = this.LOCK;
        synchronized (object) {
            File file = PeerConfigRepository.getPeerMetadataFile();
            TypedMap map = new TypedMap();
            map.setString("name", name);
            try {
                map.toFile(file);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
            this.peerServerName = name;
            this.peerMetadataLastModified = file.lastModified();
        }
    }

    public String getPeerServerName() {
        this.loadAll();
        if (this.peerServerName != null) {
            return this.peerServerName;
        }
        return ServerConfig.get().hostname;
    }

    private class PeerConfigWrapper {
        String trimmedAuthToken;
        PeerConfig peerConfig;
        File saveFile;
        long lastModified;

        private PeerConfigWrapper() {
        }

        public boolean equals(Object o) {
            if (o instanceof PeerConfigWrapper) {
                return ((PeerConfigWrapper)o).trimmedAuthToken.equals(this.trimmedAuthToken);
            }
            return false;
        }

        public void save() throws IOException {
            this.peerConfig.saveToLocalFile(this.saveFile);
            this.lastModified = this.saveFile.lastModified();
        }
    }
}

