/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.login.TechUiLoginGlassDialog;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.Templates;
import com.aem.shelp.proxy.config.LazyHashPassword;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.LDAPBasePickerDialog;
import com.aem.shelp.tech.admin.LDAPGroupPickerDialog;
import com.aem.shelp.tech.admin.MultiTierConfigPanel;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.tech.utils.TechGroupSummaryLabel;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.ListDialog;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import com.aem.shelp.util.swing.ExampleLabel;
import com.aem.utils.authentication.LDAPProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapCheckBox;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public abstract class AuthenticationPanel
implements ActionListener,
KeyListener {
    private GbPanel radiusWarning;
    private GbPanel ldapWarning;
    private JButton configureRadiusServerButton;
    private JButton configureLDAPServerButton;
    private boolean ldapServerConfigured;
    private boolean radiusServerConfigured;
    private boolean emailServerConfigured;
    private TechClient techClient;
    private String[] ldapGroupDNs = null;
    private String passwordName;
    public LazyHashPassword password = null;
    private GbPanel rootComponent = new GbPanel();
    private StrippedContentPanel contentPanel = new SHStrippedContentPanel(this.rootComponent);
    private ColorPropagatingGBPanel multiTierPanel;
    public MultiTierConfigPanel multiTierConfig;
    private ColorPropagatingGBPanel passwordPanel;
    private JWrapCheckBox passwordCheckBox;
    private JButton setPasswordButton;
    private ColorPropagatingGBPanel radiusPanel;
    private GbPanel radiusSettingsPanel;
    private JButton radiusTestLoginButton;
    private JWrapCheckBox radiusCheckBox;
    private ColorPropagatingGBPanel ldapPanel;
    private JWrapCheckBox ldapCheckBox;
    private ColorPropagatingGBPanel ldapContents;
    private JButton searchBaseDN;
    private JTextField ldapSearchBaseField;
    private JRadioButton ldapSimpleButton;
    private JRadioButton ldapAdvancedButton;
    private GbPanel ldapAdvancedPanel;
    protected JTextField ldapFilterField;
    private JButton testSearchButton;
    private GbPanel ldapSimplePanel;
    private TechGroupSummaryLabel groupSummaryLabel;
    private JLabel allGroupsLabel;
    private JButton selectGroupsButton;
    private JButton ldapTestLoginButton;

    public abstract void save();

    public abstract void switchToRadiusServerConfig();

    public abstract void switchToLDAPServerConfig();

    public abstract void switchToEmailServerConfig();

    protected void saveLDAPSettings(LDAPProperties ldapProperties) {
        ldapProperties.baseDN = this.ldapSearchBaseField.getText();
        if (this.ldapSimpleButton.isSelected()) {
            ldapProperties.setSimple();
            ldapProperties.groups = this.ldapGroupDNs;
        } else {
            ldapProperties.setAdvanced();
            ldapProperties.filter = this.ldapFilterField.getText();
        }
    }

    public AuthenticationPanel() {
        this.initUI();
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public void initUI() {
        this.contentPanel.setBackgroundColors(SHStyle.PANEL_BACKGROUND_MEDIUM, SHStyle.PANEL_BACKGROUND_LIGHT);
        this.multiTierPanel = this.initMultiTierPanel();
        this.contentPanel.addContent((JComponent)((Object)this.multiTierPanel), Language.get("GROUP_MULTITIER"));
        this.ldapPanel = this.initLDAPPanel();
        this.contentPanel.addContent((JComponent)((Object)this.ldapPanel), Language.get("GROUP_LDAP"));
        this.radiusPanel = this.initRadiusPanel();
        this.contentPanel.addContent((JComponent)((Object)this.radiusPanel), Language.get("GROUP_RADIUS"));
        this.passwordPanel = this.initPasswordPanel();
        this.contentPanel.addContent((JComponent)((Object)this.passwordPanel), Language.get("GROUP_PASSWORD"));
        this.contentPanel.addVerticalFiller();
        this.contentPanel.setBackgroundColours();
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
        this.multiTierConfig.setTechClient(techClient);
    }

    private ColorPropagatingGBPanel initRadiusPanel() {
        this.radiusPanel = new ColorPropagatingGBPanel();
        this.radiusPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)10, (int)5));
        this.radiusCheckBox = new JWrapCheckBox("<html>" + Language.get("RADIUS_DESCRIPTION") + "</html>");
        this.radiusCheckBox.getCheckBoxComponent().addActionListener(this);
        this.radiusCheckBox.setBackground(SHStyle.PANEL_BACKGROUND_MEDIUM);
        this.configureRadiusServerButton = new JButton(Language.get("CONFIGURE_RADIUS"));
        this.configureRadiusServerButton.addActionListener(this);
        this.radiusWarning = new GbPanel();
        this.radiusWarning.add((Component)new JLabel(Language.get("RADIUS_WARNING")), 0, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 5));
        this.radiusWarning.add((Component)this.configureRadiusServerButton, 1, 0, 1, 1, 0, 1, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 0));
        this.radiusTestLoginButton = new JButton(Language.get("RADIUS_TEST_LOGIN"));
        this.radiusTestLoginButton.addActionListener(this);
        this.radiusSettingsPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.radiusSettingsPanel.setBackground(SHStyle.PANEL_BACKGROUND_MEDIUM);
        int Y = 0;
        this.radiusPanel.add((Component)this.radiusWarning, 0, Y++, 1, 1, 1, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.radiusPanel.add(this.radiusCheckBox.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.radiusPanel.add((Component)this.radiusSettingsPanel, 0, Y++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
        this.radiusPanel.add(this.radiusTestLoginButton, 0, Y++, 1, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
        return this.radiusPanel;
    }

    private ColorPropagatingGBPanel initLDAPPanel() {
        this.ldapPanel = new ColorPropagatingGBPanel();
        this.ldapPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)10, (int)5));
        this.configureLDAPServerButton = new JButton(Language.get("CONFIGURE_LDAP"));
        this.configureLDAPServerButton.addActionListener(this);
        this.ldapWarning = new GbPanel();
        this.ldapWarning.add((Component)new JLabel(Language.get("LDAP_WARNING")), 0, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 5));
        this.ldapWarning.add((Component)this.configureLDAPServerButton, 1, 0, 1, 1, 0, 1, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 0));
        JWrapLabel baseDescription = new JWrapLabel("<html>" + Language.get("GROUP_LDAP_BASE_DESC") + "</html>");
        ExampleLabel baseEg = new ExampleLabel(Language.get("EXAMPLE") + ": " + (OemBranding.OEM_IS_SH ? "dc=domain,dc=simple-help,dc=com" : "dc=domain,dc=xvue,dc=com"));
        JLabel baseLabel = new JLabel(Language.get("GROUP_LDAP_BASE_LABEL"));
        this.ldapAdvancedPanel = new GbPanel();
        JWrapLabel filterDescription = new JWrapLabel("<html>" + Language.get("GROUP_LABEL_FILTER_DESC") + "</html>");
        JLabel filterLabel = new JLabel(Language.get("GROUP_LDAP_FILTER_LABEL"));
        ExampleLabel filterEg = new ExampleLabel(Language.get("EXAMPLE") + ": (sAMAccountName=${Username})");
        this.testSearchButton = new JButton(Language.get("GROUP_LDAP_TEST_SEARCH"));
        this.testSearchButton.addActionListener(this);
        this.ldapSearchBaseField = new JTextField();
        this.ldapFilterField = new JTextField();
        SwingUtil.setWidth((JComponent)this.ldapSearchBaseField, (int)SimpleHelpLookAndFeel.scale((int)250));
        SwingUtil.setWidth((JComponent)this.ldapFilterField, (int)SimpleHelpLookAndFeel.scale((int)250));
        this.ldapSearchBaseField.addKeyListener(this);
        this.ldapFilterField.addKeyListener(this);
        int Y = 0;
        this.ldapAdvancedPanel.add((Component)filterDescription, 0, Y++, 3, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.ldapAdvancedPanel.add((Component)filterLabel, 0, Y, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        this.ldapAdvancedPanel.add((Component)this.ldapFilterField, 1, Y, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        this.ldapAdvancedPanel.add((Component)this.testSearchButton, 2, Y++, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        this.ldapAdvancedPanel.add((Component)filterEg, 1, Y, 2, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(2, 0, 5, 5));
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.ldapFilterField, this.testSearchButton});
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.testSearchButton);
        this.ldapSimplePanel = new ColorPropagatingGBPanel();
        JLabel desc = new JLabel(Language.get("LDAP_PICK_GROUPS_DESC"));
        this.groupSummaryLabel = new TechGroupSummaryLabel(false);
        this.allGroupsLabel = new JLabel(Language.get("LDAP_ALL_USERS"));
        this.selectGroupsButton = new JButton(Language.get("LDAP_FILTER_BUTTON"));
        this.selectGroupsButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
        this.selectGroupsButton.addActionListener(this);
        this.ldapSimplePanel.add((Component)desc, 0, 0, 3, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.ldapSimplePanel.add(this.groupSummaryLabel.getRootComponent(), 0, 1, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 5));
        this.ldapSimplePanel.add((Component)this.allGroupsLabel, 1, 1, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 5));
        this.ldapSimplePanel.add((Component)this.selectGroupsButton, 2, 1, 1, 1, 0, 1, 13, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
        this.groupSummaryLabel.getRootComponent().setVisible(false);
        this.ldapCheckBox = new JWrapCheckBox("<html>" + Language.get("GROUP_LDAP_DESCRIPTION") + "</html>");
        this.ldapCheckBox.getCheckBoxComponent().addActionListener(this);
        this.ldapTestLoginButton = new JButton(Language.get("GROUP_LDAP_TEST_LOGIN"));
        this.ldapTestLoginButton.addActionListener(this);
        this.ldapAdvancedPanel.setVisible(false);
        this.ldapTestLoginButton.setVisible(false);
        this.ldapSimpleButton = new JRadioButton(Language.get("LDAP_SIMPLE"));
        this.ldapAdvancedButton = new JRadioButton(Language.get("LDAP_ADVANCED"));
        this.ldapSimpleButton.addActionListener(this);
        this.ldapAdvancedButton.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ldapSimpleButton);
        bg.add(this.ldapAdvancedButton);
        this.ldapSimpleButton.setSelected(true);
        int Y2 = 0;
        this.ldapPanel.add((Component)this.ldapWarning, 0, Y2++, 2, 1, 1, 0, 17, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.ldapPanel.add(this.ldapCheckBox.getRootComponent(), 0, Y2++, 2, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.ldapContents = new ColorPropagatingGBPanel();
        this.ldapContents.setVisible(false);
        baseDescription.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.searchBaseDN = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.searchBaseDN);
        JPanel searchBasePanel = new JPanel(new BorderLayout());
        searchBasePanel.add((Component)this.ldapSearchBaseField, "Center");
        searchBasePanel.add((Component)this.searchBaseDN, "East");
        this.searchBaseDN.addActionListener(this);
        GbPanel baseDNPanel = new GbPanel();
        baseDNPanel.add((Component)baseLabel, 0, Y2, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 5));
        baseDNPanel.add((Component)searchBasePanel, 1, Y2, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        baseDNPanel.add((Component)baseDescription, 2, Y2++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 10, 0, 0));
        baseDNPanel.add((Component)baseEg, 1, Y2++, 2, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(2, 0, 0, 0));
        Y2 = 0;
        this.ldapContents.add((Component)baseDNPanel, 0, Y2++, 2, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 0, 0, 0));
        this.ldapContents.add(this.ldapSimpleButton, 0, Y2, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(10, 0, 0, 0));
        this.ldapContents.add(this.ldapTestLoginButton, 1, Y2++, 1, 2, 0, 1, 13, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
        this.ldapContents.add(this.ldapAdvancedButton, 0, Y2++, 1, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(3, 0, 0, 0));
        RoundBorderPanel border = new RoundBorderPanel();
        GbPanelWrapper gbPanelWrapper = new GbPanelWrapper((Container)border);
        gbPanelWrapper.add((Component)this.ldapSimplePanel, 0, 0, 2, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        gbPanelWrapper.add((Component)this.ldapAdvancedPanel, 0, 1, 2, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.ldapSimplePanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.ldapAdvancedPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.ldapContents.add(border, 0, Y2++, 2, 1, 1, 1, 10, 2, (Insets)new ScaledInsets(3, 0, 0, 0));
        this.ldapAdvancedPanel.setVisible(false);
        this.ldapPanel.add((Component)((Object)this.ldapContents), 0, Y2++, 2, 1, 1, 0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        return this.ldapPanel;
    }

    private ColorPropagatingGBPanel initPasswordPanel() {
        this.passwordPanel = new ColorPropagatingGBPanel();
        this.passwordPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)10, (int)5));
        this.passwordCheckBox = new JWrapCheckBox("<html>" + Language.get("GROUP_PASSWORD_DESCRIPTION") + "</html>");
        this.passwordCheckBox.getCheckBoxComponent().addActionListener(this);
        this.setPasswordButton = new JButton(Language.get("ADMIN_PASSWORD"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.setPasswordButton.addActionListener(this);
        this.setPasswordButton.setVisible(false);
        int Y = 0;
        this.passwordPanel.add(this.passwordCheckBox.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        this.passwordPanel.add(this.setPasswordButton, 0, Y++, 1, 1, 1, 1, 10, 0, (Insets)new ScaledInsets(30, 0, 0, 0));
        return this.passwordPanel;
    }

    private ColorPropagatingGBPanel initMultiTierPanel() {
        this.multiTierPanel = new ColorPropagatingGBPanel();
        this.multiTierPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)10, (int)5));
        this.multiTierConfig = new MultiTierConfigPanel(Templates.twoTierActivationSubject, Templates.twoTierActivationContent, false){

            @Override
            public void saveSettings() {
                AuthenticationPanel.this.save();
            }

            @Override
            public void switchToEmailServerConfig() {
                AuthenticationPanel.this.switchToEmailServerConfig();
            }

            @Override
            public boolean isAdmin() {
                return false;
            }

            @Override
            public void launchAppBasedConfiguration() {
            }
        };
        this.multiTierConfig.setBackground(SHStyle.PANEL_BACKGROUND_MEDIUM);
        int Y = 0;
        this.multiTierPanel.add(this.multiTierConfig.getRootComponent(), 0, Y++, 1, 1, 1, 1, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        return this.multiTierPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ldapCheckBox.getCheckBoxComponent()) || e.getSource().equals(this.passwordCheckBox.getCheckBoxComponent()) || e.getSource().equals(this.radiusCheckBox.getCheckBoxComponent()) || e.getSource() == this.ldapSimpleButton || e.getSource() == this.ldapAdvancedButton) {
            this.updateEnabled();
            this.save();
        } else if (e.getSource() == this.selectGroupsButton) {
            this.selectGroupsButton.setIcon(new SHProgressAnimatedIcon());
            this.selectGroupsButton.setEnabled(false);
            new Thread(){

                @Override
                public void run() {
                    AuthenticationPanel.this.selectLDAPGroups();
                }
            }.start();
        } else if (e.getSource() == this.searchBaseDN) {
            this.searchBaseDN.setIcon(new SHProgressAnimatedIcon());
            this.searchBaseDN.setEnabled(false);
            new Thread(){

                @Override
                public void run() {
                    AuthenticationPanel.this.selectLDAPBase();
                }
            }.start();
        } else if (e.getSource().equals(this.setPasswordButton)) {
            PasswordDialog dialog = new PasswordDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), false, this.passwordName, null, false);
            if (dialog.isOK()) {
                this.password = LazyHashPassword.createWithNewPassword(new String(dialog.getSetPassword()));
                this.save();
            }
        } else if (e.getSource().equals(this.testSearchButton)) {
            new TestLDAPSearchThread().start();
        } else if (e.getSource().equals(this.ldapTestLoginButton)) {
            TechUiLoginGlassDialog dialog = new TechUiLoginGlassDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), null, false, false, null);
            TechCredentials credentials = dialog.getCredentials();
            if (credentials != null && credentials.hasUsername() && credentials.hasPassword()) {
                new TestLDAPConnectThread(credentials.getUsername(), credentials.getPassword()).start();
            }
        } else if (e.getSource().equals(this.radiusTestLoginButton)) {
            TechUiLoginGlassDialog dialog = new TechUiLoginGlassDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), null, false, false, null);
            TechCredentials credentials = dialog.getCredentials();
            if (credentials != null && credentials.hasUsername() && credentials.hasPassword()) {
                new TestRadiusThread(credentials.getUsername(), credentials.getPassword()).start();
            }
        } else if (e.getSource() == this.configureRadiusServerButton) {
            this.switchToRadiusServerConfig();
        } else if (e.getSource() == this.configureLDAPServerButton) {
            this.switchToLDAPServerConfig();
        }
    }

    private void updateLDAPSummaryLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AuthenticationPanel.this.ldapGroupDNs == null || AuthenticationPanel.this.ldapGroupDNs.length == 0) {
                    AuthenticationPanel.access$202(AuthenticationPanel.this, null);
                    AuthenticationPanel.this.allGroupsLabel.setVisible(true);
                    AuthenticationPanel.this.groupSummaryLabel.setVisible(false);
                } else {
                    String[] labels = new String[AuthenticationPanel.this.ldapGroupDNs.length];
                    for (int i = 0; i < labels.length; ++i) {
                        String[] parts = LDAPGroupPickerDialog.getDNParts(AuthenticationPanel.this.ldapGroupDNs[i], true);
                        labels[i] = parts[0];
                    }
                    AuthenticationPanel.this.groupSummaryLabel.setPickedTechsAndGroups(labels, null);
                    AuthenticationPanel.this.allGroupsLabel.setVisible(false);
                    AuthenticationPanel.this.groupSummaryLabel.setVisible(true);
                }
                AuthenticationPanel.this.ldapSimplePanel.repaint();
            }
        });
    }

    private void selectLDAPGroups() {
        try {
            LDAPGroupPickerDialog dialog = new LDAPGroupPickerDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.techClient, this.ldapSearchBaseField.getText(), this.ldapGroupDNs);
            this.ldapGroupDNs = dialog.getSelectedGroupDNs();
            this.updateLDAPSummaryLabels();
            this.save();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                ErrorDialogs.ErrorGlassDialog egd = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), Language.get("ADMIN_LDAP_SEARCH_ERR_MSG"));
                egd.setText(Language.get("ADMIN_LDAP_SEARCH_ERR_MSG"), Language.get("ADMIN_LDAP_SEARCH_ERR_MSG") + ": " + e.getMessage(), e.getMessage());
                egd.showDialog();
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AuthenticationPanel.this.selectGroupsButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
                        AuthenticationPanel.this.selectGroupsButton.setEnabled(true);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void selectLDAPBase() {
        block4: {
            try {
                LDAPBasePickerDialog dialog = new LDAPBasePickerDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), this.techClient);
                String base = dialog.getBaseDN();
                if (base == null) break block4;
                this.ldapSearchBaseField.setText(base);
                this.ldapSearchBaseField.repaint();
                this.save();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorDialogs.ErrorGlassDialog egd = new ErrorDialogs.ErrorGlassDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), Language.get("ADMIN_LDAP_SEARCH_ERR_MSG"));
                    egd.setText(Language.get("ADMIN_LDAP_SEARCH_ERR_MSG"), Language.get("ADMIN_LDAP_SEARCH_ERR_MSG") + ": " + e.getMessage(), e.getMessage());
                    egd.showDialog();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AuthenticationPanel.this.searchBaseDN.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
                            AuthenticationPanel.this.searchBaseDN.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void setLDAPProperties(LDAPProperties ldapProperties) {
        this.ldapSimpleButton.setSelected(ldapProperties.isSimple());
        this.ldapAdvancedButton.setSelected(!ldapProperties.isSimple());
        this.ldapSearchBaseField.setText(ldapProperties.baseDN);
        this.ldapFilterField.setText(ldapProperties.filter);
        this.ldapGroupDNs = ldapProperties.groups;
        this.updateLDAPSummaryLabels();
    }

    public void setUseLDAP(boolean ldap) {
        this.ldapCheckBox.setSelected(ldap);
        this.updateEnabled();
    }

    public void setUseEmailAuthentication(boolean twoTier) {
        this.multiTierConfig.setUseEmailAuthentication(twoTier);
        this.updateEnabled();
    }

    public void setUsePassword(boolean password) {
        this.passwordCheckBox.setSelected(password);
        this.updateEnabled();
    }

    public void setUseRadius(boolean radius) {
        this.radiusCheckBox.setSelected(radius);
        this.updateEnabled();
    }

    public void setUseAppAuthentication(boolean useApp) {
        this.multiTierConfig.setUseAppAuthentication(useApp);
        this.updateEnabled();
    }

    public void setPasswordName(String name) {
        this.passwordName = name;
    }

    protected boolean useRadius() {
        return this.radiusCheckBox.isSelected();
    }

    protected boolean usePassword() {
        return this.passwordCheckBox.isSelected();
    }

    protected boolean useLDAP() {
        return this.ldapCheckBox.isSelected();
    }

    protected boolean useTwoTier() {
        return this.multiTierConfig.getUseEmailAuthentication();
    }

    protected boolean useAppAuthentication() {
        return this.multiTierConfig.getUseAppAuthentication();
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.updateEnabled();
        this.save();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    private void updateEnabled() {
        boolean isPassword = this.passwordCheckBox.isSelected();
        boolean isLDAP = this.ldapCheckBox.isSelected() && this.ldapServerConfigured;
        boolean isRadius = this.radiusCheckBox.isSelected() && this.radiusServerConfigured;
        this.multiTierConfig.setEmailServerConfigured(this.emailServerConfigured);
        this.ldapAdvancedPanel.setVisible(isLDAP);
        this.ldapTestLoginButton.setVisible(isLDAP);
        this.setPasswordButton.setVisible(isPassword);
        this.passwordPanel.setEnabled(isPassword);
        this.setPasswordButton.setEnabled(isPassword);
        this.ldapPanel.setEnabled(isLDAP);
        this.ldapSearchBaseField.setEnabled(isLDAP);
        this.ldapFilterField.setEnabled(isLDAP);
        this.testSearchButton.setEnabled(isLDAP);
        this.ldapTestLoginButton.setEnabled(isLDAP);
        this.radiusSettingsPanel.setVisible(isRadius);
        this.radiusTestLoginButton.setVisible(isRadius);
        this.radiusPanel.setEnabled(isRadius);
        this.radiusTestLoginButton.setEnabled(true);
        this.radiusCheckBox.setEnabled(this.radiusServerConfigured);
        this.radiusCheckBox.setVisible(this.radiusServerConfigured);
        this.ldapCheckBox.setEnabled(this.ldapServerConfigured);
        this.ldapCheckBox.setVisible(this.ldapServerConfigured);
        this.radiusWarning.setVisible(!this.radiusServerConfigured);
        this.ldapWarning.setVisible(!this.ldapServerConfigured);
        this.ldapAdvancedPanel.setVisible(this.ldapAdvancedButton.isSelected());
        this.ldapSimplePanel.setVisible(this.ldapSimpleButton.isSelected());
        this.ldapContents.setVisible(isLDAP);
    }

    public void setConfiguredServers(boolean ldapEnable, boolean radiusEnable, boolean emailEnabled) {
        this.ldapServerConfigured = ldapEnable;
        this.radiusServerConfigured = radiusEnable;
        this.emailServerConfigured = emailEnabled;
        this.updateEnabled();
    }

    public void reloadEmailAuthenticationDefaults() {
        this.multiTierConfig.setEmailAuthenticationEmailDefaults(Templates.twoTierActivationSubject, Templates.twoTierActivationContent);
    }

    static /* synthetic */ String[] access$202(AuthenticationPanel x0, String[] x1) {
        x0.ldapGroupDNs = x1;
        return x1;
    }

    private class TestLDAPSearchThread
    extends Thread {
        private PleaseWaitDialog pleaseWaitDialog;

        TestLDAPSearchThread() {
            super("TestLDAPSearchThread");
            this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_LDAP"));
        }

        @Override
        public void run() {
            try {
                LDAPProperties ldapProperties = new LDAPProperties();
                AuthenticationPanel.this.saveLDAPSettings(ldapProperties);
                ArrayList<Object> result = AuthenticationPanel.this.techClient.testLDAPSearch(ldapProperties);
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                ListDialog listDialog = new ListDialog(SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), result, Language.get("LDAP_SEARCH_RESULTS_TITLE"), Language.get("LDAP_SEARCH_RESULTS_MSG"));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), (String)(Language.get("ADMIN_LDAP_SEARCH_ERR_MSG") + ": " + t.getMessage()), (String)Language.get("ADMIN_TEST_LDAP_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }

    private class TestRadiusThread
    extends Thread {
        private PleaseWaitDialog pleaseWaitDialog;
        private String username;
        private String password;

        TestRadiusThread(String username, String password) {
            super("TestRadiusThread");
            this.username = username;
            this.password = password;
            this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_RADIUS"));
        }

        @Override
        public void run() {
            try {
                AuthenticationPanel.this.techClient.testRadiusLogin(this.username, this.password);
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), (String)Language.get("ADMIN_LDAP_OK_MSG"), (String)Language.get("ADMIN_TEST_RADIUS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), (String)(Language.get("RADIUS_SERVER_CONNECT_FAIL") + ": " + t.getMessage()), (String)Language.get("ADMIN_TEST_RADIUS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }

    private class TestLDAPConnectThread
    extends Thread {
        private PleaseWaitDialog pleaseWaitDialog;
        private String username;
        private String password;

        TestLDAPConnectThread(String username, String password) {
            super("TestLDAPConnectThread");
            this.username = username;
            this.password = password;
            this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_LDAP"));
        }

        @Override
        public void run() {
            try {
                LDAPProperties ldapProperties = new LDAPProperties();
                AuthenticationPanel.this.saveLDAPSettings(ldapProperties);
                AuthenticationPanel.this.techClient.testLDAPLogin(this.username, this.password, ldapProperties);
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), (String)Language.get("ADMIN_LDAP_OK_MSG"), (String)Language.get("ADMIN_TEST_LDAP_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (this.pleaseWaitDialog != null) {
                    this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AuthenticationPanel.this.rootComponent), (String)(Language.get("ADMIN_LDAP_SEARCH_ERR_MSG") + ": " + t.getMessage()), (String)Language.get("ADMIN_TEST_LDAP_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

