/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.TechServerConfigManager;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.AdminPanel;
import com.aem.shelp.util.PleaseWaitDialog;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class AdministrationTab
implements TechServerConfig.TechServerConfigListener {
    private boolean preventMismatchDialog = false;
    private final RootPaneContainer rpc;
    private JPanel rootComponent = new JPanel();
    private AdminPanel fullAdminPanel = new AdminPanel();
    private TechClient client;
    private MachineTreeModel machineModel;
    private boolean showOnlyTechConfig;

    public AdministrationTab(RootPaneContainer rpc) {
        this.rpc = rpc;
        this.rootComponent.setLayout(new GridLayout(1, 1));
        this.rootComponent.add(this.fullAdminPanel);
    }

    public void setTechClient(TechClient client, MachineTreeModel machineModel) throws Exception {
        this.client = client;
        this.machineModel = machineModel;
        client.addNewServerConfigListener(this);
        new TechServerConfig(client);
        TechServerConfig.INSTANCE.addTechServerConfigListener(this);
        this.fullAdminPanel.setTechClient(client, machineModel);
        if (!client.getTechUser().canAdministerServer && client.getTechUser().canAdministerGroup) {
            this.showOnlyTechConfig = true;
            System.out.println("[TechUI] Switching to group administration console");
            this.fullAdminPanel.showOnlyTechConfig();
        }
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void updateSessionLimit() {
        this.fullAdminPanel.updateSessionLimit();
    }

    public void peersChanged() {
        this.fullAdminPanel.peersChanged();
    }

    public void loadExistingConfigIntoUI() {
        this.fullAdminPanel.loadConfig();
    }

    public void saveIfRequired() {
        this.fullAdminPanel.saveIfRequired();
    }

    public void tabActive() {
        if (!TechServerConfig.INSTANCE.hasBeenFetched()) {
            new PleaseWaitForConfigDialog().start();
        }
    }

    @Override
    public void serverConfigFetched() {
        System.out.println("[AdministrationTab] Server Config Fetched");
        this.fullAdminPanel.loadConfig();
    }

    @Override
    public void localServerConfigChanged(String sourceID) {
        if (!sourceID.equals("Admin")) {
            System.out.println("[AdministrationTab] Local server config changed event received");
            this.fullAdminPanel.loadConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TechServerConfig.ServerConfigMismatchHandler configMismatch(String reason) {
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            if (this.preventMismatchDialog) {
                return new TechServerConfig.ServerConfigMismatchHandler(false, false);
            }
            if (this.showConfigServerMismatchDialog(this.rpc, reason)) {
                return new TechServerConfig.ServerConfigMismatchHandler(true, false);
            }
            return new TechServerConfig.ServerConfigMismatchHandler(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configMismatchHandled() {
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            this.preventMismatchDialog = false;
        }
    }

    @Override
    public void failedToBind(String[] failedAddresses) {
        this.showFailedToBindToPortsDialog(this.rpc, failedAddresses);
    }

    @Override
    public void loadedNewConfig(ServerConfig config) {
    }

    public void selectGroup(TechGroup group) {
        this.fullAdminPanel.switchToTechnicianGroup(group);
    }

    public void removeGroupAssociatedWith(AppProfile app, boolean saveConfig) {
        this.fullAdminPanel.removeGroupAssociatedWith(app, saveConfig);
    }

    public void switchToAdministrationTabMemoryConfig() {
        this.fullAdminPanel.switchToAdministrationTabMemoryConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchConfigFromServer() {
        boolean forceReload = false;
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            if (TechServerConfigManager.INSTANCE.isSaveQueued()) {
                TechServerConfig.ServerConfigMismatchHandler mismatchHandler = this.configMismatch("Config changed on server but save is queued");
                if (mismatchHandler.overwrite()) {
                    try {
                        System.out.println("[AdministrationTab] User chose to force overwrite server configuration");
                        TechServerConfig.INSTANCE.forceSaveNow();
                    }
                    finally {
                        this.configMismatchHandled();
                    }
                } else if (mismatchHandler.revert()) {
                    System.out.println("[AdministrationTab] User chose to revert changes");
                    this.configMismatchHandled();
                    TechServerConfigManager.INSTANCE.clearRequestedSaveConfigInstanceID();
                    forceReload = true;
                }
            } else {
                forceReload = true;
            }
        }
        if (forceReload) {
            TechServerConfig.INSTANCE.forceReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showConfigServerMismatchDialog(RootPaneContainer rpc, String reason) {
        Object object = TechServerConfigManager.INSTANCE.SERVER_CONFIG_LOCK;
        synchronized (object) {
            this.preventMismatchDialog = true;
        }
        System.out.println("[AdministrationTab] Showing mismatch dialog now (reason:" + reason + ")");
        return SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)rpc, (String)Language.get("CONFIG_SERVER_MISMATCH_MSG"), (String)Language.get("CONFIG_SERVER_MISMATCH_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("OVERWRITE"), (String)Language.get("REVERT"));
    }

    public void showFailedToBindToPortsDialog(RootPaneContainer rpc, String[] failedToBindPorts) {
        SHGlassOptionPane.showMessageDialog((RootPaneContainer)rpc, (String)(Language.get("CONFIG_SERVER_BIND_FAILURE_1", failedToBindPorts) + "<BR><BR>" + Language.get("CONFIG_SERVER_BIND_FAILURE_2")), (String)Language.get("CONFIG_SERVER_BIND_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("REVERT"));
    }

    class PleaseWaitForConfigDialog
    extends Thread {
        PleaseWaitForConfigDialog() {
        }

        @Override
        public void run() {
            PleaseWaitDialog pleaseWaitDialog = null;
            try {
                pleaseWaitDialog = new PleaseWaitDialog(AdministrationTab.this.rpc, Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_LOADING"));
                TechServerConfig.INSTANCE.blockUntilLoaded();
                pleaseWaitDialog.setVisible(false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                if (pleaseWaitDialog != null) {
                    pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)AdministrationTab.this.rpc, (String)(Language.get("FAILED_LOAD_MSG") + "\n\n" + e1.getMessage()), (String)Language.get("FAILED_LOAD_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

