/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.details;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.swing.ShPopupMenuButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jwrapper.jwutils.JWWindowsOS;
import utils.swing.RetinaImageIcon;
import utils.swing.SwingUtil;
import utils.swing.images.ImageLoader;

public class RDPSessionRenderer
extends DefaultTableCellRenderer {
    private Color background;
    private int hoverRow = -1;
    private Image hoverImage;
    private Image nonHoverImage;
    private BufferedImage technicianImage;
    private ImageIcon hoverIcon;
    private ImageIcon nonHoverIcon;
    private int dropDownButtonWidth = 0;

    public RDPSessionRenderer() {
        if (this.hoverImage == null) {
            ShPopupMenuButton connect = new ShPopupMenuButton(Language.get("CONNECT"), null){

                @Override
                public JPopupMenu getPopupMenu() {
                    return null;
                }
            };
            this.dropDownButtonWidth = connect.getDropDownButtonWidth();
            this.hoverImage = SwingUtil.getComponentImage((JComponent)((Object)connect), (int)0, (boolean)true);
            this.nonHoverImage = SwingUtil.getComponentImage((JComponent)((Object)connect), (int)0, (boolean)false);
            this.technicianImage = new BufferedImage(this.hoverImage.getWidth(null), this.hoverImage.getHeight(null), 2);
            Graphics2D g2d = this.technicianImage.createGraphics();
            Icon imageIcon = ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16");
            imageIcon.paintIcon(null, g2d, this.hoverImage.getWidth(null) - imageIcon.getIconWidth(), (this.hoverImage.getHeight(null) - imageIcon.getIconHeight()) / 2);
            g2d.dispose();
            this.hoverIcon = new RetinaImageIcon(this.hoverImage);
            this.nonHoverIcon = new RetinaImageIcon(this.nonHoverImage);
        }
    }

    public Dimension getButtonSize() {
        return new Dimension(this.nonHoverImage.getWidth(null), this.nonHoverImage.getHeight(null));
    }

    public int getDropDownButtonWidth() {
        return this.dropDownButtonWidth;
    }

    public void setRowBackground(Color c) {
        this.background = c;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setIcon(null);
        if (column == 0) {
            label.setIcon(ImageLoader.getImageIcon((String)"images/svg/users/technician.svg,16"));
        } else if (column == 1) {
            label.setIcon(ImageLoader.getImageIcon((String)"images/svg/technology/screen.svg,16"));
        } else if (column != 2 && column == 3) {
            label.setText("");
            JWWindowsOS.RDPSessionInfo info = (JWWindowsOS.RDPSessionInfo)value;
            if (info.state == 1) {
                if (this.hoverRow == row) {
                    label.setIcon(this.hoverIcon);
                } else {
                    label.setIcon(this.nonHoverIcon);
                }
            } else {
                label.setIcon(null);
            }
        }
        return label;
    }

    public int[] getFixedColumnSizes() {
        return new int[]{-1, -1, -1, this.hoverIcon.getIconWidth() + 2};
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackground(this.background);
        super.paintComponent(g);
    }

    public void setHoverRow(int row) {
        this.hoverRow = row;
    }
}

