/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.access.contents.table.sessions;

import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.NetAdapter;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTable;
import com.aem.shelp.tech.access.contents.table.sessions.SessionsTableRenderer;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.tech.customer.OSTag;
import java.awt.Graphics;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SessionTableColumns {
    public static int[] cumulativeColumnWidths;
    public static int columnsToShow;
    public static final int PADDING;
    public static final int OS_WIDTH;
    public static final int USERNAME_WIDTH;
    public static final int TECHNICIAN_WIDTH;
    public static final int DURATION_WIDTH;
    public static final int STATUS_ICON_WIDTH;
    public static final int IP_WIDTH;
    public static final int WANIP_WIDTH;
    public static final int HOSTNAME_WIDTH;
    public static final int TERMINATE_WIDTH;
    public static int osCenter;
    public static int usernameCenter;
    public static int statusCenter;
    public static int ipCenter;
    public static int wanIpCenter;
    public static int hostnameCenter;
    public static int durationCenter;
    public static int terminateCenter;
    public static int technicianCenter;
    private static int availableWidth;

    private static boolean inBetween(int x, int center, int width) {
        return center - width / 2 < x && x < center + width / 2;
    }

    public static int getColumnAtX(int x, int width) {
        int col0Width = width - cumulativeColumnWidths[columnsToShow - 1];
        if (x < col0Width) {
            return 0;
        }
        if (SessionTableColumns.inBetween(x, width + statusCenter, STATUS_ICON_WIDTH)) {
            return 1;
        }
        if (SessionTableColumns.inBetween(x, width + technicianCenter, TECHNICIAN_WIDTH)) {
            return 2;
        }
        if (SessionTableColumns.inBetween(x, width + durationCenter, DURATION_WIDTH)) {
            return 3;
        }
        if (SessionTableColumns.inBetween(x, width + osCenter, OS_WIDTH)) {
            return 4;
        }
        if (SessionTableColumns.inBetween(x, width + usernameCenter, USERNAME_WIDTH)) {
            return 5;
        }
        if (SessionTableColumns.inBetween(x, width + hostnameCenter, HOSTNAME_WIDTH)) {
            return 6;
        }
        if (SessionTableColumns.inBetween(x, width + ipCenter, IP_WIDTH)) {
            return 7;
        }
        if (SessionTableColumns.inBetween(x, width + wanIpCenter, WANIP_WIDTH)) {
            return 8;
        }
        return 0;
    }

    public static void setAvailableWidth(int width) {
        int colCount;
        if (width == availableWidth) {
            return;
        }
        availableWidth = width;
        for (colCount = cumulativeColumnWidths.length - 1; colCount > 0 && cumulativeColumnWidths[colCount] > width - SimpleHelpLookAndFeel.scale((int)200); --colCount) {
        }
        SessionTableColumns.setColumnsToShow(++colCount);
    }

    public static int getTerminateColumn() {
        if (columnsToShow >= 4) {
            return 3;
        }
        return -1;
    }

    public static int getColumnsWidth() {
        if (columnsToShow == 0) {
            return -1;
        }
        return cumulativeColumnWidths[columnsToShow - 1];
    }

    private static void setColumnsToShow(int count) {
        columnsToShow = count;
        if (count > 1) {
            int rightOffset = 0;
            if (count > 3) {
                terminateCenter = -PADDING - TERMINATE_WIDTH / 2;
                rightOffset = terminateCenter - TERMINATE_WIDTH / 2;
            }
            switch (columnsToShow) {
                case 10: {
                    wanIpCenter = rightOffset - PADDING - WANIP_WIDTH / 2;
                    rightOffset = wanIpCenter - WANIP_WIDTH / 2;
                }
                case 9: {
                    ipCenter = rightOffset - PADDING - IP_WIDTH / 2;
                    rightOffset = ipCenter - IP_WIDTH / 2;
                }
                case 8: {
                    hostnameCenter = rightOffset - PADDING - HOSTNAME_WIDTH / 2;
                    rightOffset = hostnameCenter - HOSTNAME_WIDTH / 2;
                }
                case 7: {
                    usernameCenter = rightOffset - PADDING - USERNAME_WIDTH / 2;
                    rightOffset = usernameCenter - USERNAME_WIDTH / 2;
                }
                case 6: {
                    osCenter = rightOffset - PADDING - OS_WIDTH / 2;
                    rightOffset = osCenter - OS_WIDTH / 2;
                }
                case 5: {
                    durationCenter = rightOffset - PADDING - DURATION_WIDTH / 2;
                    rightOffset = durationCenter - DURATION_WIDTH / 2;
                }
                case 3: 
                case 4: {
                    technicianCenter = rightOffset - PADDING - TECHNICIAN_WIDTH / 2;
                    rightOffset = technicianCenter - TECHNICIAN_WIDTH / 2;
                }
                case 2: {
                    statusCenter = rightOffset - PADDING - STATUS_ICON_WIDTH / 2;
                }
            }
        }
    }

    public static int getWanIPColumn() {
        if (columnsToShow == 10) {
            return 8;
        }
        return -1;
    }

    public static int getLanIPColumn() {
        if (columnsToShow == 9) {
            return 7;
        }
        return -1;
    }

    public static boolean isTerminateColumn(int x) {
        return availableWidth - x < TERMINATE_WIDTH;
    }

    public static Object getColumnContents(int column, SessionsTable.IndexedAbstractSession session) {
        Machine m = session.remoteMachine;
        if (column == columnsToShow - 1) {
            return null;
        }
        switch (column) {
            case 0: {
                return m.getMachineName().getName();
            }
            case 1: {
                if (!m.isAvailable()) {
                    return -1;
                }
                return m.getActiveSessionCount_ClientOnly();
            }
            case 2: {
                return session.session.getTechnicianDisplayName();
            }
            case 3: {
                return session.session.getDuration();
            }
            case 4: {
                return m.getOsSummary();
            }
            case 5: {
                return m.getRemoteUsername();
            }
            case 6: {
                return m.getMachineInfo().getHostname();
            }
            case 7: {
                NetAdapter[] netAdapters = m.getMachineInfo().getNetAdapters();
                if (netAdapters != null && netAdapters.length > 0 && netAdapters[0] != null) {
                    return netAdapters[0].ip;
                }
                return "";
            }
            case 8: {
                return m.getMachineInfo().getWanIP();
            }
        }
        return null;
    }

    public static void callPaintMethods(Graphics g, int width, int height, SessionColumnPainter painter, boolean isSelected, boolean paintName) {
        switch (columnsToShow) {
            case 10: {
                if (paintName) {
                    painter.paintWANIP(g, width, height);
                }
            }
            case 9: {
                if (paintName) {
                    painter.paintIP(g, width, height);
                }
            }
            case 8: {
                if (paintName) {
                    painter.paintHostname(g, width, height);
                }
            }
            case 7: {
                if (paintName) {
                    painter.paintUsername(g, width, height);
                }
            }
            case 6: {
                if (paintName) {
                    painter.paintOS(g, width, height, isSelected);
                }
            }
            case 5: {
                painter.paintDuration(g, width, height);
            }
            case 4: {
                painter.paintTerminate(g, width, height, isSelected);
            }
            case 3: {
                painter.paintTechnician(g, width, height);
            }
            case 2: {
                if (paintName) {
                    painter.paintStatus(g, width, height);
                }
            }
            case 0: 
            case 1: {
                if (!paintName) break;
                painter.paintMachineName(g, width, height);
            }
        }
    }

    static {
        columnsToShow = 0;
        PADDING = SimpleHelpLookAndFeel.scale((int)4);
        OS_WIDTH = OSTag.getTagWidth(OSIconLoader.OSIconSize.SMALL, true);
        USERNAME_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        TECHNICIAN_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        DURATION_WIDTH = SimpleHelpLookAndFeel.scale((int)70);
        STATUS_ICON_WIDTH = SimpleHelpLookAndFeel.scale((int)30);
        IP_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        WANIP_WIDTH = SimpleHelpLookAndFeel.scale((int)100);
        HOSTNAME_WIDTH = SimpleHelpLookAndFeel.scale((int)150);
        TERMINATE_WIDTH = SessionsTableRenderer.getTerminateButtonWidth() + PADDING;
        int i = 0;
        int j = 0;
        cumulativeColumnWidths = new int[10];
        SessionTableColumns.cumulativeColumnWidths[i++] = 0;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + STATUS_ICON_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + TECHNICIAN_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + TERMINATE_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + DURATION_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + OS_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + USERNAME_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + HOSTNAME_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + IP_WIDTH;
        SessionTableColumns.cumulativeColumnWidths[i++] = cumulativeColumnWidths[j++] + PADDING + WANIP_WIDTH;
        SessionTableColumns.setColumnsToShow(i);
    }

    public static interface SessionColumnPainter {
        public void paintIP(Graphics var1, int var2, int var3);

        public void paintWANIP(Graphics var1, int var2, int var3);

        public void paintHostname(Graphics var1, int var2, int var3);

        public void paintUsername(Graphics var1, int var2, int var3);

        public void paintDuration(Graphics var1, int var2, int var3);

        public void paintOS(Graphics var1, int var2, int var3, boolean var4);

        public void paintStatus(Graphics var1, int var2, int var3);

        public void paintMachineName(Graphics var1, int var2, int var3);

        public void paintTechnician(Graphics var1, int var2, int var3);

        public void paintTerminate(Graphics var1, int var2, int var3, boolean var4);
    }
}

