/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import build.BuildConstants;
import com.aem.CentralDebugging;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.SimpleDesktop;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.properties.LocalProperties;
import com.aem.shelp.tech.TechHelpUIIPCHandler;
import com.aem.shelp.util.DialogAuthenticator;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.UIUtils;
import com.aem.shelp.util.security.SecurityUtil;
import com.jw.AuxConfig;
import com.jw.SHJWUtil;
import java.awt.Image;
import java.io.IOException;
import java.net.Authenticator;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;
import utils.switches.oem.OEMSwitches;
import utils.udp.Acculog;

public class TechHelpUi {
    private static SimpleDesktop sd;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preload() {
        if (Switches.SH_sessionsInTechUiProcess) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (sd == null) {
                sd = new SimpleDesktop(false, false);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Acculog.setJVM("TechSession");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long start = System.currentTimeMillis();
        try {
            JWMacOS.setMyOSXAppName((String)BuildConstants.BUNDLE_TECHNICIAN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Image image = ImageLoader.getAsImage((String)"images/svg/logos/simplehelp-blue.svg,256");
            OSXAdapter.setDockIcon((Image)image);
        }
        catch (Throwable image) {
            // empty catch block
        }
        FixedByteBuffer.injectIntoStdout();
        try {
            CentralDebugging.setOptionalDebugDir(JWSystem.getAllAppVersionsSharedFolder());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            CentralDebugging.loadDebugSettings("TechSession", true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String id;
            if (OS.isWindowsVistaOrAbove() && (id = JWLaunchProperties.getProperty((String)"windows_app_id")) != null && id.length() > 0) {
                System.out.println("[TechHelpUI] Setting app ID to " + id);
                JWWindowsOS windowsOS = new JWWindowsOS();
                windowsOS.setWindowsAppID(id);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (Switches.SH_1559_centralClock) {
            OneClock.startClockThread();
        }
        System.out.println("[TechHelpUI] Getting pkey");
        SecurityUtil.getMyPublicKeySync();
        System.out.println("[TechHelpUI] Got pkey");
        Language.loadTranslations();
        System.out.println("[TechHelpUI] Setting up JOptionPane translations");
        UIUtils.initJOptionPaneTranslations();
        System.out.println("[TechHelpUI] Loading branding");
        ClientBranding.loadBrandingFromCacheDir(null);
        TechHelpUi.launchSessionUI(start);
    }

    public static void launchSessionUI() throws Exception {
        TechHelpUi.launchSessionUI(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchSessionUI(long start) throws Exception {
        SimpleDesktop sd;
        Object object = LOCK;
        synchronized (object) {
            sd = TechHelpUi.sd;
            if (Switches.SH_sessionsInTechUiProcess || sd == null) {
                sd = new SimpleDesktop(false, false);
                if (TechHelpUi.sd == null) {
                    TechHelpUi.sd = sd;
                }
            }
        }
        System.out.println("[TechHelpUI] Retrieving connect settings");
        ProxyConnectSettings proxyConnectSettings = ProxyConnectSettings.getProxyConnectSettingsForTechHelpUI();
        if (proxyConnectSettings.useCachedTranslations) {
            Language.loadCachedSecondaryTranslations();
        } else {
            Language.downloadSecondaryTranslations(SHJWUtil.getUpdateURLProtocol() + "://" + proxyConnectSettings.host + ":" + proxyConnectSettings.port);
        }
        new TechHelpUIIPCHandler();
        System.out.println("[TechHelpUI] " + proxyConnectSettings);
        System.out.println("[TechHelpUI] Total init time = " + (System.currentTimeMillis() - start));
        TechHelpUi.preload();
        Authenticator.setDefault(new DialogAuthenticator(sd.getFrame()));
        System.out.println("[TechHelpUI] SimpleDesktop started - connecting to proxy now...");
        sd.connectToProxy(proxyConnectSettings);
    }

    public static void launchAdditionalSession(ProxyConnectSettings connectSettings) throws IOException {
        SimpleDesktop sd = new SimpleDesktop(false, false);
        sd.connectToProxy(connectSettings);
    }

    static {
        AuxConfig.initAuxDownload();
        try {
            OEMSwitches.DARK_THEME = LocalProperties.isDarkMode();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            int scalingPercentage = LocalProperties.getScalingPercentageOverride();
            if (scalingPercentage > 0) {
                ScalingUtil.forceScalingPercentage((int)scalingPercentage);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SimpleHelpFrame.setLnf();
        LOCK = new Object();
    }
}

