/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech;

import com.aem.VersionUtil;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.LicenseSet;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.gettingstarted.AdminLicense;
import com.aem.shelp.tech.utils.IconAndText;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import testing.classes.access.AccessPanelTester;
import utils.progtools.date.DateUtil;
import utils.swing.SwingUtil;
import utils.swing.browser.Browser;
import utils.swing.components.FadedHorizontalLine;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthGbPanel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.switches.oem.OEMSwitches;

public class SHUpdateCheckDialog
extends PanelGlassDialog {
    private final UpdateCheckPane updateCheckPane;
    private TechClient techClient;
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
    private static LicenseSet license;
    private static boolean isTrial;
    private static int daysTillExpire;

    public SHUpdateCheckDialog(RootPaneContainer rootPane, TechClient client) {
        super(rootPane, Language.get("ADMIN_SERVER_OVERVIEW_CHECK_FOR_UPDATES"), 500, Language.get("CLOSE"), null);
        this.updateCheckPane = new UpdateCheckPane(client);
        this.setContent((FixedWidthComponent)this.updateCheckPane);
        this.techClient = client;
        new CheckVersionThread().start();
    }

    public static void setLicenses(LicenseSet lic) {
        license = lic;
        if (license == null) {
            isTrial = true;
        } else {
            try {
                if (lic.isTrial()) {
                    boolean hasExpired;
                    isTrial = true;
                    long expiryDate = lic.getTrialExpiry();
                    boolean bl = hasExpired = System.currentTimeMillis() > expiryDate;
                    daysTillExpire = !hasExpired ? DateUtil.getDaysBetween(System.currentTimeMillis(), expiryDate) : 0;
                } else {
                    isTrial = false;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                isTrial = false;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        OEMSwitches.DARK_THEME = true;
        SHUpdateCheckDialog.setLicenses(null);
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setSize(700, 500);
        frame.setVisible(true);
        TechClient client = AccessPanelTester.getTechClient();
        SHUpdateCheckDialog dialog = new SHUpdateCheckDialog((RootPaneContainer)frame, client);
        dialog.showDialog();
    }

    public class UpdateCheckPane
    extends FixedWidthGbPanel {
        private JLabel titleLabel;
        private FixedWidthGbPanel contentPanel;
        private TechClient client;
        private ActionListener renewActionListener;
        private CircularProgressLabel progressLabel;

        public UpdateCheckPane(TechClient client) {
            super(new ScaledInsets(3, 3, 3, 3));
            this.contentPanel = new FixedWidthGbPanel();
            this.renewActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdminLicense.showUpdateInBrowser(UpdateCheckPane.this.client);
                }
            };
            this.setPropagateColours(true);
            this.contentPanel.setPropagateColours(true);
            this.initUI();
            this.client = client;
        }

        protected void initUI() {
            FadedHorizontalLine line = new FadedHorizontalLine();
            SwingUtil.setWidth((JComponent)line, (int)SimpleHelpLookAndFeel.scale((int)400));
            this.titleLabel = new JLabel(Language.get("ADMIN_SERVER_OVERVIEW_CHECKING_FOR_UPDATES"));
            this.progressLabel = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_48);
            this.titleLabel.setFont(SHStyle.largeFont);
            this.titleLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.titleLabel.setHorizontalAlignment(0);
            int Y = 0;
            JLabel image = new JLabel(ImageLoader.getImageIcon((String)Icons.SH_LOGO_LARGE));
            image.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)15, (int)0));
            this.add(image, 0, Y++, 1, 1, 1, 0, 11, 2);
            this.add(line, 0, Y++, 1, 1, 1, 0, 11, 2);
            this.add(this.titleLabel, 0, Y++, 1, 1, 1, 0, 11, 2);
            this.add((Component)this.progressLabel, 0, Y++, 1, 1, 0, 1, 10, 3);
            this.add((Component)this.contentPanel, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
            this.add(new JPanel(), 0, Y++, 1, 1, 1, 1, 11, 1);
            SwingUtil.setHeight((JComponent)this.progressLabel, (int)SimpleHelpLookAndFeel.scale((int)130));
        }

        public void showError(Throwable t) {
            this.titleLabel.setText(" ");
            this.progressLabel.setVisible(false);
            IconAndText iconAndText = new IconAndText(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), Language.get("ADMIN_SERVER_OVERVIEW_ERROR"));
            SwingUtil.setWidth((JComponent)((Object)iconAndText), (int)SimpleHelpLookAndFeel.scale((int)200));
            iconAndText.setBackground(this.getBackground());
            int Y = 0;
            this.contentPanel.add((Component)((Object)iconAndText), 0, Y++, 1, 1, 1, 0, 11, 2);
            this.contentPanel.setVisible(true);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }

        public void showNewVersionExists(String ourVersion, String latestVersion, boolean canUpgradeForFree, String supportExpiryDate, boolean supportExpired) {
            this.titleLabel.setVisible(false);
            this.progressLabel.setVisible(false);
            FadedHorizontalLine line = new FadedHorizontalLine();
            SwingUtil.setWidth((JComponent)line, (int)SimpleHelpLookAndFeel.scale((int)400));
            JButton downloadNewVersion = new JButton(Language.get("DOWNLOAD_LATEST_VERSION"));
            downloadNewVersion.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Browser.openURL((URL)new URL("https://simple-help.com/downloads"));
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            IconAndText iconAndText = new IconAndText(ImageLoader.getImageIcon((String)"images/svg/computing/download.svg,48"), Language.get("ADMIN_SERVER_OVERVIEW_UPDATE_AVAILABLE"));
            iconAndText.setBackground(this.getBackground());
            JButton renewSupportButton = new JButton(Language.get("RENEW_SUPPORT"));
            renewSupportButton.addActionListener(this.renewActionListener);
            JWrapLabel supportLabel = new JWrapLabel();
            supportLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            if (!supportExpired) {
                supportLabel.setText("<html>" + Language.get("SUPPORT_EXPIRES_ON") + " " + supportExpiryDate + ".");
            } else {
                supportLabel.setText("<html>" + Language.get("SUPPORT_EXPIRED_ON") + " " + supportExpiryDate + ".");
            }
            int Y = 0;
            if (!canUpgradeForFree) {
                supportLabel.setText("<html>" + Language.get("RENEW_TO_UPGRADE_MSG"));
            }
            this.contentPanel.add((Component)((Object)iconAndText), 0, Y++, 2, 1, 1, 0, 11, 2);
            this.contentPanel.add((Component)downloadNewVersion, 0, Y++, 2, 1, 0, 0, 10, 0, (Insets)new ScaledInsets(10, 0, 0, 0));
            if (isTrial) {
                JLabel trialMessage = this.getTrialLabel();
                this.contentPanel.add((Component)trialMessage, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
            } else if (supportExpired) {
                this.contentPanel.add((Component)supportLabel, 0, Y, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
                this.contentPanel.add((Component)renewSupportButton, 1, Y++, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(20, 10, 0, 0));
            } else {
                this.contentPanel.add((Component)supportLabel, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
            }
            this.contentPanel.setBackground(this.getBackground());
            this.contentPanel.setVisible(true);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }

        public void showUpToDate(String ourVersion, boolean supportExpired, String supportExpiryDate) {
            this.titleLabel.setVisible(false);
            this.progressLabel.setVisible(false);
            FadedHorizontalLine line = new FadedHorizontalLine();
            SwingUtil.setWidth((JComponent)line, (int)SimpleHelpLookAndFeel.scale((int)400));
            IconAndText iconAndText = new IconAndText(ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), Language.get("ADMIN_SERVER_OVERVIEW_UPDATE_OK") + "<BR><span style='font-size:" + SimpleHelpLookAndFeel.scale((int)8) + "px'>" + ourVersion);
            SwingUtil.setWidth((JComponent)((Object)iconAndText), (int)SimpleHelpLookAndFeel.scale((int)200));
            iconAndText.setBackground(this.getBackground());
            JButton renewSupportButton = new JButton(Language.get("RENEW_SUPPORT"));
            renewSupportButton.addActionListener(this.renewActionListener);
            JWrapLabel supportLabel = new JWrapLabel();
            supportLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            if (!supportExpired) {
                supportLabel.setText("<html>" + Language.get("SUPPORT_EXPIRES_ON") + " " + supportExpiryDate + ".");
            } else {
                supportLabel.setText("<html>" + Language.get("SUPPORT_EXPIRED_ON") + " " + supportExpiryDate + ".");
            }
            int Y = 0;
            this.contentPanel.add((Component)((Object)iconAndText), 0, Y++, 2, 1, 1, 0, 11, 2);
            if (isTrial) {
                JLabel trialMessage = this.getTrialLabel();
                this.contentPanel.add((Component)trialMessage, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
            } else if (supportExpired) {
                this.contentPanel.add((Component)supportLabel, 0, Y, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(30, 0, 0, 0));
                this.contentPanel.add((Component)renewSupportButton, 1, Y++, 1, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(30, 10, 0, 0));
            } else {
                this.contentPanel.add((Component)supportLabel, 0, Y++, 1, 1, 1, 0, 11, 2, (Insets)new ScaledInsets(30, 0, 0, 0));
            }
            this.contentPanel.setBackground(this.getBackground());
            this.contentPanel.setVisible(true);
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }

        private JLabel getTrialLabel() {
            JLabel trialMessage = new JLabel(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
            trialMessage.setHorizontalAlignment(0);
            trialMessage.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            if (daysTillExpire <= 0) {
                trialMessage.setText(Language.get("ADMIN_LICENSE_TRIAL_EXPIRED"));
            } else {
                trialMessage.setText(Language.get("ADMIN_LICENSE_EXPIRES_IN") + " " + daysTillExpire + " " + Language.get("DAYS") + ".");
            }
            return trialMessage;
        }
    }

    class CheckVersionThread
    extends Thread {
        CheckVersionThread() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            boolean canUpgradeForFree = false;
            boolean runningLatestVersion = false;
            boolean supportExpired = false;
            String supportExpiryDate = null;
            String ourVersion = null;
            try {
                String latestVersion = SHUpdateCheckDialog.this.techClient.webserviceGetLatestVersion();
                ourVersion = Version.get() + "-" + Version.getBuildDate();
                if (latestVersion.equals(ourVersion) || !VersionUtil.isFullVersionLaterThan(ourVersion, latestVersion)) {
                    runningLatestVersion = true;
                } else {
                    int build;
                    runningLatestVersion = false;
                    String yyyyMMddLatest = latestVersion.split("-")[1];
                    if (license != null && (long)(build = Integer.parseInt(yyyyMMddLatest)) <= license.getOldestSupportFinishedDate()) {
                        canUpgradeForFree = true;
                    }
                }
                if (license != null) {
                    Date supportEndDate = new Date(license.getOldestSupportFinishedDate());
                    supportExpiryDate = DateFormat.getDateInstance(1).format(supportEndDate);
                    supportExpired = supportEndDate.getTime() < System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - start < 1000L) {
                    try {
                        Thread.sleep(1000L - (System.currentTimeMillis() - start));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (runningLatestVersion) {
                    SHUpdateCheckDialog.this.updateCheckPane.showUpToDate(ourVersion, supportExpired, supportExpiryDate);
                } else {
                    SHUpdateCheckDialog.this.updateCheckPane.showNewVersionExists(ourVersion, latestVersion, canUpgradeForFree, supportExpiryDate, supportExpired);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                SHUpdateCheckDialog.this.updateCheckPane.showError(t);
            }
        }
    }
}

