/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.apptunnel;

import com.aem.shelp.proxy.types.apptunnel.AppTunnelTarget;
import java.util.ArrayList;
import utils.message.Message;
import utils.ostools.OS;

public class AppTunnelSpecification {
    public static final byte VERSION = 0;
    private long creationTime;
    private int techID;
    private boolean pinned = false;
    public transient boolean pinnedStateChanged = false;
    private String title;
    private int remotePort;
    private String command;
    private boolean useCommand;
    private ArrayList<AppTunnelTarget> targets = new ArrayList();
    private static int testSpecCount = 0;

    public AppTunnelSpecification(int techID, String title, int port) {
        this.techID = techID;
        this.creationTime = System.currentTimeMillis();
        this.title = title;
        this.remotePort = port;
        this.command = "";
        this.useCommand = false;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setIsPinned(boolean pinned) {
        this.pinned = pinned;
        this.pinnedStateChanged = true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AppTunnelSpecification)) {
            return false;
        }
        AppTunnelSpecification specification = (AppTunnelSpecification)o;
        return this.techID == specification.techID && this.creationTime == specification.creationTime;
    }

    private AppTunnelSpecification() {
    }

    public Message toMessage() {
        Message m = new Message();
        m.append((byte)0);
        m.append(this.creationTime);
        m.append(this.techID);
        m.append(this.title);
        m.append(this.remotePort);
        m.append(this.command);
        m.append(this.useCommand);
        m.append(this.pinned);
        m.append(this.targets.size());
        for (AppTunnelTarget target : this.targets) {
            target.toMessage(m);
        }
        return m;
    }

    public static AppTunnelSpecification fromMessage(Message m) {
        AppTunnelSpecification spec = new AppTunnelSpecification();
        byte version = m.getNextByte();
        spec.creationTime = m.getNextLong();
        spec.techID = m.getNextInt();
        spec.title = m.getNextString();
        spec.remotePort = m.getNextInt();
        spec.command = m.getNextString();
        spec.useCommand = m.getNextBoolean();
        spec.pinned = m.getNextBoolean();
        int size = m.getNextInt();
        for (int i = 0; i < size; ++i) {
            AppTunnelTarget target = AppTunnelTarget.fromMessage(m, spec, version);
            spec.targets.add(target);
        }
        return spec;
    }

    public ArrayList<AppTunnelTarget> getTargets() {
        return this.targets;
    }

    public static AppTunnelSpecification createTestSpec() {
        AppTunnelSpecification spec = new AppTunnelSpecification();
        if (testSpecCount % 3 == 0) {
            spec.title = "Remote Desktop (RDP)";
            spec.remotePort = 123;
            spec.command = "rdp://${host}:${port}";
        } else if (testSpecCount % 3 == 1) {
            spec.title = "Secure Shell (SSH)";
            spec.remotePort = 22;
            spec.command = "ssh://${host}:${port}";
        } else {
            spec.title = "Web Browser";
            spec.remotePort = 80;
            if (OS.isWindows()) {
                spec.command = "start http://${host}:${port}";
            } else if (OS.isMacOS()) {
                spec.command = "open http://${host}:${port}";
            }
        }
        ++testSpecCount;
        AppTunnelTarget target = new AppTunnelTarget(spec, "localhost");
        spec.targets.add(target);
        target = new AppTunnelTarget(spec, "10.0.1.16");
        spec.targets.add(target);
        return spec;
    }

    public String getTitle() {
        return this.title;
    }

    public void addTarget(AppTunnelTarget target) {
        this.targets.add(target);
    }

    public void removeTarget(AppTunnelTarget target) {
        this.targets.remove(target);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getCommand() {
        return this.command;
    }

    public void setUseCommand(boolean useCommand) {
        this.useCommand = useCommand;
    }

    public boolean useCommand() {
        return this.useCommand;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

