/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.util.WReg;
import java.util.ArrayList;
import java.util.regex.Pattern;
import utils.message.Message;
import utils.message.TypedMap;
import utils.string.SimpleRegex;

public class WindowsRegistryThreshold
extends Alert {
    public static final Object ID = "RegistryTrigger";
    public static final int MODE_KEY_EXISTS = 0;
    public static final int MODE_VALUE_EXISTS = 1;
    public static final int MODE_VALUE_EQUALS = 2;
    private int mode = 0;
    private String registryKey;
    private String valueName = null;
    private String value = null;
    private boolean triggerIfExists = true;
    String matched;
    String reason;
    public static final String KEY_SUMMARY = "${CONTEXT_KEY_REGISTRY_VALUE}";

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public Alert createCorollary() {
        WindowsRegistryThreshold clone = (WindowsRegistryThreshold)this.cloneWithNewID();
        clone.mode = this.mode;
        clone.registryKey = this.registryKey;
        clone.valueName = this.valueName;
        clone.value = this.value;
        clone.triggerIfExists = !this.triggerIfExists;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_EVENT_REGISTRY";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_EVENT_REGISTRY_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/os/windows.svg,24";
    }

    @Override
    public String getDefaultName() {
        return Language.get("ALERT_EVENT_REGISTRY");
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.mode);
        m.append(this.registryKey);
        m.append(this.valueName);
        m.append(this.value);
        m.append(this.triggerIfExists);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.mode = m.getNextInt();
        this.registryKey = m.getNextString();
        this.valueName = m.getNextString();
        this.value = m.getNextString();
        this.triggerIfExists = m.getNextBoolean();
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    private void setTriggerBasedOnIfKeyExists(boolean keyOrValueExists) {
        if (keyOrValueExists) {
            this.setTriggeredState(this.triggerIfExists);
        } else {
            this.setTriggeredState(!this.triggerIfExists);
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_SUMMARY);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_SUMMARY, this.matched);
        return map;
    }

    @Override
    public void timePassed() {
        boolean keyExists = WReg.keyExists(this.registryKey);
        if (this.mode == 0 || !keyExists) {
            this.reason = keyExists ? "${REGISTRY_REASON_FOUND}" : "${REGISTRY_REASON_NOT_FOUND}";
            this.matched = null;
            this.setTriggerBasedOnIfKeyExists(keyExists);
        } else {
            boolean containsValue;
            String[] values = WReg.getChildren(this.registryKey)[1];
            String containedValue = this.containsValue(values, this.valueName);
            boolean bl = containsValue = containedValue != null;
            if (this.mode == 1 || !containsValue) {
                this.reason = containsValue ? "${REGISTRY_REASON_HAS_VALUE} (" + containedValue + ")" : "${REGISTRY_REASON_NO_VALUE}";
                this.matched = null;
                this.setTriggerBasedOnIfKeyExists(containsValue);
            } else {
                String result = WReg.getOrNull(this.registryKey, this.valueName);
                boolean valueIsEqual = result != null && this.valueMatches(result);
                this.reason = valueIsEqual ? "${REGISTRY_REASON_HAS_VALUE} (" + containedValue + ")" : "${REGISTRY_REASON_BAD_VALUE} (" + containedValue + ")";
                this.matched = containedValue;
                this.setTriggerBasedOnIfKeyExists(valueIsEqual);
            }
        }
    }

    private boolean valueMatches(String result) {
        if (result == null || this.value == null) {
            return false;
        }
        if (result.length() == 0 && this.value.length() == 0) {
            return true;
        }
        Pattern pattern = SimpleRegex.simpleToPattern(this.value, false);
        return pattern.matcher(result).matches();
    }

    private String containsValue(String[] values, String value) {
        if (value == null || values == null) {
            return null;
        }
        if (value.length() == 0) {
            for (String v : values) {
                if (v.length() != 0) continue;
                return v;
            }
            return null;
        }
        Pattern pattern = SimpleRegex.simpleToPattern(value, false);
        for (String v : values) {
            if (v == null || !pattern.matcher(v).matches()) continue;
            return v;
        }
        return null;
    }

    public boolean triggerIfMatchFound() {
        return this.triggerIfExists;
    }

    public void setTriggerIfMatch(boolean triggerIfExists) {
        this.triggerIfExists = triggerIfExists;
    }

    public void setKey(String key) {
        this.registryKey = key;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public void setValueData(String value) {
        this.value = value;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public String getRegistryKey() {
        return this.registryKey;
    }

    public String getValueName() {
        return this.valueName;
    }

    public String getValue() {
        return this.value;
    }
}

