/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.TypedMap;

public class WebsiteResponseTimeThreshold
extends Alert {
    public static final Object ID = "WebsiteResponseTimeTrigger";
    String site = "";
    long responseTimeMS = 5000L;
    boolean over = true;
    String connect;
    String read;
    String reason;
    public static final String KEY_CONNECT_MS = "${CONTEXT_KEY_WEB_CONNECT_MS}";
    public static final String KEY_READ_MS = "${CONTEXT_KEY_WEB_READ_MS}";
    private long lastChecked = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_NET_WEBRT_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_NET_WEBRT_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/network.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/clock-simple.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_WEBRT_OVER", this.site, this.getResponseTimeSecs() + "s");
        }
        return Language.get("ALERT_WEBRT_UNDER", this.site, this.getResponseTimeSecs() + "s");
    }

    private double getResponseTimeSecs() {
        return (double)this.responseTimeMS / 1000.0;
    }

    @Override
    public Alert createCorollary() {
        WebsiteResponseTimeThreshold clone = (WebsiteResponseTimeThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    public void setTriggerOn(String site, long responseTime, boolean over) {
        this.site = site;
        this.over = over;
        this.responseTimeMS = responseTime;
    }

    public String getSite() {
        return this.site;
    }

    public long getResponseTimeMS() {
        return this.responseTimeMS;
    }

    public boolean getTriggerIfOver() {
        return this.over;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.site);
        m.append(this.responseTimeMS);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.site = m.getNextString();
        this.responseTimeMS = m.getNextLong();
        this.over = m.getNextBoolean();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_CONNECT_MS);
        keys.add(KEY_READ_MS);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_CONNECT_MS, this.connect);
        map.setString(KEY_READ_MS, this.read);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePassed() {
        long now = SafeClock.currentTimeMillis();
        long actualMs = 0L;
        if (now - this.lastChecked > 60000L) {
            this.lastChecked = now;
            if (CentralDebugging.ALERT_WEBSITE_RESPONSE) {
                System.out.println("[WebsiteResponseThreshold] Checking now - more than 20s since last check.");
            }
            boolean overlimit = false;
            try {
                long T = SafeClock.currentTimeMillis();
                long ms = SafeClock.currentTimeMillis();
                URL url = new URL(this.site);
                InputStream in = url.openStream();
                ms = SafeClock.currentTimeMillis() - ms;
                this.connect = ms + "";
                try {
                    if (CentralDebugging.ALERT_WEBSITE_RESPONSE) {
                        System.out.println("[WebsiteResponseThreshold] Connection made. Reading input stream.");
                    }
                    ms = SafeClock.currentTimeMillis();
                    byte[] buf = new byte[50000];
                    while (in.read(buf) != -1) {
                    }
                    ms = SafeClock.currentTimeMillis() - ms;
                    this.read = ms + "";
                }
                finally {
                    FileUtil.robustClose((InputStream)in);
                }
                if (CentralDebugging.ALERT_WEBSITE_RESPONSE) {
                    System.out.println("[WebsiteResponseThreshold] Connection closed - measured response time of " + (SafeClock.currentTimeMillis() - T));
                }
                if ((actualMs = SafeClock.currentTimeMillis() - T) > this.responseTimeMS) {
                    if (CentralDebugging.ALERT_WEBSITE_RESPONSE) {
                        System.out.println("[WebsiteResponseThreshold] Over limit of " + this.responseTimeMS);
                    }
                    overlimit = true;
                } else if (CentralDebugging.ALERT_WEBSITE_RESPONSE) {
                    System.out.println("[WebsiteResponseThreshold] Under limit of " + this.responseTimeMS);
                }
            }
            catch (Exception x) {
                return;
            }
            this.reason = overlimit ? "${ALERT_WEB_RESPONSE_TIME} " + actualMs + "ms > " + this.responseTimeMS + "ms" : "${ALERT_WEB_RESPONSE_TIME} " + actualMs + "ms < " + this.responseTimeMS + "ms";
            boolean state = false;
            if (overlimit && this.over) {
                state = true;
            }
            if (!overlimit && !this.over) {
                state = true;
            }
            this.updateTriggeredState(state);
        }
    }
}

