/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.av.SecurityProduct;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;

public class FirewallThreshold
extends Alert {
    public static final Object ID = "FirewallTrigger";
    boolean triggerIfMissing = true;
    public static final String KEY_FIREWALL = "${CONTEXT_KEY_FILE_FIREWALL}";
    String firewallName;
    long transientT = 0L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public Alert createCorollary() {
        FirewallThreshold clone = (FirewallThreshold)this.cloneWithNewID();
        clone.triggerIfMissing = !clone.triggerIfMissing;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_PROC_FW_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_PROC_FW_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/window.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/accessdenied.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.triggerIfMissing) {
            return Language.get("ALERT_FW_NOTVERIFIED");
        }
        return Language.get("ALERT_FW_VERIFIED");
    }

    public void setTriggerIfMissing(boolean b) {
        this.triggerIfMissing = b;
    }

    public boolean getTriggerIfMissing() {
        return this.triggerIfMissing;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.triggerIfMissing);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.triggerIfMissing = m.getNextBoolean();
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_FIREWALL);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_FIREWALL, this.firewallName);
        return map;
    }

    @Override
    public String getReason() {
        if (this.firewallName == null) {
            return "${NO_FIREWALL_FOUND}";
        }
        return "${FIREWALL_FOUND} " + this.firewallName;
    }

    @Override
    public void securityStats(ArrayList<SecurityProduct> secs) {
        if (OS.isWindows()) {
            boolean foundAndOk = false;
            for (SecurityProduct sec : secs) {
                if (!sec.isFirewall() || !sec.isActive() || !sec.isUpToDate()) continue;
                foundAndOk = true;
                this.firewallName = sec.getName();
            }
            if (foundAndOk) {
                if (!this.triggerIfMissing) {
                    this.updateTriggeredState(true);
                } else {
                    this.updateTriggeredState(false);
                }
            } else {
                this.firewallName = null;
                if (this.triggerIfMissing) {
                    this.updateTriggeredState(true);
                } else {
                    this.updateTriggeredState(false);
                }
            }
        }
    }

    @Override
    public void timePassed() {
        block10: {
            if (OS.isMacOS()) {
                if (SafeClock.currentTimeMillis() - this.transientT > 30000L) {
                    try {
                        String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"defaults", "read", "/Library/Preferences/com.apple.alf", "globalstate"})[0];
                        output = output.trim();
                        int state = Integer.parseInt(output);
                        if (state == 0) {
                            if (this.triggerIfMissing) {
                                this.updateTriggeredState(true);
                            } else {
                                this.updateTriggeredState(false);
                            }
                            break block10;
                        }
                        if (this.triggerIfMissing) {
                            this.updateTriggeredState(false);
                            break block10;
                        }
                        this.updateTriggeredState(true);
                    }
                    catch (Exception exception) {}
                }
            } else if (OS.isLinux()) {
                this.updateTriggeredState(false);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new FirewallThreshold().timePassed();
    }
}

