/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import utils.message.Message;
import utils.message.TypedMap;

public class FileModifiedThreshold
extends Alert {
    public static final Object ID = "FileModifiedTrigger";
    String reason;
    String path = null;
    long maxAgeMS = 3600000L;
    boolean older;
    public static final String KEY_TIME = "${CONTEXT_KEY_FILE_MODTIME}";
    long modtime = -99L;

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_FILE_MOD_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_FILE_MOD_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/clock-simple.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.older) {
            return Language.get("ALERT_FILE_OLDER", "" + (double)this.maxAgeMS / 60000.0);
        }
        return Language.get("ALERT_FILE_NEWER", "" + (double)this.maxAgeMS / 60000.0);
    }

    @Override
    public Alert createCorollary() {
        FileModifiedThreshold clone = (FileModifiedThreshold)this.cloneWithNewID();
        clone.older = !clone.older;
        return clone;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public void setTriggerOn(String path, long maxAgeMS, boolean older) {
        this.path = path;
        this.maxAgeMS = maxAgeMS;
        this.older = older;
    }

    public String getFilePath() {
        return this.path;
    }

    public long getThresholdMS() {
        return this.maxAgeMS;
    }

    public boolean getTriggerIfOlder() {
        return this.older;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.path);
        m.append(this.maxAgeMS);
        m.append(this.older);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.path = m.getNextString();
        this.maxAgeMS = m.getNextLong();
        this.older = m.getNextBoolean();
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_TIME);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_TIME, "" + this.modtime);
        return map;
    }

    @Override
    public void timePassed() {
        boolean state;
        File f = new File(this.path);
        if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
            System.out.println("[FileModifiedThreshold] Checking last modified for " + f.getAbsolutePath());
        }
        long lastMod = 0L;
        if (!f.exists()) {
            state = false;
            this.reason = "${FILE} " + f.getName() + " ${DOES_NOT_EXIST}";
            if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                System.out.println("[FileModifiedThreshold] File does not exist (reset)");
            }
            this.modtime = 0L;
        } else {
            this.modtime = lastMod = f.lastModified();
            if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                System.out.println("[FileModifiedThreshold] Current last modified is " + lastMod + " fileExists:" + f.exists());
            }
            boolean fileOlder = System.currentTimeMillis() - lastMod > this.maxAgeMS;
            long secs = System.currentTimeMillis() - lastMod;
            secs /= 1000L;
            this.reason = "${FILE} " + f.getName() + " ${WAS_MODIFIED} " + new Date(lastMod) + " ${COMPARED_TO} " + new Date();
            if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                System.out.println("[FileModifiedThreshold] File older than " + this.maxAgeMS + ": " + fileOlder);
            }
            if (fileOlder && this.older) {
                state = true;
                if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                    System.out.println("[FileModifiedThreshold] Triggered 1 (" + fileOlder + "," + this.older + ")");
                }
            } else if (!fileOlder && !this.older) {
                state = true;
                if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                    System.out.println("[FileModifiedThreshold] Triggered 2 (" + fileOlder + "," + this.older + ")");
                }
            } else {
                state = false;
                if (CentralDebugging.ALERT_FILE_MODIFIED_DEBUG) {
                    System.out.println("[FileModifiedThreshold] Reset (" + fileOlder + "," + this.older + ")");
                }
            }
        }
        this.updateTriggeredState(state);
    }
}

