/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.TypedMap;

public class FileLengthThreshold
extends Alert {
    public static final Object ID = "FileLengthTrigger";
    String reason;
    String path = null;
    long maxKB = 1000L;
    boolean over;
    public static final String KEY_LEN = "${CONTEXT_KEY_FILE_LENGTH}";
    long fileSize = -99L;
    DecimalFormat df = new DecimalFormat("###,###,###,###,###,###,##0");

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_FILE_LENGTH_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_FILE_LENGTH_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/files-folders/files.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/compass-measure.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.over) {
            return Language.get("ALERT_FILE_LARGER", this.maxKB + "kb");
        }
        return Language.get("ALERT_FILE_SMALLER", this.maxKB + "kb");
    }

    @Override
    public Alert createCorollary() {
        FileLengthThreshold clone = (FileLengthThreshold)this.cloneWithNewID();
        clone.over = !clone.over;
        return clone;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public void setTriggerOnFileLength(String path, long maxKB, boolean over) {
        this.path = path;
        this.maxKB = maxKB;
        this.over = over;
    }

    public boolean getTriggerIfOver() {
        return this.over;
    }

    public String getFilePath() {
        return this.path;
    }

    public long getThresholdKB() {
        return this.maxKB;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.path);
        m.append(this.maxKB);
        m.append(this.over);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.path = m.getNextString();
        this.maxKB = m.getNextLong();
        this.over = m.getNextBoolean();
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_LEN);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_LEN, "" + this.fileSize);
        return map;
    }

    @Override
    public void timePassed() {
        File f = new File(this.path);
        long len = 0L;
        if (f.exists()) {
            len = f.length();
        }
        this.fileSize = len;
        boolean fileBigger = len > this.maxKB * 1024L;
        this.reason = fileBigger ? "${CFILE} " + f.getName() + " ${SIZE} " + this.df.format(len) + " > " + this.df.format(this.maxKB * 1024L) : "${CFILE} " + f.getName() + " ${SIZE} " + this.df.format(len) + " < " + this.df.format(this.maxKB * 1024L);
        boolean state = fileBigger && this.over ? true : !fileBigger && !this.over;
        this.updateTriggeredState(state);
    }
}

