/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts.threshold;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;

public class DiskHealthThreshold
extends Alert {
    public static final Object ID = "DiskHealthTrigger";
    boolean triggerIfBroken = true;
    long lastCheck = 0L;
    String matched;
    String reason;
    public static final String KEY_MATCHED = "${CONTEXT_KEY_MATCHED_DISK}";

    @Override
    public Alert createCorollary() {
        DiskHealthThreshold clone = (DiskHealthThreshold)this.cloneWithNewID();
        clone.triggerIfBroken = !clone.triggerIfBroken;
        return clone;
    }

    @Override
    public String getTypeNameKey() {
        return "ALERT_DISK_HEALTH_NAME";
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    @Override
    public String getTypeDescKey() {
        return "ALERT_DISK_HEALTH_DESC";
    }

    @Override
    public String getTypeIconKey() {
        return "images/svg/computing/database.svg,48";
    }

    @Override
    public String getTypeOverlayKey() {
        return "images/svg/general/heartbeat.svg,24";
    }

    @Override
    public String getDefaultName() {
        if (this.triggerIfBroken) {
            return Language.get("ALERT_DISK_BAD");
        }
        return Language.get("ALERT_DISK_OK");
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.triggerIfBroken);
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.triggerIfBroken = m.getNextBoolean();
    }

    public void setTriggerIfBroken(boolean b) {
        this.triggerIfBroken = b;
    }

    public boolean getTriggerIfBroken() {
        return this.triggerIfBroken;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    private static String[] getOSXDiskList(boolean justPhysicalDrives) {
        String[] lines;
        ArrayList<String> disks = new ArrayList<String>();
        String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"diskutil", "list"})[0];
        for (String line : lines = output.split("\n")) {
            boolean isphysical = line != null && line.indexOf("physical") != -1;
            if (!(line = line.trim()).startsWith("/")) continue;
            int space = line.indexOf(32);
            if (space != -1) {
                line = line.substring(0, space);
            }
            if (justPhysicalDrives && !isphysical) continue;
            disks.add(line);
        }
        return disks.toArray(new String[0]);
    }

    public static void main(String[] args) {
        String[] drives;
        for (String d : drives = DiskHealthThreshold.getOSXDiskList(true)) {
            String[] lines;
            String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"diskutil", "info", d})[0];
            if (output.indexOf("Device") == -1 && output.indexOf("/dev") == -1) continue;
            for (String line : lines = output.split("\n")) {
                if (!(line = line.trim()).startsWith("SMART")) continue;
                line = line.substring(line.lastIndexOf(58) + 1);
                if ((line = line.trim()).equalsIgnoreCase("verified") || line.equalsIgnoreCase("not supported")) {
                    System.out.println("[DiskHealth] Disk " + d + " reported as verified");
                    continue;
                }
                System.out.println("[DiskHealth] Disk " + d + " reported as " + line);
            }
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_MATCHED);
        return keys;
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = new TypedMap();
        map.setString(KEY_MATCHED, this.matched);
        return map;
    }

    @Override
    public void timePassed() {
        if (SafeClock.currentTimeMillis() > this.lastCheck + 180000L) {
            this.lastCheck = SafeClock.currentTimeMillis();
            boolean somethingBroken = false;
            if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                System.out.println("[DiskHealthThreshold] Checking disk health...");
            }
            if (OS.isMacOS()) {
                String[] drives;
                for (String d : drives = DiskHealthThreshold.getOSXDiskList(true)) {
                    String[] lines;
                    String output = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"diskutil", "info", d})[0];
                    if (!output.contains("Device") && !output.contains("/dev")) continue;
                    for (String line : lines = output.split("\n")) {
                        if (!(line = line.trim()).startsWith("SMART")) continue;
                        line = line.substring(line.lastIndexOf(58) + 1);
                        line = line.trim();
                        if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                            System.out.println("[DiskHealthThreshold] [Fine] OS X reports a disk (" + d + ") with status: " + line);
                        }
                        if (line.equalsIgnoreCase("verified") || line.equalsIgnoreCase("not supported")) continue;
                        System.out.println("[DiskHealth] Disk " + d + " reported as " + line);
                        if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                            System.out.println("[DiskHealthThreshold] [Issue] OS X reports a disk (" + d + ") with status: " + line);
                        }
                        somethingBroken = true;
                        this.matched = d;
                        this.reason = "${UNHEALTHY_DISK_FOUND} " + this.matched;
                    }
                }
            } else if (OS.isWindows()) {
                WMIResults wmiResults = WMIRegistry.getProvider().queryWMI("SELECT Status,Name,Description,Caption,DeviceID,Model,Manufacturer,SerialNumber,InterfaceType,ErrorDescription from Win32_DiskDrive");
                if (wmiResults.hasProperties()) {
                    Properties[] rows = wmiResults.getProperties();
                    if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                        System.out.println("[DiskHealthThreshold] " + rows.length + " disk drive metrics returned.");
                    }
                    for (Properties row : rows) {
                        String rowStatus;
                        if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                            System.out.println("[DiskHealthThreshold] Row: " + row);
                        }
                        if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                            Object[] keys = row.keySet().toArray();
                            Arrays.sort(keys);
                            StringBuffer sb = new StringBuffer();
                            for (Object key : keys) {
                                String value = row.getProperty((String)key);
                                sb.append(key).append('=').append(value).append("\n");
                            }
                            System.out.println("[DiskHealthThreshold] " + sb.toString());
                        }
                        if ((rowStatus = row.getProperty("Status")) == null || rowStatus.length() <= 0 || rowStatus.trim().toLowerCase().startsWith("ok")) continue;
                        somethingBroken = true;
                        Object[] keys = row.keySet().toArray();
                        Arrays.sort(keys);
                        StringBuffer sb = new StringBuffer();
                        for (Object key : keys) {
                            String value = row.getProperty((String)key);
                            sb.append(key).append('=').append(value).append("\n");
                        }
                        this.matched = sb.toString();
                        this.reason = "${UNHEALTHY_DISK_FOUND} " + this.matched;
                        if (!CentralDebugging.ALERT_DISK_HEALTH_DEBUG) continue;
                        System.out.println("[DiskHealthThreshold] Windows reported a disk issue");
                    }
                } else if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                    System.out.println("[DiskHealthThreshold] No disk drive metrics returned");
                }
                if (!somethingBroken) {
                    this.matched = null;
                    this.reason = "${NO_UNHEALTHY_DISK_FOUND}";
                }
            }
            if (CentralDebugging.ALERT_DISK_HEALTH_DEBUG) {
                System.out.println("[DiskHealthThreshold] Final state is somethingBroken:" + somethingBroken + " triggerIfBroken:" + this.triggerIfBroken);
            }
            if (this.triggerIfBroken) {
                if (somethingBroken) {
                    this.updateTriggeredState(true);
                } else {
                    this.updateTriggeredState(false);
                }
            } else if (somethingBroken) {
                this.updateTriggeredState(false);
            } else {
                this.updateTriggeredState(true);
            }
        }
    }
}

