/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alerts;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertInput;
import com.aem.shelp.proxy.types.TrackedAlert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.Stats;
import utils.osstats.av.SecurityProduct;
import utils.progtools.Counter;
import utils.swing.customlaf.SHStyle;
import utils.swing.images.ColorUtils;

public class BasicAlert
extends Alert
implements TrackedAlert,
AlertInput {
    public static final String ID = "BasicAlert";
    public static String KEY_OVERALL_REASON = "${CONTEXT_KEY_REASON}";
    public static String KEY_SHORT_REASON = "${CONTEXT_KEY_SHORT_REASON}";
    TypedMap context = new TypedMap();
    long instantaneousStateTime = SafeClock.currentTimeMillis();
    boolean instantaneousState = false;
    boolean triggerIntraGroupsAND = false;
    boolean resetIntraGroupsAND = false;
    ArrayList<ArrayList<Alert>> triggerIDs = new ArrayList();
    ArrayList<ArrayList<Alert>> resetIDs = new ArrayList();
    long triggerMS = 30000L;
    long resetMS = 30000L;
    static Object states_LOCK = new Object();
    static HashMap<String, Boolean> states = new HashMap();
    static HashMap<String, TypedMap> contexts = new HashMap();
    static HashMap<String, String> reasons = new HashMap();

    public BasicAlert() {
        if (!Alert.isReadOnly()) {
            this.setActive(false);
        }
    }

    @Override
    public String getReason() {
        return this.context.getString(KEY_OVERALL_REASON);
    }

    @Override
    public String getShortReason() {
        return this.context.getString(KEY_SHORT_REASON);
    }

    @Override
    public TypedMap getContext() {
        TypedMap map = TypedMap.fromMessage((Message)this.context.toMessage());
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert sub = it.next();
            TypedMap submap = this.getContextFor(sub.getID());
            ArrayList keys = submap.getAllKeys();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String origkey = key = (String)iterator.next();
                int addon = 1;
                if (map.contains(key)) {
                    while (map.contains(key + "." + addon)) {
                        ++addon;
                    }
                    key = key + "." + addon;
                }
                map.setString(key, submap.getString(origkey));
            }
        }
        return map;
    }

    @Override
    public ArrayList<String> getContextKeys() {
        Counter dups = new Counter();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(KEY_OVERALL_REASON);
        for (ArrayList<Alert> triggers : this.triggerIDs) {
            for (Alert alert : triggers) {
                ArrayList<String> subkeys = alert.getContextKeys();
                for (String subkey : subkeys) {
                    int index = dups.getInt((Object)subkey, 0);
                    dups.add((Object)subkey, 1.0);
                    if (index == 0) {
                        keys.add(subkey);
                        continue;
                    }
                    keys.add(subkey + "." + index);
                }
            }
        }
        return keys;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString(indent));
        this.indent(sb, indent).append("  Trigger time : " + this.triggerMS).append('\n');
        this.indent(sb, indent).append("  Trigger logic : " + (this.triggerIntraGroupsAND ? "AND" : "OR")).append('\n');
        for (ArrayList<Alert> group : this.triggerIDs) {
            this.indent(sb, indent).append("  Trigger threshold Group (" + group.size() + ")").append('\n');
            for (Alert trigger : group) {
                if (!(trigger instanceof Alert)) continue;
                sb.append(trigger.toString(indent + 4)).append('\n');
            }
        }
        this.indent(sb, indent).append("  Reset time : " + this.resetMS).append('\n');
        this.indent(sb, indent).append("  Reset logic : " + (this.resetIntraGroupsAND ? "AND" : "OR")).append('\n');
        for (ArrayList<Alert> group : this.resetIDs) {
            this.indent(sb, indent).append("  Reset threshold Group (" + group.size() + ")").append('\n');
            for (Alert reset : group) {
                if (!(reset instanceof Alert)) continue;
                sb.append(reset.toString(indent + 4)).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public void storeTriggeredStateInto(HashMap<String, Alert> store) {
        super.storeTriggeredStateInto(store);
        HashMap<String, Alert> mine = this.getSubAlertsMap();
        for (String id : mine.keySet()) {
            Alert myAlert = mine.get(id);
            myAlert.storeTriggeredStateInto(store);
        }
    }

    @Override
    public void initialiseNewTriggeredState() {
        super.initialiseNewTriggeredState();
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[StateCopy][BasicAlert] " + this.getName() + " initialising triggered state for self and thresholds as new");
        }
        this.instantaneousState = false;
        this.instantaneousStateTime = 0L;
        HashMap<String, Alert> mine = this.getSubAlertsMap();
        Iterator<Alert> it = mine.values().iterator();
        while (it.hasNext()) {
            it.next().initialiseNewTriggeredState();
        }
    }

    @Override
    public void copyTriggeredStateFrom(Alert alert) {
        super.copyTriggeredStateFrom(alert);
        BasicAlert ba = (BasicAlert)alert;
        this.instantaneousStateTime = ba.instantaneousStateTime;
        this.instantaneousState = ba.instantaneousState;
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[StateCopy][BasicAlert] " + this.getName() + " Instantaneous state is " + this.instantaneousState);
        }
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[StateCopy][BasicAlert] " + this.getName() + " Instantaneous state time is T-" + (SafeClock.currentTimeMillis() - ba.instantaneousStateTime));
        }
        if (CentralDebugging.ALERT_STATE_VERBOSE) {
            System.out.println("[StateCopy][BasicAlert] " + this.getName() + " Triggered state is " + this.isTriggered());
        }
        HashMap<String, Alert> mine = this.getSubAlertsMap();
        HashMap<String, Alert> theirs = ((BasicAlert)alert).getSubAlertsMap();
        for (String id : mine.keySet()) {
            Alert theirAlert = theirs.get(id);
            if (theirAlert == null) continue;
            Alert myAlert = mine.get(id);
            myAlert.copyTriggeredStateFrom(theirAlert);
            if (!CentralDebugging.ALERT_STATE_VERBOSE) continue;
            System.out.println("[StateCopy][BasicAlert] " + this.getName() + " threshold " + myAlert.getName() + " state is " + myAlert.isTriggered() + " vs " + BasicAlert.getStateOf(myAlert.getID()) + " in state map");
        }
    }

    private HashMap<String, Alert> getSubAlertsMap() {
        HashMap<String, Alert> map = new HashMap<String, Alert>();
        for (ArrayList<Alert> triggers : this.triggerIDs) {
            for (Alert alert : triggers) {
                map.put(alert.getID(), alert);
            }
        }
        for (ArrayList<Alert> resets : this.resetIDs) {
            for (Alert alert : resets) {
                map.put(alert.getID(), alert);
            }
        }
        return map;
    }

    @Override
    public ArrayList<Alert> getAllSubAlerts() {
        ArrayList<Alert> tmp = new ArrayList<Alert>();
        for (ArrayList<Alert> triggers : this.triggerIDs) {
            for (Alert alert : triggers) {
                tmp.add(alert);
            }
        }
        for (ArrayList<Alert> resets : this.resetIDs) {
            for (Alert alert : resets) {
                tmp.add(alert);
            }
        }
        return tmp;
    }

    public void setTrigger(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> triggers, long ms) {
        this.triggerIntraGroupsAND = intraGroupsAND;
        this.triggerIDs = triggers;
        this.triggerMS = ms;
    }

    public void setReset(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> resets, long ms) {
        this.resetIntraGroupsAND = intraGroupsAND;
        this.resetIDs = resets;
        this.resetMS = ms;
    }

    public static void main(String[] args) throws Exception {
        CentralDebugging.ALERT_BASIC_ALERT_LOGIC = true;
        CentralDebugging.ALERT_BASIC_ALERT = true;
        BasicAlert ba = new BasicAlert();
        ba.setName("BASIC");
        FakeAlert f1 = new FakeAlert();
        FakeAlert f2 = new FakeAlert();
        f1.setName("TRIG-1");
        f2.setName("RESET-1");
        ArrayList<ArrayList<Alert>> trigs = new ArrayList<ArrayList<Alert>>();
        ArrayList<ArrayList<Alert>> resets = new ArrayList<ArrayList<Alert>>();
        ArrayList<FakeAlert> a1 = new ArrayList<FakeAlert>();
        ArrayList<FakeAlert> a2 = new ArrayList<FakeAlert>();
        a1.add(f1);
        a2.add(f2);
        trigs.add(a1);
        resets.add(a2);
        ba.setTrigger(true, trigs, 10L);
        ba.setReset(true, resets, 10L);
        ba.alertTriggered(f1);
        Thread.sleep(100L);
        ba.timePassed();
        ba.alertReset(f1);
        ba.alertTriggered(f2);
        Thread.sleep(100L);
        ba.timePassed();
    }

    public long getTriggerTimeMS() {
        return this.triggerMS;
    }

    public long getResetTimeMS() {
        return this.resetMS;
    }

    public boolean getTriggerIntraGroupsAND() {
        return this.triggerIntraGroupsAND;
    }

    public boolean getResetIntraGroupsAND() {
        return this.resetIntraGroupsAND;
    }

    public ArrayList<ArrayList<Alert>> getTriggers() {
        return this.triggerIDs;
    }

    public ArrayList<ArrayList<Alert>> getResets() {
        return this.resetIDs;
    }

    private AlertIterator getIt() {
        return new AlertIterator(this.triggerIDs, this.resetIDs);
    }

    private Alert getAlertById(String id) {
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert alert = it.next();
            if (!alert.getID().equals(id)) continue;
            return alert;
        }
        return null;
    }

    private String getReasonFor(String id) {
        Alert alert;
        String reason = reasons.get(id);
        if (reason == null && (reason = (alert = this.getAlertById(id)).getReason()) == null) {
            reason = alert.getName() + " ${ALERT_CONTEXT_NODATA}";
        }
        return reason;
    }

    private TypedMap getContextFor(String id) {
        TypedMap map = contexts.get(id);
        if (map == null) {
            Alert alert = this.getAlertById(id);
            map = alert.getContext();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getStateOf(String id) {
        Boolean b;
        Object object = states_LOCK;
        synchronized (object) {
            b = states.get(id);
        }
        if (b == null) {
            return false;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setStateOf(String id, boolean triggered, TypedMap context, String reason) {
        Object object = states_LOCK;
        synchronized (object) {
            states.put(id, triggered);
            contexts.put(id, context);
            reasons.put(id, reason);
        }
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        Message triga = m.getNextMessage();
        this.triggerMS = triga.getNextLong();
        this.triggerIntraGroupsAND = triga.getNextBoolean();
        this.triggerIDs = this.listFromMessage(triga.getNextMessage());
        Message reset = m.getNextMessage();
        this.resetMS = reset.getNextLong();
        this.resetIntraGroupsAND = reset.getNextBoolean();
        this.resetIDs = this.listFromMessage(reset.getNextMessage());
        for (ArrayList<Alert> list : this.triggerIDs) {
            for (Alert alert : list) {
                alert.setParent(this);
            }
        }
        for (ArrayList<Alert> list : this.resetIDs) {
            for (Alert alert : list) {
                alert.setParent(this);
            }
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        Message triga = new Message();
        triga.append(this.triggerMS);
        triga.append(this.triggerIntraGroupsAND);
        triga.append(this.listToMessage(this.triggerIDs));
        Message reset = new Message();
        reset.append(this.resetMS);
        reset.append(this.resetIntraGroupsAND);
        reset.append(this.listToMessage(this.resetIDs));
        m.append(triga);
        m.append(reset);
    }

    private ArrayList<ArrayList<Alert>> listFromMessage(Message m) {
        ArrayList<ArrayList<Alert>> groups = new ArrayList<ArrayList<Alert>>();
        while (m.hasNext()) {
            Message group = m.getNextMessage();
            ArrayList<Alert> list = new ArrayList<Alert>();
            while (group.hasNext()) {
                Message alert = group.getNextMessage();
                list.add(ResourceSerialiser.alertFromMessage(alert));
            }
            if (list.size() <= 0) continue;
            groups.add(list);
        }
        return groups;
    }

    private Message listToMessage(ArrayList<ArrayList<Alert>> ids) {
        Message groups = new Message();
        for (ArrayList<Alert> list : ids) {
            Message group = new Message();
            for (Alert alert : list) {
                group.append(ResourceSerialiser.alertToMessage(alert));
            }
            if (group.length() <= 0) continue;
            groups.append(group);
        }
        return groups;
    }

    @Override
    public boolean isServerSideOnly() {
        return false;
    }

    @Override
    public void alertReset(Alert sub) {
        boolean isMine = false;
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert child = it.next();
            if (sub.getID().equals(child.getID())) {
                isMine = true;
            }
            child.alertReset(sub);
        }
        if (isMine && CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] Threshold " + this.getName() + "/" + sub.getName() + " notified state is OFF (reset)");
        }
        BasicAlert.setStateOf(sub.getID(), false, sub.getContext(), sub.getReason());
        this.updateMyState();
    }

    @Override
    public void alertTriggered(Alert sub) {
        boolean isMine = false;
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert child = it.next();
            if (sub.getID().equals(child.getID())) {
                isMine = true;
            }
            child.alertTriggered(sub);
        }
        if (isMine && CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] Threshold " + this.getName() + "/" + sub.getName() + " notified state is ON (triggered)");
        }
        BasicAlert.setStateOf(sub.getID(), true, sub.getContext(), sub.getReason());
        this.updateMyState();
    }

    private boolean getGroupState(boolean intraGroupsAND, ArrayList<Alert> ids, StringBuffer reason, StringBuffer shortReason) {
        boolean all = true;
        boolean any = false;
        for (Alert id : ids) {
            reason.append("-- " + this.getReasonFor(id.getID()) + "\n");
            shortReason.append(this.getReasonFor(id.getID()) + "\n");
            if (BasicAlert.getStateOf(id.getID())) {
                if (CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS) {
                    System.out.println("[BasicAlert] " + this.getName() + " state of child " + id.getName() + " is triggered");
                }
                any = true;
                continue;
            }
            if (CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS) {
                System.out.println("[BasicAlert] " + this.getName() + " state of child " + id.getName() + " is reset");
            }
            all = false;
        }
        boolean groupState = intraGroupsAND ? all : any;
        return groupState;
    }

    private boolean getExpressionState(boolean intraGroupsAND, ArrayList<ArrayList<Alert>> list, StringBuffer alertReason, StringBuffer shortReason, boolean triggerGroup) {
        boolean stateTriggered = false;
        boolean groupsAll = true;
        boolean groupsAny = false;
        StringBuffer reason = new StringBuffer();
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Begin (intraGroupsAND=" + intraGroupsAND + ")");
        }
        int index = 0;
        for (ArrayList<Alert> ids : list) {
            if (list.size() > 0) {
                reason.append("- ");
                if (intraGroupsAND) {
                    if (index > 0) {
                        reason.append("${ALERT_CONTEXT_OR}");
                    }
                    reason.append("${ALERT_CONTEXT_ALL}\n");
                } else {
                    if (index > 0) {
                        reason.append("${ALERT_CONTEXT_AND}");
                    }
                    reason.append("${ALERT_CONTEXT_ANY}\n");
                }
            }
            if (this.getGroupState(intraGroupsAND, ids, reason, shortReason)) {
                if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                    System.out.println("[AlExpState] Group ON");
                }
                groupsAny = true;
            } else {
                if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                    System.out.println("[AlExpState] Group OFF");
                }
                groupsAll = false;
            }
            ++index;
        }
        if (intraGroupsAND) {
            if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                System.out.println("[AlExpState] Expression is AND within groups, OR across groups");
            }
            stateTriggered = groupsAny;
        } else {
            if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
                System.out.println("[AlExpState] Expression is OR within groups, AND across groups");
            }
            stateTriggered = groupsAll;
        }
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Returning " + stateTriggered);
        }
        String overallReason = "";
        overallReason = triggerGroup ? (stateTriggered ? this.getName() + " ${ALERT_CONTEXT_TRIGGER}" : this.getName() + " ${ALERT_CONTEXT_RESET}") : (stateTriggered ? this.getName() + " ${ALERT_CONTEXT_RESET}" : this.getName() + " ${ALERT_CONTEXT_TRIGGER}");
        overallReason = overallReason + "\n" + reason.toString();
        alertReason.append(overallReason);
        return stateTriggered;
    }

    private void updateMyState() {
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Init " + this.triggerIDs.size() + " trigger groups");
        }
        if (CentralDebugging.ALERT_BASIC_ALERT_LOGIC) {
            System.out.println("[AlExpState] Init " + this.resetIDs.size() + " reset groups");
        }
        StringBuffer triggerReason = new StringBuffer();
        StringBuffer shortTriggerReason = new StringBuffer();
        boolean amTriggered = this.getExpressionState(this.triggerIntraGroupsAND, this.triggerIDs, triggerReason, shortTriggerReason, true);
        StringBuffer resetReason = new StringBuffer();
        StringBuffer shortResetReason = new StringBuffer();
        boolean amReset = this.getExpressionState(this.resetIntraGroupsAND, this.resetIDs, resetReason, shortResetReason, false);
        if (amTriggered) {
            this.context.setString(KEY_OVERALL_REASON, triggerReason.toString());
            this.context.setString(KEY_SHORT_REASON, shortTriggerReason.toString());
            if (!this.instantaneousState) {
                this.instantaneousState = true;
                this.instantaneousStateTime = SafeClock.currentTimeMillis();
            }
        } else if (amReset) {
            this.context.setString(KEY_OVERALL_REASON, resetReason.toString());
            this.context.setString(KEY_SHORT_REASON, shortResetReason.toString());
            if (this.instantaneousState) {
                this.instantaneousState = false;
                this.instantaneousStateTime = SafeClock.currentTimeMillis();
            }
        } else {
            this.context.setString(KEY_OVERALL_REASON, resetReason.toString());
            this.context.setString(KEY_SHORT_REASON, shortResetReason.toString());
        }
        if (CentralDebugging.ALERT_STATE_VERBOSE || CentralDebugging.ALERT_BASIC_ALERT_THRESHOLDS || CentralDebugging.SG_ALERTS) {
            System.out.println("[BasicAlert] " + this.getName() + " calculated state from thresholds as " + (amTriggered ? "triggered" : "reset") + " (triggered group=" + (amTriggered ? "ON" : "OFF") + ", reset group=" + (amReset ? "ON" : "OFF") + ")");
        }
    }

    @Override
    public void timePassed() {
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            it.next().timePassed();
        }
        long stateAge = SafeClock.currentTimeMillis() - this.instantaneousStateTime;
        if (CentralDebugging.ALERT_STATE_VERBOSE || CentralDebugging.ALERT_BASIC_ALERT) {
            System.out.println("[BasicAlert] " + this.getName() + " time passed (visibleState=" + this.isTriggered() + ") (instantaneousState=" + this.instantaneousState + ") (cur=" + stateAge + " vs tr=" + this.triggerMS + " / re=" + this.resetMS + ")");
        }
        if (this.instantaneousState) {
            if (stateAge > this.triggerMS) {
                if (CentralDebugging.ALERT_STATE_VERBOSE || CentralDebugging.ALERT_BASIC_ALERT) {
                    System.out.println("[BasicAlert] " + this.getName() + " Updating ongoing state to triggered");
                }
                this.updateTriggeredState(true);
            }
        } else if (stateAge > this.resetMS) {
            if (CentralDebugging.ALERT_STATE_VERBOSE || CentralDebugging.ALERT_BASIC_ALERT) {
                System.out.println("[BasicAlert] " + this.getName() + " Updating ongoing state to reset");
            }
            this.updateTriggeredState(false);
        }
        super.timePassed();
    }

    @Override
    public void securityStats(ArrayList<SecurityProduct> stats) {
        if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
            System.out.println("[BasicAlert] " + this.getName() + " Received security stats");
        }
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert alert = it.next();
            if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
                System.out.println("[BasicAlert] " + this.getName() + " passing stats to " + alert);
            }
            alert.securityStats(stats);
        }
    }

    @Override
    public void machineStats(Stats stats) {
        if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
            System.out.println("[BasicAlert] " + this.getName() + " Received machine stats");
        }
        AlertIterator it = this.getIt();
        while (it.hasNext()) {
            Alert alert = it.next();
            if (CentralDebugging.ALERT_BASIC_ALERT_INPUTS) {
                System.out.println("[BasicAlert] " + this.getName() + " passing stats to " + alert);
            }
            alert.machineStats(stats);
        }
    }

    @Override
    public String getTypeNameKey() {
        return null;
    }

    @Override
    public String getTypeDescKey() {
        return null;
    }

    @Override
    public String getTypeIconKey() {
        return null;
    }

    @Override
    public String getTypeOverlayKey() {
        return null;
    }

    @Override
    public String getDefaultName() {
        return "ERROR";
    }

    @Override
    public Alert createCorollary() {
        return this;
    }

    @Override
    public boolean canCreateCorollary() {
        return true;
    }

    public String getTriggersAsString(boolean htmlFormat) {
        String result = this.getAlertsAsString(this.triggerIDs, this.triggerIntraGroupsAND, htmlFormat);
        if (result.length() == 0) {
            return Language.get("ALERT_TRIGGERS_NONE");
        }
        return result;
    }

    public String getResetsAsString(boolean htmlFormat) {
        String result = this.getAlertsAsString(this.resetIDs, this.resetIntraGroupsAND, htmlFormat);
        if (result.length() == 0) {
            return Language.get("ALERT_RESETS_NONE");
        }
        return result;
    }

    private String getAlertsAsString(ArrayList<ArrayList<Alert>> alertIDs, boolean intraGroupAND, boolean htmlFormat) {
        int groupCount = alertIDs.size();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < alertIDs.size(); ++i) {
            if (i > 0) {
                buffer.append(" ");
                if (htmlFormat) {
                    buffer.append("<font color=").append(ColorUtils.colorToHexRGBString((Color)SHStyle.EXAMPLE_TEXT_COLOR)).append(">");
                }
                buffer.append(!intraGroupAND ? Language.get("AND") : Language.get("OR"));
                if (htmlFormat) {
                    buffer.append("</font>");
                }
                buffer.append(" ");
            }
            ArrayList<Alert> group = alertIDs.get(i);
            if (groupCount > 1 && group.size() > 1) {
                buffer.append(" (");
            }
            for (int j = 0; j < group.size(); ++j) {
                Alert alert = group.get(j);
                if (j > 0) {
                    if (htmlFormat) {
                        buffer.append("<font color=").append(ColorUtils.colorToHexRGBString((Color)SHStyle.EXAMPLE_TEXT_COLOR)).append(">");
                    }
                    buffer.append(" ").append(intraGroupAND ? Language.get("AND") : Language.get("OR")).append(" ");
                    if (htmlFormat) {
                        buffer.append("</font>");
                    }
                }
                buffer.append(alert.getName());
            }
            if (groupCount <= 1 || group.size() <= 1) continue;
            buffer.append(") ");
        }
        return buffer.toString();
    }

    static class AlertIterator {
        ArrayList<Alert> all = new ArrayList();
        int index = 0;

        public AlertIterator(ArrayList<ArrayList<Alert>> one, ArrayList<ArrayList<Alert>> two) {
            this.add(one);
            this.add(two);
        }

        void add(ArrayList<ArrayList<Alert>> one) {
            for (ArrayList<Alert> list : one) {
                for (Alert alert : list) {
                    this.all.add(alert);
                }
            }
        }

        public boolean hasNext() {
            return this.index < this.all.size();
        }

        public Alert next() {
            return this.all.get(this.index++);
        }

        public void remove() {
        }
    }

    static class FakeAlert
    extends Alert {
        FakeAlert() {
        }

        @Override
        public String getReason() {
            return null;
        }

        @Override
        public String getTypeNameKey() {
            return null;
        }

        @Override
        public boolean canCreateCorollary() {
            return true;
        }

        @Override
        public String getTypeDescKey() {
            return null;
        }

        @Override
        public String getTypeIconKey() {
            return null;
        }

        @Override
        public String getTypeOverlayKey() {
            return null;
        }

        @Override
        public String getDefaultName() {
            return "ERROR";
        }

        protected void subFromMessage(Message m) {
        }

        protected Message subToMessage() {
            return null;
        }

        @Override
        public boolean isServerSideOnly() {
            return false;
        }

        public void forceState(boolean triggered) {
            this.updateTriggeredState(triggered);
        }

        @Override
        public Alert createCorollary() {
            return this;
        }
    }
}

